/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVM80BitFloatStoreNode
extends LLVMStoreNode {
    public static LLVM80BitFloatStoreNode create() {
        return LLVM80BitFloatStoreNodeGen.create(null, null);
    }

    public abstract void executeWithTarget(LLVMPointer var1, LLVM80BitFloat var2);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, LLVM80BitFloat value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().put80BitFloat((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, LLVM80BitFloat value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached LLVM80BitFloatStoreNode store) {
        store.executeWithTarget(getReceiver.execute(addr), value);
    }

    @Specialization
    @ExplodeLoop
    protected static void doForeign(LLVMManagedPointer address, LLVM80BitFloat value, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        byte[] bytes = value.getBytes();
        assert (bytes.length == 10);
        long curOffset = address.getOffset();
        for (int i = 0; i < 10; ++i) {
            nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
            ++curOffset;
        }
    }

    @GenerateUncached
    public static abstract class LLVM80BitFloatOffsetStoreNode
    extends LLVMOffsetStoreNode {
        public static LLVM80BitFloatOffsetStoreNode create() {
            return LLVM80BitFloatStoreNodeGen.LLVM80BitFloatOffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVM80BitFloatOffsetStoreNode create(LLVMExpressionNode value) {
            return LLVM80BitFloatStoreNodeGen.LLVM80BitFloatOffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, LLVM80BitFloat var4);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, LLVM80BitFloat value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().put80BitFloat((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, LLVM80BitFloat value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVM80BitFloatOffsetStoreNode.doOpManaged(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(limit="3")
        protected static void doOpManaged(LLVMManagedPointer address, long offset, LLVM80BitFloat value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            byte[] bytes = value.getBytes();
            assert (bytes.length == 10);
            long curOffset = address.getOffset() + offset;
            for (int i = 0; i < 10; ++i) {
                nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
                ++curOffset;
            }
        }
    }
}

