/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.rmw;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="pointerNode"), @NodeChild(type=LLVMExpressionNode.class, value="valueNode")})
public abstract class LLVMI32RMWNode
extends LLVMExpressionNode {

    public static abstract class LLVMI32RMWXorNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI32(this, address, value, (a, b) -> a ^ b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = read.executeWithTarget(address);
                write.executeWithTarget(address, result ^ value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWOrNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI32(this, address, value, (a, b) -> a | b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = read.executeWithTarget(address);
                write.executeWithTarget(address, result | value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWNandNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI32(this, address, value, (a, b) -> ~(a & b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = read.executeWithTarget(address);
                write.executeWithTarget(address, ~(result & value));
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWAndNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI32(this, address, value, (a, b) -> a & b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = read.executeWithTarget(address);
                write.executeWithTarget(address, result & value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWSubNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndSubI32(this, address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = read.executeWithTarget(address);
                write.executeWithTarget(address, result - value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWAddNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndAddI32(this, address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = read.executeWithTarget(address);
                write.executeWithTarget(address, result + value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWXchgNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndSetI32(this, address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = read.executeWithTarget(address);
                write.executeWithTarget(address, value);
                return result;
            }
        }
    }
}

