/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI16LoadNode
extends LLVMLoadNode {
    public static LLVMI16LoadNode create() {
        return LLVMI16LoadNodeGen.create(null);
    }

    public abstract short executeWithTarget(Object var1);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected short doShortNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
        return language.getLLVMMemory().getI16((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected short doShortDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doShortManaged(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected short doShortManaged(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI16(addr.getObject(), addr.getOffset());
    }

    @GenerateUncached
    public static abstract class LLVMI16OffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMI16OffsetLoadNode create() {
            return LLVMI16LoadNodeGen.LLVMI16OffsetLoadNodeGen.create();
        }

        public abstract short executeWithTarget(LLVMPointer var1, long var2);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected short doShortNative(LLVMNativePointer addr, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getI16((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected short doShortDerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doShortManaged(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3")
        protected short doShortManaged(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readI16(addr.getObject(), addr.getOffset() + offset);
        }
    }
}

