/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

@GeneratedBy(value=LLVMGetElementPtrNode.class)
public final class LLVMGetElementPtrNodeGen
extends LLVMGetElementPtrNode {
    @Node.Child
    private LLVMExpressionNode base_;
    @Node.Child
    private LLVMExpressionNode offset_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMGetElementPtrNodeGen(long typeWidth, Type targetType, LLVMExpressionNode base, LLVMExpressionNode offset) {
        super(typeWidth, targetType);
        this.base_ = base;
        this.offset_ = offset;
    }

    @Override
    public LLVMExpressionNode getBase() {
        return this.base_;
    }

    @Override
    public LLVMExpressionNode getOffset() {
        return this.offset_;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1B) == 0 && state_0 != 0) {
            return this.executeGeneric_int0(state_0, frameValue);
        }
        if ((state_0 & 0x17) == 0 && state_0 != 0) {
            return this.executeGeneric_long1(state_0, frameValue);
        }
        return this.executeGeneric_generic2(state_0, frameValue);
    }

    private Object executeGeneric_int0(int state_0, VirtualFrame frameValue) {
        int offsetValue_;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        try {
            offsetValue_ = this.offset_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(baseValue_, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        if (LLVMTypes.isPointer(baseValue_)) {
            LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
            return this.doInt(baseValue__, offsetValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, offsetValue_);
    }

    private Object executeGeneric_long1(int state_0, VirtualFrame frameValue) {
        long offsetValue_;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        try {
            offsetValue_ = this.offset_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(baseValue_, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        if (LLVMTypes.isPointer(baseValue_)) {
            LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
            return this.doLong(baseValue__, offsetValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, offsetValue_);
    }

    private Object executeGeneric_generic2(int state_0, VirtualFrame frameValue) {
        LLVMPointer offsetValue__;
        LLVMPointer baseValue__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        Object offsetValue_ = this.offset_.executeGeneric(frameValue);
        if ((state_0 & 3) != 0 && LLVMTypes.isManagedPointer(baseValue_)) {
            baseValue__ = LLVMTypes.asManagedPointer(baseValue_);
            if (LLVMTypes.isManagedPointer(offsetValue_)) {
                offsetValue__ = LLVMTypes.asManagedPointer(offsetValue_);
                if ((state_0 & 1) != 0 && LLVMGetElementPtrNode.isNegated(baseValue__.getObject(), offsetValue__.getObject())) {
                    return this.doPointerDiff((LLVMManagedPointer)baseValue__, (LLVMManagedPointer)offsetValue__);
                }
                if ((state_0 & 2) != 0 && LLVMGetElementPtrNode.isNegated(offsetValue__.getObject(), baseValue__.getObject())) {
                    return this.doPointerDiffRev((LLVMManagedPointer)baseValue__, (LLVMManagedPointer)offsetValue__);
                }
            }
        }
        if ((state_0 & 0x1C) != 0 && LLVMTypes.isPointer(baseValue_)) {
            baseValue__ = LLVMTypes.asPointer(baseValue_);
            if ((state_0 & 4) != 0 && offsetValue_ instanceof Integer) {
                int offsetValue__2 = (Integer)offsetValue_;
                return this.doInt(baseValue__, offsetValue__2);
            }
            if ((state_0 & 8) != 0 && offsetValue_ instanceof Long) {
                long offsetValue__3 = (Long)offsetValue_;
                return this.doLong(baseValue__, offsetValue__3);
            }
            if ((state_0 & 0x10) != 0 && LLVMTypes.isNativePointer(offsetValue_)) {
                offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                return this.doNativePointer(baseValue__, (LLVMNativePointer)offsetValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, offsetValue_);
    }

    private LLVMPointer executeAndSpecialize(Object baseValue, Object offsetValue) {
        LLVMPointer offsetValue_;
        LLVMPointer baseValue_;
        int state_0 = this.state_0_;
        if (LLVMTypes.isManagedPointer(baseValue)) {
            baseValue_ = LLVMTypes.asManagedPointer(baseValue);
            if (LLVMTypes.isManagedPointer(offsetValue)) {
                offsetValue_ = LLVMTypes.asManagedPointer(offsetValue);
                if (LLVMGetElementPtrNode.isNegated(baseValue_.getObject(), offsetValue_.getObject())) {
                    this.state_0_ = state_0 |= 1;
                    return this.doPointerDiff((LLVMManagedPointer)baseValue_, (LLVMManagedPointer)offsetValue_);
                }
                if (LLVMGetElementPtrNode.isNegated(offsetValue_.getObject(), baseValue_.getObject())) {
                    this.state_0_ = state_0 |= 2;
                    return this.doPointerDiffRev((LLVMManagedPointer)baseValue_, (LLVMManagedPointer)offsetValue_);
                }
            }
        }
        if (LLVMTypes.isPointer(baseValue)) {
            baseValue_ = LLVMTypes.asPointer(baseValue);
            if (offsetValue instanceof Integer) {
                int offsetValue_2 = (Integer)offsetValue;
                this.state_0_ = state_0 |= 4;
                return this.doInt(baseValue_, offsetValue_2);
            }
            if (offsetValue instanceof Long) {
                long offsetValue_3 = (Long)offsetValue;
                this.state_0_ = state_0 |= 8;
                return this.doLong(baseValue_, offsetValue_3);
            }
            if (LLVMTypes.isNativePointer(offsetValue)) {
                offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                this.state_0_ = state_0 |= 0x10;
                return this.doNativePointer(baseValue_, (LLVMNativePointer)offsetValue_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_, this.offset_}, new Object[]{baseValue, offsetValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMGetElementPtrNode create(long typeWidth, Type targetType, LLVMExpressionNode base, LLVMExpressionNode offset) {
        return new LLVMGetElementPtrNodeGen(typeWidth, targetType, base, offset);
    }
}

