/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMCompareExchangeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="address"), @NodeChild(type=LLVMExpressionNode.class, value="comparisonValue"), @NodeChild(type=LLVMExpressionNode.class, value="newValue")})
public abstract class LLVMCompareExchangeNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMCMPXCHInternalNode cmpxch;

    public static LLVMCompareExchangeNode create(LLVMExpressionNode resultAllocation, AggregateType returnType, DataLayout dataLayout, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) throws Type.TypeOverflowException {
        long secondValueOffset = returnType.getOffsetOf(1L, dataLayout);
        return LLVMCompareExchangeNodeGen.create(resultAllocation, secondValueOffset, address, comparisonValue, newValue);
    }

    public LLVMCompareExchangeNode(LLVMExpressionNode resultAllocation, long secondValueOffset) {
        this.cmpxch = LLVMCompareExchangeNodeGen.LLVMCMPXCHInternalNodeGen.create(resultAllocation, secondValueOffset);
    }

    @Specialization
    protected Object doOp(VirtualFrame frame, LLVMPointer address, Object comparisonValue, Object newValue) {
        return this.cmpxch.executeWithTarget(frame, address, comparisonValue, newValue);
    }

    static abstract class LLVMCMPXCHInternalNode
    extends LLVMNode {
        private final long secondValueOffset;
        @Node.Child
        private LLVMExpressionNode resultAllocation;

        LLVMCMPXCHInternalNode(LLVMExpressionNode resultAllocation, long secondValueOffset) {
            this.resultAllocation = resultAllocation;
            this.secondValueOffset = secondValueOffset;
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, byte comparisonValue, byte newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI8 compareAndSwapI8 = memory.compareAndSwapI8(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame);
            memory.putI8((Node)this, allocation, compareAndSwapI8.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI8.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, short comparisonValue, short newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI16 compareAndSwapI16 = memory.compareAndSwapI16(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame);
            memory.putI16((Node)this, allocation, compareAndSwapI16.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI16.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, int comparisonValue, int newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI32 compareAndSwapI32 = memory.compareAndSwapI32(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame);
            memory.putI32((Node)this, allocation, compareAndSwapI32.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI32.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, long comparisonValue, long newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI64 compareAndSwapI64 = memory.compareAndSwapI64(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame);
            memory.putI64((Node)this, allocation, compareAndSwapI64.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI64.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, LLVMNativePointer comparisonValue, LLVMNativePointer newValue, @CachedLanguage LLVMLanguage language) {
            return this.doOp(frame, address, comparisonValue.asNative(), newValue.asNative(), language);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, byte comparisonValue, byte newValue, @Cached LLVMI8LoadNode read, @Cached LLVMI8StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame);
                byte currentValue = read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI8((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, short comparisonValue, short newValue, @Cached LLVMI16LoadNode read, @Cached LLVMI16StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame);
                short currentValue = read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI16((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, int comparisonValue, int newValue, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame);
                int currentValue = read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI32((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, long comparisonValue, long newValue, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame);
                long currentValue = (Long)read.executeWithTargetGeneric(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI64((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, LLVMNativePointer comparisonValue, LLVMNativePointer newValue, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write, @CachedLanguage LLVMLanguage language) {
            return this.doOp(frame, address, comparisonValue.asNative(), newValue.asNative(), read, write, language);
        }

        private LLVMNativePointer allocateResult(VirtualFrame frame) {
            return LLVMNativePointer.cast(this.resultAllocation.executeGeneric(frame));
        }
    }
}

