/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMPThreadStart;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMThreadException;
import com.oracle.truffle.llvm.runtime.pthread.PThreadExitException;

public final class LLVMPThreadThreadIntrinsics {

    public static abstract class LLVMPThreadSelf
    extends LLVMBuiltin {
        @Specialization
        protected LLVMNativePointer doIntrinsic() {
            return LLVMNativePointer.create(LLVMPThreadSelf.getThreadId());
        }

        @CompilerDirectives.TruffleBoundary
        private static long getThreadId() {
            return Thread.currentThread().getId();
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="threadId")
    public static abstract class LLVMPThreadJoin
    extends LLVMBuiltin {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object doIntrinsic(long threadId, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            Thread thread = context.getpThreadContext().getThread(threadId);
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new LLVMThreadException(this, "Failed to join thread", e);
                }
            }
            return context.getpThreadContext().getThreadReturnValue(threadId);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="retval")
    public static abstract class LLVMPThreadExit
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(Object returnValue, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMPThreadExit.setThreadReturnValue(returnValue, context);
            throw new PThreadExitException();
        }

        @CompilerDirectives.TruffleBoundary
        private static void setThreadReturnValue(Object returnValue, LLVMContext context) {
            context.getpThreadContext().setThreadReturnValue(Thread.currentThread().getId(), returnValue);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="thread"), @NodeChild(type=LLVMExpressionNode.class, value="startRoutine"), @NodeChild(type=LLVMExpressionNode.class, value="arg")})
    public static abstract class LLVMPThreadCreate
    extends LLVMBuiltin {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected int doIntrinsic(LLVMPointer thread, LLVMPointer startRoutine, LLVMPointer arg, @Cached LLVMI64StoreNode store, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMPThreadStart.LLVMPThreadRunnable init = new LLVMPThreadStart.LLVMPThreadRunnable(startRoutine, arg, context, true);
            Thread t = context.getpThreadContext().createThread(init);
            if (t == null) {
                return 11;
            }
            store.executeWithTarget(thread, t.getId());
            t.start();
            return 0;
        }
    }
}

