/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMSourceTypeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.VarargsAreaStackAllocationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_64VaListStorageFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativeVarargsAreaStackAllocationNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativeVarargsAreaStackAllocationNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMove;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.ArrayList;
import java.util.Arrays;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class), @ExportLibrary(value=LLVMManagedWriteLibrary.class), @ExportLibrary(value=LLVMVaListLibrary.class), @ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=NativeTypeLibrary.class)})
public final class LLVMX86_64VaListStorage
implements TruffleObject {
    public static final ArrayType VA_LIST_TYPE = new ArrayType(StructureType.createNamedFromList("struct.__va_list_tag", false, new ArrayList<Type>(Arrays.asList(PrimitiveType.I32, PrimitiveType.I32, PointerType.I8, PointerType.I8))), 1L);
    private static final String GET_MEMBER = "get";
    private Object[] realArguments;
    private int numberOfExplicitArguments;
    private int initGPOffset;
    private int gpOffset;
    private int initFPOffset;
    private int fpOffset;
    private RegSaveArea regSaveArea;
    private LLVMPointer regSaveAreaPtr;
    private OverflowArgArea overflowArgArea;
    private LLVMNativePointer nativized;
    private LLVMPointer overflowArgAreaBaseNativePtr;
    private final LLVMRootNode rootNode;

    public LLVMX86_64VaListStorage(RootNode rootNode) {
        assert (rootNode instanceof LLVMRootNode);
        this.rootNode = (LLVMRootNode)rootNode;
    }

    public boolean isNativized() {
        return this.nativized != null;
    }

    @ExportMessage
    boolean hasNativeType() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getNativeType(@CachedLanguage LLVMLanguage language) {
        return language.getInteropType(LLVMSourceTypeFactory.resolveType(VA_LIST_TYPE, LLVMX86_64VaListStorage.getDataLayout()));
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        return new VAListMembers();
    }

    @ExportMessage
    public boolean isMemberInvocable(String member) {
        return GET_MEMBER.equals(member);
    }

    @ExportMessage
    public Object invokeMember(String member, Object[] arguments, @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
        if (GET_MEMBER.equals(member)) {
            if (arguments.length == 2) {
                if (!(arguments[0] instanceof Integer)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw UnsupportedTypeException.create((Object[])new Object[]{arguments[0]}, (String)"Index argument must be an integer");
                }
                int i = (Integer)arguments[0];
                if (i >= this.realArguments.length - this.numberOfExplicitArguments) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new ArrayIndexOutOfBoundsException(i);
                }
                Object arg = this.realArguments[this.numberOfExplicitArguments + i];
                if (!(arguments[1] instanceof LLVMInteropType.Structured)) {
                    return arg;
                }
                LLVMInteropType.Structured type = (LLVMInteropType.Structured)arguments[1];
                if (!LLVMPointer.isInstance(arg)) {
                    return arg;
                }
                LLVMPointer ptrArg = LLVMPointer.cast(arg);
                return pointerEscapeNode.executeWithType(ptrArg, type);
            }
            throw ArityException.create((int)2, (int)arguments.length);
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return this.realArguments.length - this.numberOfExplicitArguments;
    }

    @ExportMessage
    public boolean isArrayElementReadable(long index) {
        return index < (long)(this.realArguments.length - this.numberOfExplicitArguments);
    }

    @ExportMessage
    public Object readArrayElement(long index) {
        return this.realArguments[(int)index + this.numberOfExplicitArguments];
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    @ExportMessage
    byte readI8(long offset) {
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("Should not get here");
    }

    @ExportMessage
    short readI16(long offset) {
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("Should not get here");
    }

    @ExportMessage
    Object readGenericI64(long offset) {
        switch ((int)offset) {
            case 8: {
                return this.overflowArgArea.getCurrentArgPtr();
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("Should not get here");
    }

    @ExportMessage
    void writeI8(long offset, byte value) {
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("Should not get here");
    }

    @ExportMessage
    void writeI16(long offset, short value) {
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("Should not get here");
    }

    @ExportMessage
    void writeGenericI64(long offset, Object value) {
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("Should not get here");
    }

    private static VarArgArea getVarArgArea(Object arg) {
        if (arg instanceof Boolean) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Byte) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Short) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Integer) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Long) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Float) {
            return VarArgArea.FP_AREA;
        }
        if (arg instanceof Double) {
            return VarArgArea.FP_AREA;
        }
        if (arg instanceof LLVMVarArgCompoundValue) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (LLVMPointer.isInstance(arg)) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof LLVM80BitFloat) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (arg instanceof LLVMFloatVector && ((LLVMFloatVector)arg).getLength() <= 2) {
            return VarArgArea.FP_AREA;
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError(arg);
    }

    private static VarArgArea getVarArgArea(Type type) {
        if (type == PrimitiveType.I1) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I8) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I16) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I32) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I64) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.FLOAT) {
            return VarArgArea.FP_AREA;
        }
        if (type == PrimitiveType.DOUBLE) {
            return VarArgArea.FP_AREA;
        }
        if (type == PrimitiveType.X86_FP80) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (LLVMX86_64VaListStorage.isFloatVectorWithMaxTwoElems(type)) {
            return VarArgArea.FP_AREA;
        }
        if (type instanceof PointerType) {
            return VarArgArea.GP_AREA;
        }
        return VarArgArea.OVERFLOW_AREA;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isFloatVectorWithMaxTwoElems(Type type) {
        return type instanceof VectorType && LLVMX86_64VaListStorage.getElementType(type) == PrimitiveType.FLOAT && ((VectorType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    private static Type getElementType(Type type) {
        return ((VectorType)type).getElementType();
    }

    private static int calculateUsedFpArea(Object[] realArguments, int numberOfExplicitArguments) {
        assert (numberOfExplicitArguments <= realArguments.length);
        int usedFpArea = 0;
        int fpAreaLimit = 128;
        for (int i = 0; i < numberOfExplicitArguments && usedFpArea < 128; ++i) {
            if (LLVMX86_64VaListStorage.getVarArgArea(realArguments[i]) != VarArgArea.FP_AREA) continue;
            usedFpArea += 16;
        }
        return usedFpArea;
    }

    @ExplodeLoop
    private static int calculateUsedGpArea(Object[] realArguments, int numberOfExplicitArguments) {
        assert (numberOfExplicitArguments <= realArguments.length);
        int usedGpArea = 0;
        for (int i = 0; i < numberOfExplicitArguments && usedGpArea < 48; ++i) {
            if (LLVMX86_64VaListStorage.getVarArgArea(realArguments[i]) != VarArgArea.GP_AREA) continue;
            usedGpArea += 8;
        }
        return usedGpArea;
    }

    @ExportMessage
    void cleanup() {
    }

    private static long getArgPtrFromNativePtr(LLVMX86_64VaListStorage srcVaList, LLVMManagedReadLibrary readLib) {
        long baseAddr;
        long curAddr;
        LLVMPointer overflowAreaPtr = readLib.readPointer(srcVaList, 8L);
        if (LLVMNativePointer.isInstance(overflowAreaPtr)) {
            curAddr = LLVMNativePointer.cast(overflowAreaPtr).asNative();
            baseAddr = LLVMNativePointer.cast(srcVaList.overflowArgAreaBaseNativePtr).asNative();
        } else {
            curAddr = LLVMManagedPointer.cast(overflowAreaPtr).getOffset();
            baseAddr = LLVMManagedPointer.cast(srcVaList.overflowArgAreaBaseNativePtr).getOffset();
        }
        return curAddr - baseAddr;
    }

    @ExportMessage
    Object shift(Type type, @CachedLibrary(value="this") LLVMManagedReadLibrary readLib, @CachedLibrary(value="this") LLVMManagedWriteLibrary writeLib, @Cached BranchProfile regAreaProfile, @Cached(value="createBinaryProfile()") ConditionProfile isNativizedProfile) {
        int regSaveOffs = 0;
        int regSaveStep = 0;
        int regSaveLimit = 0;
        boolean lookIntoRegSaveArea = true;
        VarArgArea varArgArea = LLVMX86_64VaListStorage.getVarArgArea(type);
        switch (varArgArea) {
            case GP_AREA: {
                regSaveOffs = 0;
                regSaveStep = 8;
                regSaveLimit = 48;
                break;
            }
            case FP_AREA: {
                regSaveOffs = 4;
                regSaveStep = 16;
                regSaveLimit = 176;
                break;
            }
            case OVERFLOW_AREA: {
                lookIntoRegSaveArea = false;
            }
        }
        if (lookIntoRegSaveArea) {
            regAreaProfile.enter();
            int offs = readLib.readI32(this, regSaveOffs);
            if (offs < regSaveLimit) {
                writeLib.writeI32(this, regSaveOffs, offs + regSaveStep);
                long n = this.regSaveArea.offsetToIndex(offs);
                int i = (int)(n << 32 >> 32);
                return this.regSaveArea.args[i];
            }
        }
        if (isNativizedProfile.profile(this.isNativized())) {
            this.overflowArgArea.setOffset(LLVMX86_64VaListStorage.getArgPtrFromNativePtr(this, readLib));
            Object currentArg = this.overflowArgArea.getCurrentArg();
            this.overflowArgArea.shift(1);
            long shiftOffs = this.overflowArgArea.getOffset();
            LLVMPointer shiftedOverflowAreaPtr = this.overflowArgAreaBaseNativePtr.increment(shiftOffs);
            writeLib.writePointer(this, 8L, shiftedOverflowAreaPtr);
            return currentArg;
        }
        Object currentArg = this.overflowArgArea.getCurrentArg();
        this.overflowArgArea.shift(1);
        return currentArg;
    }

    LLVMExpressionNode createAllocaNode(LLVMLanguage language) {
        DataLayout dataLayout = LLVMX86_64VaListStorage.getDataLayout();
        return language.getActiveConfiguration().createNodeFactory(language, dataLayout).createAlloca(VA_LIST_TYPE, 16);
    }

    LLVMExpressionNode createAllocaNodeUncached(LLVMLanguage language) {
        DataLayout dataLayout = LLVMX86_64VaListStorage.getDataLayout();
        LLVMExpressionNode alloca = language.getActiveConfiguration().createNodeFactory(language, dataLayout).createAlloca(VA_LIST_TYPE, 16);
        if (alloca instanceof LLVMStack.LLVMGetStackSpaceInstruction) {
            ((LLVMStack.LLVMGetStackSpaceInstruction)alloca).setStackAccess(this.rootNode.getStackAccess());
        }
        return alloca;
    }

    VarargsAreaStackAllocationNode createVarargsAreaStackAllocationNode(LLVMContext llvmCtx) {
        DataLayout dataLayout = LLVMX86_64VaListStorage.getDataLayout();
        return llvmCtx.getLanguage().getActiveConfiguration().createNodeFactory(llvmCtx.getLanguage(), dataLayout).createVarargsAreaStackAllocation();
    }

    private static DataLayout getDataLayout() {
        RootCallTarget rootCallTarget = (RootCallTarget)Truffle.getRuntime().getCurrentFrame().getCallTarget();
        DataLayout dataLayout = ((LLVMHasDatalayoutNode)rootCallTarget.getRootNode()).getDatalayout();
        return dataLayout;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void toNative(@CachedLanguage LLVMLanguage language, @Cached(value="this.createAllocaNode(language)", uncached="this.createAllocaNodeUncached(language)") LLVMExpressionNode allocaNode, @Cached NativeAllocaInstruction stackAllocationNode, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, @Cached NativeProfiledMemMove memMove, @Cached BranchProfile nativizedProfile) {
        if (this.nativized != null) {
            nativizedProfile.enter();
            return;
        }
        VirtualFrame frame = (VirtualFrame)Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE);
        this.nativized = LLVMNativePointer.cast(allocaNode.executeGeneric(frame));
        if (this.overflowArgArea == null) {
            return;
        }
        LLVMPointer regSaveAreaNativePtr = this.allocateNativeAreas(stackAllocationNode, gpOffsetStore, fpOffsetStore, overflowArgAreaStore, regSaveAreaStore, frame);
        LLVMX86_64VaListStorage.initNativeAreas(this.realArguments, this.numberOfExplicitArguments, this.initGPOffset, this.initFPOffset, regSaveAreaNativePtr, this.overflowArgAreaBaseNativePtr, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
    }

    private LLVMPointer allocateNativeAreas(NativeAllocaInstruction stackAllocationNode, LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, VirtualFrame frame) {
        LLVMPointer regSaveAreaNativePtr = stackAllocationNode.executeWithTarget(frame, 176L, this.rootNode.getStackAccess());
        this.overflowArgAreaBaseNativePtr = stackAllocationNode.executeWithTarget(frame, this.overflowArgArea.overflowAreaSize, this.rootNode.getStackAccess());
        gpOffsetStore.executeWithTarget(this.nativized, 0L, this.gpOffset);
        fpOffsetStore.executeWithTarget(this.nativized, 4L, this.fpOffset);
        overflowArgAreaStore.executeWithTarget(this.nativized, 8L, this.overflowArgAreaBaseNativePtr.increment(this.overflowArgArea.getOffset()));
        regSaveAreaStore.executeWithTarget(this.nativized, 16L, regSaveAreaNativePtr);
        return regSaveAreaNativePtr;
    }

    private static void initNativeAreas(Object[] realArguments, int numberOfExplicitArguments, int initGPOffset, int initFPOffset, LLVMPointer regSaveAreaNativePtr, LLVMPointer overflowArgAreaBaseNativePtr, LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, LLVMMemMoveNode memMove) {
        int gp = initGPOffset;
        int fp = initFPOffset;
        int vaLength = realArguments.length - numberOfExplicitArguments;
        if (vaLength > 0) {
            int overflowOffset = 0;
            for (int i = 0; i < vaLength; ++i) {
                Object object = realArguments[numberOfExplicitArguments + i];
                VarArgArea area = LLVMX86_64VaListStorage.getVarArgArea(object);
                if (area == VarArgArea.GP_AREA && gp < 48) {
                    LLVMX86_64VaListStorage.storeArgument(regSaveAreaNativePtr, gp, memMove, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, object);
                    gp += 8;
                    continue;
                }
                if (area == VarArgArea.FP_AREA && fp < 176) {
                    LLVMX86_64VaListStorage.storeArgument(regSaveAreaNativePtr, fp, memMove, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, object);
                    fp += 16;
                    continue;
                }
                overflowOffset = (int)((long)overflowOffset + LLVMX86_64VaListStorage.storeArgument(overflowArgAreaBaseNativePtr, overflowOffset, memMove, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, object));
            }
        }
    }

    private static long storeArgument(LLVMPointer ptr, long offset, LLVMMemMoveNode memmove, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64Node, LLVMI32StoreNode.LLVMI32OffsetStoreNode storeI32Node, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode storeFP80Node, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storePointerNode, Object object) {
        if (object instanceof Number) {
            return LLVMX86_64VaListStorage.doPrimitiveWrite(ptr, offset, storeI64Node, object);
        }
        if (object instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)object;
            LLVMPointer currentPtr = ptr.increment(offset);
            memmove.executeWithTarget(currentPtr, obj.getAddr(), obj.getSize());
            return obj.getSize();
        }
        if (LLVMPointer.isInstance(object)) {
            storePointerNode.executeWithTarget(ptr, offset, object);
            return 8L;
        }
        if (object instanceof LLVM80BitFloat) {
            storeFP80Node.executeWithTarget(ptr, offset, (LLVM80BitFloat)object);
            return 16L;
        }
        if (object instanceof LLVMFloatVector) {
            LLVMFloatVector floatVec = (LLVMFloatVector)object;
            for (int i = 0; i < floatVec.getLength(); ++i) {
                storeI32Node.executeWithTarget(ptr, offset + (long)(i * 4), Float.floatToIntBits(floatVec.getValue(i)));
            }
            return floatVec.getLength() * 4;
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError(object);
    }

    private static int doPrimitiveWrite(LLVMPointer ptr, long offset, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeNode, Object arg) throws AssertionError {
        long value;
        if (arg instanceof Boolean) {
            value = (Boolean)arg != false ? 1L : 0L;
        } else if (arg instanceof Byte) {
            value = Integer.toUnsignedLong(((Byte)arg).byteValue());
        } else if (arg instanceof Short) {
            value = Integer.toUnsignedLong(((Short)arg).shortValue());
        } else if (arg instanceof Integer) {
            value = Integer.toUnsignedLong((Integer)arg);
        } else if (arg instanceof Long) {
            value = (Long)arg;
        } else if (arg instanceof Float) {
            value = Integer.toUnsignedLong(Float.floatToIntBits(((Float)arg).floatValue()));
        } else if (arg instanceof Double) {
            value = Double.doubleToRawLongBits((Double)arg);
        } else {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(arg);
        }
        storeNode.executeWithTarget(ptr, offset, value);
        return 8;
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativized != null && LLVMNativePointer.isInstance(this.nativized);
    }

    @ExportMessage
    long asPointer() {
        return this.nativized == null ? 0L : this.nativized.asNative();
    }

    static /* synthetic */ Object[] access$602(LLVMX86_64VaListStorage x0, Object[] x1) {
        x0.realArguments = x1;
        return x1;
    }

    public static final class NativeAllocaInstructionUncached
    extends NativeAllocaInstruction {
        private static final long size = 1L;
        private static final int alignment = 8;
        static final NativeAllocaInstructionUncached UNCACHED = new NativeAllocaInstructionUncached();

        @Override
        public LLVMPointer executeWithTarget(VirtualFrame frame, long sizeInBytes, LLVMStack.LLVMStackAccess stackAccess) {
            return stackAccess.executeAllocate(frame, 1L * sizeInBytes, 8);
        }
    }

    public static final class NativeAllocaInstructionCached
    extends NativeAllocaInstruction {
        @Node.Child
        private LLVMNativeVarargsAreaStackAllocationNode nativeAllocaNode = LLVMNativeVarargsAreaStackAllocationNodeGen.create();

        @Override
        public LLVMPointer executeWithTarget(VirtualFrame frame, long sizeInBytes, LLVMStack.LLVMStackAccess stackAccess) {
            return this.nativeAllocaNode.executeWithTarget(frame, sizeInBytes);
        }
    }

    public static abstract class NativeAllocaInstruction
    extends LLVMNode {
        public static NativeAllocaInstruction create() {
            return new NativeAllocaInstructionCached();
        }

        public static NativeAllocaInstruction getUncached() {
            return NativeAllocaInstructionUncached.UNCACHED;
        }

        public abstract LLVMPointer executeWithTarget(VirtualFrame var1, long var2, LLVMStack.LLVMStackAccess var4);
    }

    @GenerateUncached
    static abstract class PointerConversionHelperNode
    extends NumberConversionHelperNode {
        PointerConversionHelperNode() {
        }

        @Specialization
        LLVMPointer pointerConversion(LLVMPointer p, int offset) {
            assert (offset == 0);
            return p;
        }

        @Specialization
        LLVMPointer longObjectConversion(long x, int offset) {
            assert (offset == 0);
            return LLVMNativePointer.create(x);
        }

        @Specialization
        LLVMPointer intObjectConversion(int x, int offset) {
            assert (offset == 0);
            return LLVMNativePointer.create(x);
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        LLVMPointer compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        LLVMPointer compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readPointer(ptr.getObject(), offset);
        }

        @Fallback
        LLVMPointer fallackConversion(Object x, int offset) {
            return LLVMNativePointer.createNull();
        }

        static PointerConversionHelperNode create() {
            return LLVMX86_64VaListStorageFactory.PointerConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    static abstract class LongConversionHelperNode
    extends NumberConversionHelperNode {
        LongConversionHelperNode() {
        }

        @Specialization
        long byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x.longValue();
        }

        @Specialization
        long shortConversion(Short x, int offset) {
            assert (offset == 0);
            return x.longValue();
        }

        @Specialization
        long intConversion(Integer x, int offset) {
            assert (offset == 0);
            return x.longValue();
        }

        @Specialization
        long longConversion(Long x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        long doubleConversion(Double x, int offset) {
            assert (offset == 0);
            return Double.doubleToLongBits(x);
        }

        @Specialization
        long floatVectorConversion(LLVMFloatVector x, int offset) {
            int index = offset / 4;
            assert (index + 1 < x.getLength());
            long low = Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
            long high = Float.floatToIntBits(((Float)x.getElement(index + 1)).floatValue());
            return low + (high << 32);
        }

        @Specialization
        long doubleVectorConversion(LLVMDoubleVector x, int offset) {
            int index = offset / 8;
            assert (index < x.getLength());
            return Double.doubleToLongBits((Double)x.getElement(index));
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        long compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode offsetLoad) {
            try {
                return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException("Should not get here");
            }
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        Object compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readGenericI64(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        long nativePointerConversion(LLVMPointer x, int offset) {
            assert (offset == 0);
            return LLVMNativePointer.cast(x).asNative();
        }

        @Specialization(guards={"isManagedPointer(x)"})
        Object managedPointerConversion(LLVMPointer x, int offset) {
            assert (offset == 0);
            return x;
        }

        static LongConversionHelperNode create() {
            return LLVMX86_64VaListStorageFactory.LongConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    static abstract class IntegerConversionHelperNode
    extends NumberConversionHelperNode {
        IntegerConversionHelperNode() {
        }

        @Specialization
        int byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x.intValue();
        }

        @Specialization
        int shortConversion(Short x, int offset) {
            assert (offset == 0);
            return x.intValue();
        }

        @Specialization
        int intConversion(Integer x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        int longConversion(Long x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile) {
            if (conditionProfile.profile(offset == 0)) {
                return x.intValue();
            }
            assert (offset == 4) : "Illegal long offset " + offset;
            return (int)(x >> 32);
        }

        @Specialization
        int doubleConversion(Double x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile) {
            return this.longConversion(Double.doubleToLongBits(x), offset, conditionProfile);
        }

        @Specialization
        int floatVectorConversion(LLVMFloatVector x, int offset) {
            int index = offset / 4;
            assert (index < x.getLength());
            return Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        int compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        int compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readI32(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        int nativePointerObjectConversion(LLVMNativePointer x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile) {
            return this.longConversion(LLVMNativePointer.cast(x).asNative(), offset, conditionProfile);
        }

        @Specialization(guards={"!isNativePointer(x)"})
        int managedPointerObjectConversion(LLVMManagedPointer x, int offset, @CachedLibrary(limit="1") LLVMNativeLibrary nativeLib, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile) {
            LLVMNativePointer nativePointer = nativeLib.toNativePointer(x.getObject());
            return this.nativePointerObjectConversion(nativePointer, offset, conditionProfile);
        }

        static IntegerConversionHelperNode create() {
            return LLVMX86_64VaListStorageFactory.IntegerConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    static abstract class ShortConversionHelperNode
    extends NumberConversionHelperNode {
        ShortConversionHelperNode() {
        }

        @Specialization
        short byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x.shortValue();
        }

        @Specialization
        short shortConversion(Short x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        short intConversion(Integer x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile) {
            if (conditionProfile.profile(offset == 0)) {
                return x.shortValue();
            }
            assert (offset == 2) : "Illegal integer offset " + offset;
            return (short)(x >> 16);
        }

        @Specialization
        short longConversion(Long x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2) {
            if (conditionProfile1.profile(offset < 4)) {
                return this.intConversion(x.intValue(), offset, conditionProfile2);
            }
            return this.intConversion((int)(x >> 32), offset % 4, conditionProfile2);
        }

        @Specialization
        short doubleConversion(Double x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2) {
            return this.longConversion(Double.doubleToLongBits(x), offset, conditionProfile1, conditionProfile2);
        }

        @Specialization
        short floatVectorConversion(LLVMFloatVector x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile) {
            int index = offset / 4;
            assert (index < x.getLength());
            int fi = Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
            return this.intConversion(fi, offset, conditionProfile);
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        short compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            return compObjReadLib.readI16(x.getAddr(), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        short compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readI16(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        short nativePointerObjectConversion(LLVMNativePointer x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2) {
            return this.longConversion(x.asNative(), offset, conditionProfile1, conditionProfile2);
        }

        @Specialization(guards={"!isNativePointer(x)"})
        short managedPointerObjectConversion(LLVMManagedPointer x, int offset, @CachedLibrary(limit="1") LLVMNativeLibrary nativeLib, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2) {
            LLVMNativePointer nativePointer = nativeLib.toNativePointer(x.getObject());
            return this.nativePointerObjectConversion(nativePointer, offset, conditionProfile1, conditionProfile2);
        }

        static ShortConversionHelperNode create() {
            return LLVMX86_64VaListStorageFactory.ShortConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    static abstract class ByteConversionHelperNode
    extends NumberConversionHelperNode {
        ByteConversionHelperNode() {
        }

        @Specialization
        byte byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        byte shortConversion(Short x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile) {
            if (conditionProfile.profile(offset == 0)) {
                return x.byteValue();
            }
            assert (offset == 1) : "Illegal short offset " + offset;
            return (byte)(x >> 8);
        }

        @Specialization
        byte intConversion(Integer x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2) {
            if (conditionProfile1.profile(offset < 2)) {
                return this.shortConversion(x.shortValue(), offset, conditionProfile2);
            }
            return this.shortConversion((short)(x >> 16), offset % 2, conditionProfile2);
        }

        @Specialization
        byte longConversion(Long x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile3) {
            if (conditionProfile1.profile(offset < 4)) {
                return this.intConversion(x.intValue(), offset, conditionProfile2, conditionProfile3);
            }
            return this.intConversion((int)(x >> 32), offset % 4, conditionProfile2, conditionProfile3);
        }

        @Specialization
        byte doubleConversion(Double x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile3) {
            return this.longConversion(Double.doubleToLongBits(x), offset, conditionProfile1, conditionProfile2, conditionProfile3);
        }

        @Specialization
        byte float80Conversion(LLVM80BitFloat x, int offset) {
            assert (offset < 10);
            return x.getBytes()[offset];
        }

        @Specialization
        byte floatVectorConversion(LLVMFloatVector x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2) {
            int index = offset / 4;
            assert (index < x.getLength());
            int fi = Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
            return this.intConversion(fi, offset, conditionProfile1, conditionProfile2);
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        byte compoundObjectConversionNative(LLVMVarArgCompoundValue x, int offset, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        byte compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readI8(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        byte nativePointerObjectConversion(LLVMNativePointer x, int offset, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile3) {
            return this.longConversion(x.asNative(), offset, conditionProfile1, conditionProfile2, conditionProfile3);
        }

        @Specialization(guards={"!isNativePointer(x)"})
        byte managedPointerObjectConversion(LLVMManagedPointer x, int offset, @CachedLibrary(limit="1") LLVMNativeLibrary nativeLib, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile1, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile2, @Cached(value="createBinaryProfile()") ConditionProfile conditionProfile3) {
            LLVMNativePointer nativePointer = nativeLib.toNativePointer(x.getObject());
            return this.nativePointerObjectConversion(nativePointer, offset, conditionProfile1, conditionProfile2, conditionProfile3);
        }

        static ByteConversionHelperNode create() {
            return LLVMX86_64VaListStorageFactory.ByteConversionHelperNodeGen.create();
        }
    }

    static abstract class NumberConversionHelperNode
    extends LLVMNode {
        NumberConversionHelperNode() {
        }

        abstract Object execute(Object var1, int var2);

        static boolean isNativePointer(Object x) {
            return LLVMNativePointer.isInstance(x);
        }

        static boolean isManagedPointer(Object x) {
            return LLVMManagedPointer.isInstance(x);
        }
    }

    @ExportLibrary(value=NativeTypeLibrary.class)
    public static final class OverflowArgArea
    extends ArgsArea
    implements Cloneable {
        private final long[] offsets;
        final int overflowAreaSize;
        private long currentOffset;

        OverflowArgArea(Object[] args, long[] offsets, int overflowAreaSize) {
            super(args);
            this.overflowAreaSize = overflowAreaSize;
            this.offsets = offsets;
            this.currentOffset = offsets[0];
        }

        @Override
        protected long offsetToIndex(long offset) {
            int i;
            if (offset < 0L) {
                return -1L;
            }
            for (i = 0; i < this.offsets.length; ++i) {
                if (this.offsets[i] < 0L) {
                    if (offset < (long)this.overflowAreaSize) {
                        long j = offset - this.offsets[i - 1];
                        return (long)(i - 1) + (j << 32);
                    }
                    return -1L;
                }
                if (offset == this.offsets[i]) {
                    return i;
                }
                if (offset >= this.offsets[i]) continue;
                assert (i > 0);
                long j = offset - this.offsets[i - 1];
                return (long)(i - 1) + (j << 32);
            }
            i = this.offsets.length - 1;
            long j = offset - this.offsets[i];
            return (long)i + (j << 32);
        }

        void shift(int steps) {
            long n = this.offsetToIndex(this.currentOffset);
            int i = (int)(n << 32 >> 32);
            this.currentOffset = this.offsets[i + steps];
        }

        void setOffset(long newOffset) {
            this.currentOffset = newOffset;
        }

        Object getCurrentArg() {
            long n = this.offsetToIndex(this.currentOffset);
            int i = (int)(n << 32 >> 32);
            return i < 0 ? null : this.args[i];
        }

        int getCurrentArgIndex() {
            long n = this.offsetToIndex(this.currentOffset);
            int i = (int)(n << 32 >> 32);
            return i;
        }

        LLVMManagedPointer getCurrentArgPtr() {
            return LLVMManagedPointer.create(this, this.currentOffset);
        }

        long getOffset() {
            return this.currentOffset;
        }

        public OverflowArgArea clone() {
            OverflowArgArea cloned = new OverflowArgArea(this.args, this.offsets, this.overflowAreaSize);
            cloned.currentOffset = this.currentOffset;
            return cloned;
        }

        @ExportMessage
        public boolean hasNativeType() {
            return true;
        }

        @ExportMessage
        public Object getNativeType() {
            return OverflowArgArea.getVarArgType(this.getCurrentArg());
        }
    }

    @ExportLibrary(value=NativeTypeLibrary.class)
    public static final class RegSaveArea
    extends ArgsArea {
        private final int[] gpIdx;
        private final int[] fpIdx;
        private final int numOfExpArgs;
        private int curArg;

        RegSaveArea(Object[] args, int[] gpIdx, int[] fpIdx, int numOfExpArgs) {
            super(args);
            this.gpIdx = gpIdx;
            this.fpIdx = fpIdx;
            this.numOfExpArgs = numOfExpArgs;
        }

        @Override
        protected long offsetToIndex(long offset) {
            if (offset < 0L) {
                return -1L;
            }
            if (offset < 48L) {
                long i = offset / 8L;
                long j = offset % 8L;
                return i >= (long)this.gpIdx.length ? -1L : (long)this.gpIdx[(int)i] + (j << 32);
            }
            assert (offset < 176L);
            long i = (offset - 48L) / 16L;
            long j = (offset - 48L) % 16L;
            return i >= (long)this.fpIdx.length ? -1L : (long)this.fpIdx[(int)i] + (j << 32);
        }

        void shift() {
            ++this.curArg;
        }

        @ExportMessage
        public boolean hasNativeType() {
            return true;
        }

        @ExportMessage
        public Object getNativeType() {
            if (this.curArg < this.numOfExpArgs) {
                this.curArg = this.numOfExpArgs;
            }
            Object arg = this.curArg < this.args.length ? this.args[this.curArg] : null;
            return RegSaveArea.getVarArgType(arg);
        }
    }

    @ExportLibrary(value=LLVMManagedReadLibrary.class)
    public static abstract class ArgsArea
    implements TruffleObject {
        final Object[] args;
        private static final LLVMInteropType.Array I8_ARG_TYPE = LLVMInteropType.ValueKind.I8.type.toArray(8L);
        private static final LLVMInteropType.Array I16_ARG_TYPE = LLVMInteropType.ValueKind.I16.type.toArray(4L);
        private static final LLVMInteropType.Array I32_ARG_TYPE = LLVMInteropType.ValueKind.I32.type.toArray(2L);
        private static final LLVMInteropType.Array I64_ARG_TYPE = LLVMInteropType.ValueKind.I64.type.toArray(1L);
        private static final LLVMInteropType.Array F80_ARG_TYPE = LLVMInteropType.ValueKind.I64.type.toArray(2L);

        ArgsArea(Object[] args) {
            this.args = args;
        }

        protected abstract long offsetToIndex(long var1);

        @ExportMessage
        boolean isReadable() {
            return true;
        }

        @ExportMessage
        byte readI8(long offset, @Cached ByteConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            if (i < 0) {
                return 0;
            }
            return (Byte)convNode.execute(this.args[i], j);
        }

        @ExportMessage
        short readI16(long offset, @Cached ShortConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            if (i < 0) {
                return 0;
            }
            return (Short)convNode.execute(this.args[i], j);
        }

        @ExportMessage
        int readI32(long offset, @Cached IntegerConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            if (i < 0) {
                return 0;
            }
            return (Integer)convNode.execute(this.args[i], j);
        }

        @ExportMessage
        LLVMPointer readPointer(long offset, @Cached PointerConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            return i < 0 ? LLVMNativePointer.createNull() : LLVMPointer.cast(convNode.execute(this.args[i], j));
        }

        @ExportMessage
        Object readGenericI64(long offset, @Cached LongConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            return i < 0 ? Long.valueOf(Double.doubleToLongBits(0.0)) : convNode.execute(this.args[i], j);
        }

        protected static LLVMInteropType getVarArgType(Object arg) {
            if (arg == null) {
                return LLVMInteropType.ValueKind.I8.type.toArray(0L);
            }
            if (arg instanceof Boolean) {
                return I8_ARG_TYPE;
            }
            if (arg instanceof Byte) {
                return I8_ARG_TYPE;
            }
            if (arg instanceof Short) {
                return I16_ARG_TYPE;
            }
            if (arg instanceof Integer) {
                return I32_ARG_TYPE;
            }
            if (arg instanceof Long) {
                return I64_ARG_TYPE;
            }
            if (arg instanceof Float) {
                return I32_ARG_TYPE;
            }
            if (arg instanceof Double) {
                return I64_ARG_TYPE;
            }
            if (LLVMPointer.isInstance(arg)) {
                return I64_ARG_TYPE;
            }
            if (arg instanceof LLVMFloatVector && ((LLVMFloatVector)arg).getLength() <= 2) {
                return I32_ARG_TYPE;
            }
            if (arg instanceof LLVMVarArgCompoundValue) {
                LLVMVarArgCompoundValue compVal = (LLVMVarArgCompoundValue)arg;
                return LLVMInteropType.ValueKind.I64.type.toArray(compVal.getSize() / 8L);
            }
            if (arg instanceof LLVM80BitFloat) {
                return F80_ARG_TYPE;
            }
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError(arg);
        }
    }

    @ExportLibrary(value=LLVMVaListLibrary.class)
    @ImportStatic(value={LLVMX86_64VaListStorage.class})
    public static final class NativeVAListWrapper {
        final LLVMNativePointer nativeVAListPtr;
        private final LLVMRootNode rootNode;

        public NativeVAListWrapper(LLVMNativePointer nativeVAListPtr, RootNode rootNode) {
            this.nativeVAListPtr = nativeVAListPtr;
            assert (rootNode instanceof LLVMRootNode);
            this.rootNode = (LLVMRootNode)rootNode;
        }

        LLVMNativeVarargsAreaStackAllocationNode createLLVMNativeVarargsAreaStackAllocationNode() {
            return LLVMNativeVarargsAreaStackAllocationNodeGen.create();
        }

        LLVMNativeVarargsAreaStackAllocationNode createLLVMNativeVarargsAreaStackAllocationNodeUncached() {
            LLVMNativeVarargsAreaStackAllocationNode node = LLVMNativeVarargsAreaStackAllocationNodeGen.create();
            node.setStackAccess(this.rootNode.getStackAccess());
            return node;
        }

        @ExportMessage
        public void initialize(Object[] arguments, int numberOfExplicitArguments, @Cached(value="this.createLLVMNativeVarargsAreaStackAllocationNode()", uncached="this.createLLVMNativeVarargsAreaStackAllocationNodeUncached()") LLVMNativeVarargsAreaStackAllocationNode stackAllocationNode, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, @Cached NativeProfiledMemMove memMove) {
            int fp;
            int gp;
            VirtualFrame frame = (VirtualFrame)Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE);
            int initGPOffset = gp = LLVMX86_64VaListStorage.calculateUsedGpArea(arguments, numberOfExplicitArguments);
            int initFPOffset = fp = 48 + LLVMX86_64VaListStorage.calculateUsedFpArea(arguments, numberOfExplicitArguments);
            int overflowArea = 0;
            for (int i = numberOfExplicitArguments; i < arguments.length; ++i) {
                Object arg = arguments[i];
                VarArgArea area = LLVMX86_64VaListStorage.getVarArgArea(arg);
                if (area == VarArgArea.GP_AREA && gp < 48) {
                    gp += 8;
                    continue;
                }
                if (area == VarArgArea.FP_AREA && fp < 176) {
                    fp += 16;
                    continue;
                }
                if (area != VarArgArea.OVERFLOW_AREA) {
                    overflowArea += 8;
                    continue;
                }
                if (arg instanceof LLVM80BitFloat) {
                    overflowArea += 16;
                    continue;
                }
                if (arg instanceof LLVMVarArgCompoundValue) {
                    LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)arg;
                    overflowArea = (int)((long)overflowArea + obj.getSize());
                    continue;
                }
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(arg);
            }
            LLVMPointer regSaveAreaNativePtr = stackAllocationNode.executeWithTarget(frame, 176L);
            LLVMNativePointer overflowArgAreaBaseNativePtr = LLVMNativePointer.cast(stackAllocationNode.executeWithTarget(frame, overflowArea));
            gpOffsetStore.executeWithTarget(this.nativeVAListPtr, 0L, initGPOffset);
            fpOffsetStore.executeWithTarget(this.nativeVAListPtr, 4L, initFPOffset);
            overflowArgAreaStore.executeWithTarget(this.nativeVAListPtr, 8L, overflowArgAreaBaseNativePtr);
            regSaveAreaStore.executeWithTarget(this.nativeVAListPtr, 16L, regSaveAreaNativePtr);
            LLVMX86_64VaListStorage.initNativeAreas(arguments, numberOfExplicitArguments, initGPOffset, initFPOffset, regSaveAreaNativePtr, overflowArgAreaBaseNativePtr, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
        }

        @ExportMessage
        public void cleanup() {
        }

        @ExportMessage
        public void copy(Object destVaList, int numberOfExplicitArguments) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("TODO");
        }

        @ExportMessage
        public Object shift(Type type) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("TODO");
        }
    }

    @ExportMessage
    static class Copy {
        Copy() {
        }

        @Specialization(guards={"!source.isNativized()"})
        static void copyManaged(LLVMX86_64VaListStorage source, LLVMX86_64VaListStorage dest, int numberOfExplicitArguments) {
            LLVMX86_64VaListStorage.access$602(dest, source.realArguments);
            dest.numberOfExplicitArguments = source.numberOfExplicitArguments;
            dest.initFPOffset = source.initFPOffset;
            dest.initGPOffset = source.initGPOffset;
            dest.fpOffset = source.fpOffset;
            dest.gpOffset = source.gpOffset;
            dest.regSaveArea = source.regSaveArea;
            dest.regSaveAreaPtr = source.regSaveAreaPtr;
            dest.overflowArgArea = source.overflowArgArea.clone();
            dest.nativized = null;
            dest.overflowArgAreaBaseNativePtr = null;
        }

        @Specialization(guards={"source.isNativized()"})
        static void copyNative(LLVMX86_64VaListStorage source, LLVMX86_64VaListStorage dest, int numberOfExplicitArguments, @CachedLibrary(value="source") LLVMManagedReadLibrary srcReadLib) {
            Copy.copyManaged(source, dest, numberOfExplicitArguments);
            dest.fpOffset = srcReadLib.readI32(source, 4L);
            dest.gpOffset = srcReadLib.readI32(source, 0L);
            dest.overflowArgArea.setOffset(LLVMX86_64VaListStorage.getArgPtrFromNativePtr(source, srcReadLib));
        }
    }

    @ExportMessage
    static class Initialize {
        Initialize() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void initializeManaged(LLVMX86_64VaListStorage vaList, Object[] realArgs, int numOfExpArgs) {
            LLVMX86_64VaListStorage.access$602(vaList, realArgs);
            vaList.numberOfExplicitArguments = numOfExpArgs;
            assert (numOfExpArgs <= realArgs.length);
            int gp = LLVMX86_64VaListStorage.calculateUsedGpArea(realArgs, numOfExpArgs);
            vaList.gpOffset = (vaList.initGPOffset = gp);
            int fp = 48 + LLVMX86_64VaListStorage.calculateUsedFpArea(realArgs, numOfExpArgs);
            vaList.fpOffset = (vaList.initFPOffset = fp);
            int[] gpIdx = new int[realArgs.length];
            Arrays.fill(gpIdx, -1);
            int[] fpIdx = new int[realArgs.length];
            Arrays.fill(fpIdx, -1);
            Object[] overflowArgs = new Object[realArgs.length];
            long[] overflowAreaArgOffsets = new long[realArgs.length];
            Arrays.fill(overflowAreaArgOffsets, -1L);
            int oi = 0;
            int overflowArea = 0;
            for (int i = numOfExpArgs; i < realArgs.length; ++i) {
                Object arg = realArgs[i];
                VarArgArea area = LLVMX86_64VaListStorage.getVarArgArea(arg);
                if (area == VarArgArea.GP_AREA && gp < 48) {
                    gpIdx[gp / 8] = i;
                    gp += 8;
                    continue;
                }
                if (area == VarArgArea.FP_AREA && fp < 176) {
                    fpIdx[(fp - 48) / 16] = i;
                    fp += 16;
                    continue;
                }
                if (area != VarArgArea.OVERFLOW_AREA) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArea += 8;
                    overflowArgs[oi++] = arg;
                    continue;
                }
                if (arg instanceof LLVM80BitFloat) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArea += 16;
                    overflowArgs[oi++] = arg;
                    continue;
                }
                if (arg instanceof LLVMVarArgCompoundValue) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)arg;
                    overflowArea = (int)((long)overflowArea + obj.getSize());
                    overflowArgs[oi++] = arg;
                    continue;
                }
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(arg);
            }
            vaList.regSaveArea = new RegSaveArea(realArgs, gpIdx, fpIdx, numOfExpArgs);
            vaList.regSaveAreaPtr = LLVMManagedPointer.create(vaList.regSaveArea);
            vaList.overflowArgArea = new OverflowArgArea(overflowArgs, overflowAreaArgOffsets, overflowArea);
        }

        @Specialization(guards={"vaList.isNativized()"})
        static void initializeNativized(LLVMX86_64VaListStorage vaList, Object[] realArgs, int numOfExpArgs, @Cached NativeAllocaInstruction stackAllocationNode, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, @Cached NativeProfiledMemMove memMove) {
            Initialize.initializeManaged(vaList, realArgs, numOfExpArgs);
            VirtualFrame frame = (VirtualFrame)Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE);
            LLVMPointer regSaveAreaNativePtr = vaList.allocateNativeAreas(stackAllocationNode, gpOffsetStore, fpOffsetStore, overflowArgAreaStore, regSaveAreaStore, frame);
            LLVMX86_64VaListStorage.initNativeAreas(vaList.realArguments, vaList.numberOfExplicitArguments, vaList.initGPOffset, vaList.initFPOffset, regSaveAreaNativePtr, vaList.overflowArgAreaBaseNativePtr, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
        }
    }

    private static enum VarArgArea {
        GP_AREA,
        FP_AREA,
        OVERFLOW_AREA;

    }

    @ExportMessage
    static class WritePointer {
        WritePointer() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void writeManaged(LLVMX86_64VaListStorage vaList, long offset, LLVMPointer value) {
            switch ((int)offset) {
                case 8: {
                    if (!LLVMManagedPointer.isInstance(value) || LLVMManagedPointer.cast(value).getObject() != vaList.overflowArgArea) {
                        CompilerDirectives.transferToInterpreter();
                        throw new LLVMMemoryException(null, "updates to VA_LIST overflowArea pointer can only shift the current argument");
                    }
                    vaList.overflowArgArea.setOffset(LLVMManagedPointer.cast(value).getOffset());
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException("Should not get here");
                }
            }
        }

        @Specialization(guards={"vaList.isNativized()"})
        static void writeNative(LLVMX86_64VaListStorage vaList, long offset, LLVMPointer value, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode offsetStore) {
            offsetStore.executeWithTarget(vaList.nativized, offset, value);
        }
    }

    @ExportMessage
    static class WriteI32 {
        WriteI32() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void writeManaged(LLVMX86_64VaListStorage vaList, long offset, int value) {
            switch ((int)offset) {
                case 0: {
                    vaList.gpOffset = value;
                    vaList.regSaveArea.shift();
                    break;
                }
                case 4: {
                    vaList.fpOffset = value;
                    vaList.regSaveArea.shift();
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException("Should not get here");
                }
            }
        }

        @Specialization(guards={"vaList.isNativized()"})
        static void writeNative(LLVMX86_64VaListStorage vaList, long offset, int value, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode offsetStore) {
            offsetStore.executeWithTarget(vaList.nativized, offset, value);
        }
    }

    @ExportMessage
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static LLVMPointer readManagedPointer(LLVMX86_64VaListStorage vaList, long offset) {
            switch ((int)offset) {
                case 8: {
                    return vaList.overflowArgArea.getCurrentArgPtr();
                }
                case 16: {
                    return vaList.regSaveAreaPtr;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("Should not get here");
        }

        @Specialization(guards={"vaList.isNativized()"})
        static LLVMPointer readNativePointer(LLVMX86_64VaListStorage vaList, long offset, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.nativized, offset);
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static int readManagedI32(LLVMX86_64VaListStorage vaList, long offset) {
            switch ((int)offset) {
                case 0: {
                    return vaList.gpOffset;
                }
                case 4: {
                    return vaList.fpOffset;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("Should not get here");
        }

        @Specialization(guards={"vaList.isNativized()"})
        static int readNativeI32(LLVMX86_64VaListStorage vaList, long offset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.nativized, offset);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VAListMembers
    implements TruffleObject {
        VAListMembers() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 1L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index == 0L;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index == 0L) {
                return LLVMX86_64VaListStorage.GET_MEMBER;
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }
}

