/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMArithmetic.class)
public final class LLVMArithmeticFactory {

    @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.class)
    public static final class LLVMArithmeticWithOverflowAndCarryNodeGen
    extends LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode cin_;
        @Node.Child
        private LLVMExpressionNode cout_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMI8StoreNode intrinsic0_store_;
        @Node.Child
        private LLVMI16StoreNode intrinsic1_store_;
        @Node.Child
        private LLVMI32StoreNode intrinsic2_store_;
        @Node.Child
        private LLVMI64StoreNode intrinsic3_store_;

        private LLVMArithmeticWithOverflowAndCarryNodeGen(LLVMArithmetic.CarryArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode cin, LLVMExpressionNode cout) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
            this.cin_ = cin;
            this.cout_ = cout;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xE) == 0 && state_0 != 0) {
                return this.executeGeneric_byte_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0xD) == 0 && state_0 != 0) {
                return this.executeGeneric_short_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0xB) == 0 && state_0 != 0) {
                return this.executeGeneric_int_int_int2(state_0, frameValue);
            }
            if ((state_0 & 7) == 0 && state_0 != 0) {
                return this.executeGeneric_long_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte_byte0(int state_0, VirtualFrame frameValue) {
            byte cinValue_;
            byte rightValue_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            assert ((state_0 & 1) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic0_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_short_short_short1(int state_0, VirtualFrame frameValue) {
            short cinValue_;
            short rightValue_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic1_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_int_int_int2(int state_0, VirtualFrame frameValue) {
            int cinValue_;
            int rightValue_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic2_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_long_long_long3(int state_0, VirtualFrame frameValue) {
            long cinValue_;
            long rightValue_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            assert ((state_0 & 8) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic3_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_generic4(int state_0, VirtualFrame frameValue) {
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object cinValue_ = this.cin_.executeGeneric(frameValue);
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (state_0 != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                if ((state_0 & 1) != 0 && leftValue_ instanceof Byte) {
                    byte by = (Byte)leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte by2 = (Byte)rightValue_;
                        if (cinValue_ instanceof Byte) {
                            byte cinValue__ = (Byte)cinValue_;
                            return this.doIntrinsic(by, by2, cinValue__, coutValue__, this.intrinsic0_store_);
                        }
                    }
                }
                if ((state_0 & 2) != 0 && leftValue_ instanceof Short) {
                    short s = (Short)leftValue_;
                    if (rightValue_ instanceof Short) {
                        short s2 = (Short)rightValue_;
                        if (cinValue_ instanceof Short) {
                            short cinValue__ = (Short)cinValue_;
                            return this.doIntrinsic(s, s2, cinValue__, coutValue__, this.intrinsic1_store_);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && leftValue_ instanceof Integer) {
                    int n = (Integer)leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int n2 = (Integer)rightValue_;
                        if (cinValue_ instanceof Integer) {
                            int cinValue__ = (Integer)cinValue_;
                            return this.doIntrinsic(n, n2, cinValue__, coutValue__, this.intrinsic2_store_);
                        }
                    }
                }
                if ((state_0 & 8) != 0 && leftValue_ instanceof Long) {
                    long l = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__2 = (Long)rightValue_;
                        if (cinValue_ instanceof Long) {
                            long cinValue__ = (Long)cinValue_;
                            return this.doIntrinsic(l, rightValue__2, cinValue__, coutValue__, this.intrinsic3_store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            byte cinValue_;
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic0_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int cinValue_;
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if ((state_0 & 4) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic2_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long cinValue_;
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if ((state_0 & 8) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic3_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            short cinValue_;
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, this.intrinsic1_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object cinValue, Object coutValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isPointer(coutValue)) {
                    LLVMPointer coutValue_ = LLVMTypes.asPointer(coutValue);
                    if (leftValue instanceof Byte) {
                        byte by = (Byte)leftValue;
                        if (rightValue instanceof Byte) {
                            byte by2 = (Byte)rightValue;
                            if (cinValue instanceof Byte) {
                                byte cinValue_ = (Byte)cinValue;
                                this.intrinsic0_store_ = (LLVMI8StoreNode)super.insert((Node)LLVMI8StoreNode.create());
                                this.state_0_ = state_0 |= 1;
                                lock.unlock();
                                hasLock = false;
                                Byte by3 = this.doIntrinsic(by, by2, cinValue_, coutValue_, this.intrinsic0_store_);
                                return by3;
                            }
                        }
                    }
                    if (leftValue instanceof Short) {
                        short s = (Short)leftValue;
                        if (rightValue instanceof Short) {
                            short s2 = (Short)rightValue;
                            if (cinValue instanceof Short) {
                                short cinValue_ = (Short)cinValue;
                                this.intrinsic1_store_ = (LLVMI16StoreNode)super.insert((Node)LLVMI16StoreNode.create());
                                this.state_0_ = state_0 |= 2;
                                lock.unlock();
                                hasLock = false;
                                Short s3 = this.doIntrinsic(s, s2, cinValue_, coutValue_, this.intrinsic1_store_);
                                return s3;
                            }
                        }
                    }
                    if (leftValue instanceof Integer) {
                        int n = (Integer)leftValue;
                        if (rightValue instanceof Integer) {
                            int n2 = (Integer)rightValue;
                            if (cinValue instanceof Integer) {
                                int cinValue_ = (Integer)cinValue;
                                this.intrinsic2_store_ = (LLVMI32StoreNode)super.insert((Node)LLVMI32StoreNode.create());
                                this.state_0_ = state_0 |= 4;
                                lock.unlock();
                                hasLock = false;
                                Integer n3 = this.doIntrinsic(n, n2, cinValue_, coutValue_, this.intrinsic2_store_);
                                return n3;
                            }
                        }
                    }
                    if (leftValue instanceof Long) {
                        long l = (Long)leftValue;
                        if (rightValue instanceof Long) {
                            long rightValue_2 = (Long)rightValue;
                            if (cinValue instanceof Long) {
                                long cinValue_ = (Long)cinValue;
                                this.intrinsic3_store_ = (LLVMI64StoreNode)super.insert((Node)LLVMI64StoreNode.create());
                                this.state_0_ = state_0 |= 8;
                                lock.unlock();
                                hasLock = false;
                                Long l2 = this.doIntrinsic(l, rightValue_2, cinValue_, coutValue_, this.intrinsic3_store_);
                                return l2;
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.cin_, this.cout_}, new Object[]{leftValue, rightValue, cinValue, coutValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry create(LLVMArithmetic.CarryArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode cin, LLVMExpressionNode cout) {
            return new LLVMArithmeticWithOverflowAndCarryNodeGen(arithmetic, left, right, cin, cout);
        }
    }

    @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflow.class)
    public static final class LLVMArithmeticWithOverflowNodeGen
    extends LLVMArithmetic.LLVMArithmeticWithOverflow {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode target_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMI8StoreNode intrinsic0_store_;
        @Node.Child
        private LLVMI16StoreNode intrinsic1_store_;
        @Node.Child
        private LLVMI32StoreNode intrinsic2_store_;
        @Node.Child
        private LLVMI64StoreNode intrinsic3_store_;

        private LLVMArithmeticWithOverflowNodeGen(LLVMArithmetic.Arithmetic arithmetic, long secondValueOffset, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            super(arithmetic, secondValueOffset);
            this.left_ = left;
            this.right_ = right;
            this.target_ = target;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xE) == 0 && state_0 != 0) {
                return this.executeGeneric_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0xD) == 0 && state_0 != 0) {
                return this.executeGeneric_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0xB) == 0 && state_0 != 0) {
                return this.executeGeneric_int_int2(state_0, frameValue);
            }
            if ((state_0 & 7) == 0 && state_0 != 0) {
                return this.executeGeneric_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte0(int state_0, VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 1) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic0_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_short_short1(int state_0, VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic1_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_int_int2(int state_0, VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic2_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_long_long3(int state_0, VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 8) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic3_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_generic4(int state_0, VirtualFrame frameValue) {
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (state_0 != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                if ((state_0 & 1) != 0 && leftValue_ instanceof Byte) {
                    byte by = (Byte)leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte rightValue__ = (Byte)rightValue_;
                        return this.doIntrinsic(by, rightValue__, targetValue__, this.intrinsic0_store_);
                    }
                }
                if ((state_0 & 2) != 0 && leftValue_ instanceof Short) {
                    short s = (Short)leftValue_;
                    if (rightValue_ instanceof Short) {
                        short rightValue__ = (Short)rightValue_;
                        return this.doIntrinsic(s, rightValue__, targetValue__, this.intrinsic1_store_);
                    }
                }
                if ((state_0 & 4) != 0 && leftValue_ instanceof Integer) {
                    int n = (Integer)leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int rightValue__ = (Integer)rightValue_;
                        return this.doIntrinsic(n, rightValue__, targetValue__, this.intrinsic2_store_);
                    }
                }
                if ((state_0 & 8) != 0 && leftValue_ instanceof Long) {
                    long l = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (Long)rightValue_;
                        return this.doIntrinsic(l, rightValue__, targetValue__, this.intrinsic3_store_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object targetValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isPointer(targetValue)) {
                    LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                    if (leftValue instanceof Byte) {
                        byte by = (Byte)leftValue;
                        if (rightValue instanceof Byte) {
                            byte rightValue_ = (Byte)rightValue;
                            this.intrinsic0_store_ = (LLVMI8StoreNode)super.insert((Node)LLVMI8StoreNode.create());
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doIntrinsic(by, rightValue_, targetValue_, this.intrinsic0_store_);
                            return object;
                        }
                    }
                    if (leftValue instanceof Short) {
                        short s = (Short)leftValue;
                        if (rightValue instanceof Short) {
                            short rightValue_ = (Short)rightValue;
                            this.intrinsic1_store_ = (LLVMI16StoreNode)super.insert((Node)LLVMI16StoreNode.create());
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doIntrinsic(s, rightValue_, targetValue_, this.intrinsic1_store_);
                            return object;
                        }
                    }
                    if (leftValue instanceof Integer) {
                        int n = (Integer)leftValue;
                        if (rightValue instanceof Integer) {
                            int rightValue_ = (Integer)rightValue;
                            this.intrinsic2_store_ = (LLVMI32StoreNode)super.insert((Node)LLVMI32StoreNode.create());
                            this.state_0_ = state_0 |= 4;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doIntrinsic(n, rightValue_, targetValue_, this.intrinsic2_store_);
                            return object;
                        }
                    }
                    if (leftValue instanceof Long) {
                        long l = (Long)leftValue;
                        if (rightValue instanceof Long) {
                            long rightValue_ = (Long)rightValue;
                            this.intrinsic3_store_ = (LLVMI64StoreNode)super.insert((Node)LLVMI64StoreNode.create());
                            this.state_0_ = state_0 |= 8;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doIntrinsic(l, rightValue_, targetValue_, this.intrinsic3_store_);
                            return object;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.target_}, new Object[]{leftValue, rightValue, targetValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmetic.LLVMArithmeticWithOverflow create(LLVMArithmetic.Arithmetic arithmetic, long secondValueOffset, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            return new LLVMArithmeticWithOverflowNodeGen(arithmetic, secondValueOffset, left, right, target);
        }
    }

    @GeneratedBy(value=LLVMArithmetic.LLVMSimpleArithmeticPrimitive.class)
    public static final class LLVMSimpleArithmeticPrimitiveNodeGen
    extends LLVMArithmetic.LLVMSimpleArithmeticPrimitive {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSimpleArithmeticPrimitiveNodeGen(LLVMArithmetic.SaturatingArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xE) == 0 && state_0 != 0) {
                return this.executeGeneric_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0xD) == 0 && state_0 != 0) {
                return this.executeGeneric_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0xB) == 0 && state_0 != 0) {
                return this.executeGeneric_int_int2(state_0, frameValue);
            }
            if ((state_0 & 7) == 0 && state_0 != 0) {
                return this.executeGeneric_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte0(int state_0, VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_short_short1(int state_0, VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_int_int2(int state_0, VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_long_long3(int state_0, VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_generic4(int state_0, VirtualFrame frameValue) {
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && leftValue_ instanceof Byte) {
                byte by = (Byte)leftValue_;
                if (rightValue_ instanceof Byte) {
                    byte rightValue__ = (Byte)rightValue_;
                    return this.doIntrinsic(by, rightValue__);
                }
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof Short) {
                short s = (Short)leftValue_;
                if (rightValue_ instanceof Short) {
                    short rightValue__ = (Short)rightValue_;
                    return this.doIntrinsic(s, rightValue__);
                }
            }
            if ((state_0 & 4) != 0 && leftValue_ instanceof Integer) {
                int n = (Integer)leftValue_;
                if (rightValue_ instanceof Integer) {
                    int rightValue__ = (Integer)rightValue_;
                    return this.doIntrinsic(n, rightValue__);
                }
            }
            if ((state_0 & 8) != 0 && leftValue_ instanceof Long) {
                long l = (Long)leftValue_;
                if (rightValue_ instanceof Long) {
                    long rightValue__ = (Long)rightValue_;
                    return this.doIntrinsic(l, rightValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if ((state_0 & 1) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if ((state_0 & 4) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if ((state_0 & 8) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if ((state_0 & 2) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if (leftValue instanceof Byte) {
                byte by = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_0_ = state_0 |= 1;
                    return this.doIntrinsic(by, rightValue_);
                }
            }
            if (leftValue instanceof Short) {
                short s = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doIntrinsic(s, rightValue_);
                }
            }
            if (leftValue instanceof Integer) {
                int n = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_0_ = state_0 |= 4;
                    return this.doIntrinsic(n, rightValue_);
                }
            }
            if (leftValue instanceof Long) {
                long l = (Long)leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (Long)rightValue;
                    this.state_0_ = state_0 |= 8;
                    return this.doIntrinsic(l, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmetic.LLVMSimpleArithmeticPrimitive create(LLVMArithmetic.SaturatingArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMSimpleArithmeticPrimitiveNodeGen(arithmetic, left, right);
        }
    }

    @GeneratedBy(value=LLVMArithmetic.GCCArithmetic.class)
    public static final class GCCArithmeticNodeGen
    extends LLVMArithmetic.GCCArithmetic {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode target_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMI8StoreNode intrinsic0_store_;
        @Node.Child
        private LLVMI16StoreNode intrinsic1_store_;
        @Node.Child
        private LLVMI32StoreNode intrinsic2_store_;
        @Node.Child
        private LLVMI64StoreNode intrinsic3_store_;

        private GCCArithmeticNodeGen(LLVMArithmetic.Arithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
            this.target_ = target;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xE) == 0 && state_0 != 0) {
                return this.executeGeneric_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0xD) == 0 && state_0 != 0) {
                return this.executeGeneric_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0xB) == 0 && state_0 != 0) {
                return this.executeGeneric_int_int2(state_0, frameValue);
            }
            if ((state_0 & 7) == 0 && state_0 != 0) {
                return this.executeGeneric_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte0(int state_0, VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 1) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic0_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_short_short1(int state_0, VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic1_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_int_int2(int state_0, VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic2_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_long_long3(int state_0, VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            assert ((state_0 & 8) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic3_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_generic4(int state_0, VirtualFrame frameValue) {
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (state_0 != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                if ((state_0 & 1) != 0 && leftValue_ instanceof Byte) {
                    byte by = (Byte)leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte rightValue__ = (Byte)rightValue_;
                        return this.doIntrinsic(by, rightValue__, targetValue__, this.intrinsic0_store_);
                    }
                }
                if ((state_0 & 2) != 0 && leftValue_ instanceof Short) {
                    short s = (Short)leftValue_;
                    if (rightValue_ instanceof Short) {
                        short rightValue__ = (Short)rightValue_;
                        return this.doIntrinsic(s, rightValue__, targetValue__, this.intrinsic1_store_);
                    }
                }
                if ((state_0 & 4) != 0 && leftValue_ instanceof Integer) {
                    int n = (Integer)leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int rightValue__ = (Integer)rightValue_;
                        return this.doIntrinsic(n, rightValue__, targetValue__, this.intrinsic2_store_);
                    }
                }
                if ((state_0 & 8) != 0 && leftValue_ instanceof Long) {
                    long l = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (Long)rightValue_;
                        return this.doIntrinsic(l, rightValue__, targetValue__, this.intrinsic3_store_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic0_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if ((state_0 & 4) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic2_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if ((state_0 & 8) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic3_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                return this.doIntrinsic(leftValue_, rightValue_, targetValue__, this.intrinsic1_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object targetValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isPointer(targetValue)) {
                    LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                    if (leftValue instanceof Byte) {
                        byte by = (Byte)leftValue;
                        if (rightValue instanceof Byte) {
                            byte rightValue_ = (Byte)rightValue;
                            this.intrinsic0_store_ = (LLVMI8StoreNode)super.insert((Node)LLVMI8StoreNode.create());
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            Byte n = this.doIntrinsic(by, rightValue_, targetValue_, this.intrinsic0_store_);
                            return n;
                        }
                    }
                    if (leftValue instanceof Short) {
                        short s = (Short)leftValue;
                        if (rightValue instanceof Short) {
                            short rightValue_ = (Short)rightValue;
                            this.intrinsic1_store_ = (LLVMI16StoreNode)super.insert((Node)LLVMI16StoreNode.create());
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            Short s2 = this.doIntrinsic(s, rightValue_, targetValue_, this.intrinsic1_store_);
                            return s2;
                        }
                    }
                    if (leftValue instanceof Integer) {
                        int n = (Integer)leftValue;
                        if (rightValue instanceof Integer) {
                            int rightValue_ = (Integer)rightValue;
                            this.intrinsic2_store_ = (LLVMI32StoreNode)super.insert((Node)LLVMI32StoreNode.create());
                            this.state_0_ = state_0 |= 4;
                            lock.unlock();
                            hasLock = false;
                            Integer n2 = this.doIntrinsic(n, rightValue_, targetValue_, this.intrinsic2_store_);
                            return n2;
                        }
                    }
                    if (leftValue instanceof Long) {
                        long l = (Long)leftValue;
                        if (rightValue instanceof Long) {
                            long rightValue_ = (Long)rightValue;
                            this.intrinsic3_store_ = (LLVMI64StoreNode)super.insert((Node)LLVMI64StoreNode.create());
                            this.state_0_ = state_0 |= 8;
                            lock.unlock();
                            hasLock = false;
                            Long l2 = this.doIntrinsic(l, rightValue_, targetValue_, this.intrinsic3_store_);
                            return l2;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.target_}, new Object[]{leftValue, rightValue, targetValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmetic.GCCArithmetic create(LLVMArithmetic.Arithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            return new GCCArithmeticNodeGen(arithmetic, left, right, target);
        }
    }
}

