/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemoryIntrinsicFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMMemoryIntrinsic
extends LLVMExpressionNode {

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMFree
    extends LLVMMemoryIntrinsic
    implements LLVMMemoryOpNode {
        @Specialization(guards={"address.isNull()"})
        protected Object doNull(LLVMNativePointer address) {
            return null;
        }

        @Specialization
        protected Object doVoid(LLVMNativePointer address, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().free((Node)this, address);
            return null;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMRealloc
    extends LLVMMemoryIntrinsic {
        public abstract LLVMNativePointer executeWithTarget(LLVMNativePointer var1, Object var2);

        @Specialization
        protected LLVMNativePointer doVoid(LLVMNativePointer addr, int size, @CachedLanguage LLVMLanguage language) {
            return this.doVoid(addr, (long)size, language);
        }

        @Specialization
        protected LLVMNativePointer doVoid(LLVMNativePointer addr, long size, @CachedLanguage LLVMLanguage language) {
            try {
                return language.getLLVMMemory().reallocateMemory(this, addr, size);
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreter();
                return LLVMNativePointer.createNull();
            }
        }

        public static LLVMRealloc create() {
            return LLVMMemoryIntrinsicFactory.LLVMReallocNodeGen.create(null, null);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMCalloc
    extends LLVMMemoryIntrinsic {
        @Node.Child
        private LLVMMemSetNode memSet;

        public LLVMCalloc(LLVMMemSetNode memSet) {
            this.memSet = memSet;
        }

        @Specialization
        protected LLVMNativePointer doVoid(int n, int size, @CachedLanguage LLVMLanguage language) {
            try {
                long length = Math.multiplyExact(n, size);
                LLVMNativePointer address = language.getLLVMMemory().allocateMemory(this, length);
                this.memSet.executeWithTarget(address, (byte)0, length);
                return address;
            }
            catch (ArithmeticException | OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreter();
                return LLVMNativePointer.createNull();
            }
        }

        @Specialization
        protected LLVMNativePointer doVoid(long n, long size, @CachedLanguage LLVMLanguage language) {
            try {
                long length = Math.multiplyExact(n, size);
                LLVMNativePointer address = language.getLLVMMemory().allocateMemory(this, length);
                this.memSet.executeWithTarget(address, (byte)0, length);
                return address;
            }
            catch (ArithmeticException | OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreter();
                return LLVMNativePointer.createNull();
            }
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMMalloc
    extends LLVMMemoryIntrinsic {
        @Specialization
        protected LLVMNativePointer doVoid(int size, @CachedLanguage LLVMLanguage language) {
            try {
                return language.getLLVMMemory().allocateMemory(this, size);
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreter();
                return LLVMNativePointer.createNull();
            }
        }

        @Specialization
        protected LLVMNativePointer doVoid(long size, @CachedLanguage LLVMLanguage language) {
            try {
                return language.getLLVMMemory().allocateMemory(this, size);
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreter();
                return LLVMNativePointer.createNull();
            }
        }
    }
}

