/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.List;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMTruffleWriteManagedToSymbol
extends LLVMIntrinsic {
    @Node.Child
    LLVMReadNode.AttachInteropTypeNode attachType = LLVMReadNodeFactory.AttachInteropTypeNodeGen.create();

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Object write(LLVMPointer address, Object value, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
        List<LLVMSymbol> symbols = ctx.removeSymbolReverseMap(address);
        if (symbols == null) {
            throw new LLVMPolyglotException(this, "First argument to truffle_assign_managed must be a pointer to a symbol.");
        }
        Object newValue = value;
        boolean allGlobals = symbols.get(0).isGlobalVariable();
        if (allGlobals) {
            newValue = this.attachType.execute(value, symbols.get(0).asGlobalVariable().getInteropType(ctx));
        }
        for (LLVMSymbol symbol : symbols) {
            assert (!allGlobals ? symbol.isFunction() : symbol.isGlobalVariable());
            ctx.setSymbol(symbol, LLVMPointer.cast(newValue));
        }
        ctx.registerSymbolReverseMap(symbols, LLVMPointer.cast(value));
        return newValue;
    }
}

