/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMTruffleDecorateFunction
extends LLVMIntrinsic {
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> contextRef;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> languageRef;

    protected boolean isAutoDerefHandle(LLVMNativePointer addr) {
        if (this.languageRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.languageRef = this.lookupLanguageReference(LLVMLanguage.class);
        }
        if (CompilerDirectives.inCompiledCode() && ((LLVMLanguage)this.languageRef.get()).getNoDerefHandleAssumption().isValid()) {
            return false;
        }
        return LLVMHandleMemoryBase.isDerefHandleMemory(addr.asNative());
    }

    @Specialization(guards={"!isAutoDerefHandle(func)"})
    protected Object decorate(LLVMNativePointer func, LLVMNativePointer wrapper) {
        return this.decorate(this.getContext().getFunctionDescriptor(func), this.getContext().getFunctionDescriptor(wrapper));
    }

    @Specialization(guards={"isAutoDerefHandle(func)"})
    protected Object decorateDerefHandle(LLVMNativePointer func, LLVMNativePointer wrapper, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached ConditionProfile isFunctionDescriptorProfile) {
        LLVMManagedPointer resolved = getReceiver.execute(func);
        if (isFunctionDescriptorProfile.profile(LLVMTruffleDecorateFunction.isFunctionDescriptor(resolved.getObject()))) {
            return this.decorate(resolved, wrapper);
        }
        return this.doGeneric(func, wrapper);
    }

    @Specialization(guards={"!isAutoDerefHandle(func)", "isFunctionDescriptor(wrapper.getObject())"})
    protected Object decorate(LLVMNativePointer func, LLVMManagedPointer wrapper) {
        return this.decorate(this.getContext().getFunctionDescriptor(func), (LLVMFunctionDescriptor)wrapper.getObject());
    }

    @Specialization(guards={"isAutoDerefHandle(func)", "isFunctionDescriptor(wrapper.getObject())"})
    protected Object decorateDerefHandle(LLVMNativePointer func, LLVMManagedPointer wrapper, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached ConditionProfile isFunctionDescriptorProfile, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        LLVMManagedPointer resolved = getReceiver.execute(func);
        if (isFunctionDescriptorProfile.profile(LLVMTruffleDecorateFunction.isFunctionDescriptor(resolved.getObject()))) {
            return this.decorate(resolved, wrapper);
        }
        if (foreigns.isForeign(resolved.getObject())) {
            return this.decorateForeign(resolved, wrapper);
        }
        return this.doGeneric(func, wrapper);
    }

    private Object decorateForeign(LLVMManagedPointer resolved, LLVMManagedPointer wrapper) {
        Object foreign = resolved.getObject();
        return this.decorateForeign(foreign, (LLVMFunctionDescriptor)wrapper.getObject());
    }

    @Specialization(guards={"isFunctionDescriptor(func.getObject())"})
    protected Object decorate(LLVMManagedPointer func, LLVMNativePointer wrapper) {
        return this.decorate((LLVMFunctionDescriptor)func.getObject(), this.getContext().getFunctionDescriptor(wrapper));
    }

    @Specialization(guards={"isFunctionDescriptor(func.getObject())", "isFunctionDescriptor(wrapper.getObject())"})
    protected Object decorate(LLVMManagedPointer func, LLVMManagedPointer wrapper) {
        return this.decorate((LLVMFunctionDescriptor)func.getObject(), (LLVMFunctionDescriptor)wrapper.getObject());
    }

    @Fallback
    protected Object doGeneric(Object func, Object wrapper) {
        throw new LLVMPolyglotException(this, "invalid arguments for function composition");
    }

    @CompilerDirectives.TruffleBoundary
    private Object decorate(LLVMFunctionDescriptor function, LLVMFunctionDescriptor wrapperFunction) {
        assert (function != null && wrapperFunction != null);
        FunctionType type = wrapperFunction.getLLVMFunction().getType();
        FunctionType newFunctionType = FunctionType.copy(type);
        NativeDecoratedRoot decoratedRoot = new NativeDecoratedRoot(this.lookupLanguageReference(LLVMLanguage.class).get(), function, wrapperFunction);
        return LLVMTruffleDecorateFunction.registerRoot(function.getLLVMFunction().getStringPath(), newFunctionType, decoratedRoot);
    }

    @CompilerDirectives.TruffleBoundary
    private Object decorateForeign(Object function, LLVMFunctionDescriptor wrapperFunction) {
        assert (function != null && wrapperFunction != null);
        FunctionType newFunctionType = new FunctionType(wrapperFunction.getLLVMFunction().getType().getReturnType(), 0, true);
        ForeignDecoratedRoot decoratedRoot = new ForeignDecoratedRoot(this.lookupLanguageReference(LLVMLanguage.class).get(), newFunctionType, function, wrapperFunction);
        return LLVMTruffleDecorateFunction.registerRoot(wrapperFunction.getLLVMFunction().getStringPath(), newFunctionType, decoratedRoot);
    }

    private static Object registerRoot(String path, FunctionType newFunctionType, DecoratedRoot decoratedRoot) {
        LLVMFunctionCode.LLVMIRFunction function = new LLVMFunctionCode.LLVMIRFunction(Truffle.getRuntime().createCallTarget((RootNode)decoratedRoot), null);
        LLVMFunction functionDetail = LLVMFunction.create("<wrapper>", function, newFunctionType, -1, -1, false, path);
        LLVMFunctionDescriptor wrappedFunction = new LLVMFunctionDescriptor(functionDetail, new LLVMFunctionCode(functionDetail));
        return LLVMManagedPointer.create(wrappedFunction);
    }

    private LLVMContext getContext() {
        if (this.contextRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.contextRef = this.lookupContextReference(LLVMLanguage.class);
        }
        return (LLVMContext)this.contextRef.get();
    }

    protected static class ForeignDecoratedRoot
    extends DecoratedRoot {
        @Node.Child
        private LLVMDispatchNode funcCallNode;
        @Node.Child
        private DirectCallNode wrapperCallNode;
        private final Object func;

        protected ForeignDecoratedRoot(TruffleLanguage<?> language, FunctionType type, Object func, LLVMFunctionDescriptor wrapper) {
            super(language);
            this.funcCallNode = LLVMDispatchNodeGen.create(type);
            this.func = func;
            this.wrapperCallNode = Truffle.getRuntime().createDirectCallNode((CallTarget)wrapper.getFunctionCode().getLLVMIRFunctionSlowPath());
            this.wrapperCallNode.cloneCallTarget();
        }

        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            Object result = this.funcCallNode.executeDispatch(this.func, arguments);
            Object[] wrapperArgs = new Object[]{arguments[0], result};
            return this.wrapperCallNode.call(wrapperArgs);
        }
    }

    protected static class NativeDecoratedRoot
    extends DecoratedRoot {
        @Node.Child
        private DirectCallNode funcCallNode;
        @Node.Child
        private DirectCallNode wrapperCallNode;

        protected NativeDecoratedRoot(TruffleLanguage<?> language, LLVMFunctionDescriptor descriptor, LLVMFunctionDescriptor wrapper) {
            super(language);
            this.funcCallNode = Truffle.getRuntime().createDirectCallNode((CallTarget)descriptor.getFunctionCode().getLLVMIRFunctionSlowPath());
            this.wrapperCallNode = Truffle.getRuntime().createDirectCallNode((CallTarget)wrapper.getFunctionCode().getLLVMIRFunctionSlowPath());
            this.funcCallNode.cloneCallTarget();
            this.wrapperCallNode.cloneCallTarget();
            this.funcCallNode.forceInlining();
            this.wrapperCallNode.forceInlining();
        }

        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            Object result = this.funcCallNode.call(arguments);
            Object[] wrapperArgs = new Object[]{arguments[0], result};
            return this.wrapperCallNode.call(wrapperArgs);
        }
    }

    protected static abstract class DecoratedRoot
    extends RootNode {
        protected DecoratedRoot(TruffleLanguage<?> language) {
            super(language);
        }
    }
}

