/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMReadStringNode
extends LLVMNode {
    @Node.Child
    PointerReadStringNode readOther;

    public abstract String executeWithTarget(Object var1);

    @Specialization
    String readString(String address) {
        return address;
    }

    @Specialization(guards={"isString(foreign)"})
    String readString(LLVMManagedPointer foreign) {
        return (String)foreign.getObject();
    }

    @Specialization(guards={"foreigns.isForeign(pointer)"})
    String readForeign(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @Cached(value="create()") ForeignReadStringNode read) {
        return read.execute(pointer, foreigns.asForeign(pointer));
    }

    @Fallback
    String readOther(Object address) {
        if (this.readOther == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readOther = (PointerReadStringNode)this.insert(PointerReadStringNode.create());
        }
        return this.readOther.execute(address);
    }

    protected static boolean isString(LLVMManagedPointer pointer) {
        return pointer.getOffset() == 0L && pointer.getObject() instanceof String;
    }

    static abstract class PointerReadStringNode
    extends LLVMNode {
        @Node.Child
        private LLVMI8LoadNode.LLVMI8OffsetLoadNode read = LLVMI8LoadNode.LLVMI8OffsetLoadNode.create();

        PointerReadStringNode() {
        }

        protected abstract String execute(Object var1);

        boolean isReadOnlyMemory(LLVMPointer address) {
            CompilerAsserts.neverPartOfCompilation();
            LLVMGlobal global = ((LLVMContext)this.lookupContextReference(LLVMLanguage.class).get()).findGlobal(address);
            if (global != null) {
                return global.isReadOnly();
            }
            return false;
        }

        @Specialization(guards={"cachedAddress.isSame(address)", "isReadOnlyMemory(cachedAddress)"})
        String doCachedPointer(LLVMPointer address, @Cached(value="address") LLVMPointer cachedAddress, @Cached(value="doReadString(cachedAddress)") String result) {
            return result;
        }

        @Specialization(replaces={"doCachedPointer"})
        String doReadString(LLVMPointer address) {
            int length = 0;
            while (this.read.executeWithTarget(address, length * 1) != 0) {
                ++length;
            }
            char[] string = new char[length];
            for (int i = 0; i < length; ++i) {
                string[i] = (char)Byte.toUnsignedInt(this.read.executeWithTarget(address, i * 1));
            }
            return PointerReadStringNode.toString(string);
        }

        @CompilerDirectives.TruffleBoundary
        private static String toString(char[] string) {
            return new String(string);
        }

        public static PointerReadStringNode create() {
            return LLVMReadStringNodeGen.PointerReadStringNodeGen.create();
        }
    }

    static abstract class ForeignReadStringNode
    extends LLVMNode {
        ForeignReadStringNode() {
        }

        protected abstract String execute(LLVMManagedPointer var1, Object var2);

        @Specialization(limit="3")
        String doDefault(LLVMManagedPointer object, Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached PointerReadStringNode read) {
            if (interop.isString(foreign)) {
                try {
                    return interop.asString(foreign);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return read.execute(object);
        }

        public static ForeignReadStringNode create() {
            return LLVMReadStringNodeGen.ForeignReadStringNodeGen.create();
        }
    }

    static abstract class Dummy
    extends LLVMNode {
        Dummy() {
        }

        protected abstract LLVMManagedPointer execute();
    }
}

