/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromString;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotFromString.class)
public final class LLVMPolyglotFromStringNodeGen
extends LLVMPolyglotFromString {
    @Node.Child
    private LLVMReadCharsetNode charset_;
    @Node.Child
    private LLVMPolyglotFromString.ReadBytesNode rawString_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMPolyglotFromStringNodeGen(LLVMReadCharsetNode charset, LLVMPolyglotFromString.ReadBytesNode rawString) {
        this.charset_ = charset;
        this.rawString_ = rawString;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object charsetValue_ = this.charset_.execute(frameValue);
        byte[] rawStringValue_ = this.rawString_.execute(frameValue, (LLVMReadCharsetNode.LLVMCharset)charsetValue_);
        if (state_0 != 0 && charsetValue_ instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue__ = (LLVMReadCharsetNode.LLVMCharset)charsetValue_;
            return this.doFromString(charsetValue__, rawStringValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(charsetValue_, rawStringValue_);
    }

    private LLVMManagedPointer executeAndSpecialize(Object charsetValue, byte[] rawStringValue) {
        int state_0 = this.state_0_;
        if (charsetValue instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue_ = (LLVMReadCharsetNode.LLVMCharset)charsetValue;
            this.state_0_ = state_0 |= 1;
            return this.doFromString(charsetValue_, rawStringValue);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.charset_, this.rawString_}, new Object[]{charsetValue, rawStringValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMPolyglotFromString create(LLVMReadCharsetNode charset, LLVMPolyglotFromString.ReadBytesNode rawString) {
        return new LLVMPolyglotFromStringNodeGen(charset, rawString);
    }

    @GeneratedBy(value=LLVMPolyglotFromString.PutCharNode.class)
    static final class PutCharNodeGen
    extends LLVMPolyglotFromString.PutCharNode {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private PutCharNodeGen() {
        }

        @Override
        protected int execute(byte[] arg0Value, Object arg1Value, ByteArraySupport arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    return this.doByte(arg0Value, arg1Value_, arg2Value, arg3Value);
                }
                if ((state_0 & 2) != 0 && arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    return this.doShort(arg0Value, arg1Value_, arg2Value, arg3Value);
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return this.doInt(arg0Value, arg1Value_, arg2Value, arg3Value);
                }
                if ((state_0 & 8) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    return this.doLong(arg0Value, arg1Value_, arg2Value, arg3Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(byte[] arg0Value, Object arg1Value, ByteArraySupport arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (Byte)arg1Value;
                this.state_0_ = state_0 |= 1;
                return this.doByte(arg0Value, arg1Value_, arg2Value, arg3Value);
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (Short)arg1Value;
                this.state_0_ = state_0 |= 2;
                return this.doShort(arg0Value, arg1Value_, arg2Value, arg3Value);
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_ = state_0 |= 4;
                return this.doInt(arg0Value, arg1Value_, arg2Value, arg3Value);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                this.state_0_ = state_0 |= 8;
                return this.doLong(arg0Value, arg1Value_, arg2Value, arg3Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotFromString.PutCharNode create() {
            return new PutCharNodeGen();
        }
    }

    @GeneratedBy(value=LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.class)
    static final class ReadZeroTerminatedBytesNodeGen
    extends LLVMPolyglotFromString.ReadZeroTerminatedBytesNode {
        @Node.Child
        private LLVMReadCharsetNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ReadData read_cache;

        private ReadZeroTerminatedBytesNodeGen(LLVMReadCharsetNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        @ExplodeLoop
        protected byte[] execute(VirtualFrame frameValue, LLVMReadCharsetNode.LLVMCharset child0Value) {
            int state_0 = this.state_0_;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (state_0 != 0 && LLVMTypes.isPointer(child1Value_)) {
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                ReadData s1_ = this.read_cache;
                while (s1_ != null) {
                    if (child0Value.zeroTerminatorLen == s1_.increment_) {
                        return this.doRead(child0Value, child1Value__, s1_.increment_, s1_.load_, s1_.put_);
                    }
                    s1_ = s1_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value, child1Value_);
        }

        private byte[] executeAndSpecialize(Object child0Value, Object child1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (child0Value instanceof LLVMReadCharsetNode.LLVMCharset) {
                    LLVMReadCharsetNode.LLVMCharset child0Value_ = (LLVMReadCharsetNode.LLVMCharset)child0Value;
                    if (LLVMTypes.isPointer(child1Value)) {
                        LLVMPointer child1Value_ = LLVMTypes.asPointer(child1Value);
                        int count1_ = 0;
                        ReadData s1_ = this.read_cache;
                        if (state_0 != 0) {
                            while (s1_ != null && child0Value_.zeroTerminatorLen != s1_.increment_) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 4) {
                            s1_ = (ReadData)super.insert((Node)new ReadData(this.read_cache));
                            s1_.increment_ = child0Value_.zeroTerminatorLen;
                            s1_.load_ = s1_.insertAccessor(LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.createLoad(s1_.increment_));
                            s1_.put_ = s1_.insertAccessor(LLVMPolyglotFromString.PutCharNode.create());
                            this.read_cache = s1_;
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            byte[] byArray = this.doRead(child0Value_, child1Value_, s1_.increment_, s1_.load_, s1_.put_);
                            return byArray;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ReadData s1_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.read_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotFromString.ReadZeroTerminatedBytesNode create(LLVMReadCharsetNode child0, LLVMExpressionNode child1) {
            return new ReadZeroTerminatedBytesNodeGen(child0, child1);
        }

        @GeneratedBy(value=LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.class)
        private static final class ReadData
        extends Node {
            @Node.Child
            ReadData next_;
            @CompilerDirectives.CompilationFinal
            int increment_;
            @Node.Child
            LLVMLoadNode load_;
            @Node.Child
            LLVMPolyglotFromString.PutCharNode put_;

            ReadData(ReadData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotFromString.ReadBytesWithLengthNode.class)
    static final class ReadBytesWithLengthNodeGen
    extends LLVMPolyglotFromString.ReadBytesWithLengthNode {
        @Node.Child
        private LLVMReadCharsetNode child0_;
        @Node.Child
        private LLVMExpressionNode string_;
        @Node.Child
        private LLVMExpressionNode len_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private ReadBytesWithLengthNodeGen(LLVMReadCharsetNode child0, LLVMExpressionNode string, LLVMExpressionNode len) {
            this.child0_ = child0;
            this.string_ = string;
            this.len_ = len;
        }

        @Override
        protected byte[] execute(VirtualFrame frameValue, LLVMReadCharsetNode.LLVMCharset child0Value) {
            long lenValue_;
            int state_0 = this.state_0_;
            Object stringValue_ = this.string_.executeGeneric(frameValue);
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value, stringValue_, ex.getResult());
            }
            if (state_0 != 0 && LLVMTypes.isPointer(stringValue_)) {
                LLVMPointer stringValue__ = LLVMTypes.asPointer(stringValue_);
                return this.doRead(child0Value, stringValue__, lenValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value, stringValue_, lenValue_);
        }

        private byte[] executeAndSpecialize(Object child0Value, Object stringValue, Object lenValue) {
            int state_0 = this.state_0_;
            if (child0Value instanceof LLVMReadCharsetNode.LLVMCharset) {
                LLVMReadCharsetNode.LLVMCharset child0Value_ = (LLVMReadCharsetNode.LLVMCharset)child0Value;
                if (LLVMTypes.isPointer(stringValue)) {
                    LLVMPointer stringValue_ = LLVMTypes.asPointer(stringValue);
                    if (lenValue instanceof Long) {
                        long lenValue_ = (Long)lenValue;
                        this.state_0_ = state_0 |= 1;
                        return this.doRead(child0Value_, stringValue_, lenValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.string_, this.len_}, new Object[]{child0Value, stringValue, lenValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPolyglotFromString.ReadBytesWithLengthNode create(LLVMReadCharsetNode child0, LLVMExpressionNode string, LLVMExpressionNode len) {
            return new ReadBytesWithLengthNodeGen(child0, string, len);
        }
    }
}

