/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64DivNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;

@GeneratedBy(value=LLVMAMD64DivNode.class)
public final class LLVMAMD64DivNodeFactory {

    @GeneratedBy(value=LLVMAMD64DivNode.LLVMAMD64DivqNode.class)
    public static final class LLVMAMD64DivqNodeGen
    extends LLVMAMD64DivNode.LLVMAMD64DivqNode {
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64DivqNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            long highValue_;
            int state_0 = this.state_0_;
            try {
                highValue_ = this.high_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if (highValue instanceof Long) {
                long highValue_ = (Long)highValue;
                if (leftValue instanceof Long) {
                    long leftValue_ = (Long)leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (Long)rightValue;
                        this.state_0_ = state_0 |= 1;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64DivNode.LLVMAMD64DivqNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64DivqNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64DivNode.LLVMAMD64DivlNode.class)
    public static final class LLVMAMD64DivlNodeGen
    extends LLVMAMD64DivNode.LLVMAMD64DivlNode {
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64DivlNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int highValue_;
            int state_0 = this.state_0_;
            try {
                highValue_ = this.high_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if (highValue instanceof Integer) {
                int highValue_ = (Integer)highValue;
                if (leftValue instanceof Integer) {
                    int leftValue_ = (Integer)leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (Integer)rightValue;
                        this.state_0_ = state_0 |= 1;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64DivNode.LLVMAMD64DivlNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64DivlNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64DivNode.LLVMAMD64DivwNode.class)
    public static final class LLVMAMD64DivwNodeGen
    extends LLVMAMD64DivNode.LLVMAMD64DivwNode {
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64DivwNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            short highValue_;
            int state_0 = this.state_0_;
            try {
                highValue_ = this.high_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if (highValue instanceof Short) {
                short highValue_ = (Short)highValue;
                if (leftValue instanceof Short) {
                    short leftValue_ = (Short)leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (Short)rightValue;
                        this.state_0_ = state_0 |= 1;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64DivNode.LLVMAMD64DivwNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64DivwNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64DivNode.LLVMAMD64DivbNode.class)
    public static final class LLVMAMD64DivbNodeGen
    extends LLVMAMD64DivNode.LLVMAMD64DivbNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64DivbNodeGen(LLVMAMD64WriteValueNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_0_ = state_0 |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64DivNode.LLVMAMD64DivbNode create(LLVMAMD64WriteValueNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64DivbNodeGen(out, left, right);
        }
    }
}

