/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LLVMThreadingStack {
    private final Map<Thread, LLVMStack> threadMap;
    private final long stackSize;
    private final Thread mainThread;

    public LLVMThreadingStack(Thread mainTread, long stackSize) {
        this.mainThread = mainTread;
        this.stackSize = stackSize;
        this.threadMap = new ConcurrentHashMap<Thread, LLVMStack>();
    }

    public LLVMStack getStack() {
        LLVMStack s = this.getCurrentStack();
        if (s == null) {
            s = this.createNewStack();
        }
        return s;
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMStack getCurrentStack() {
        return this.threadMap.get(Thread.currentThread());
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMStack createNewStack() {
        LLVMStack s = new LLVMStack(this.stackSize, LLVMLanguage.getContext());
        LLVMStack previous = this.threadMap.putIfAbsent(Thread.currentThread(), s);
        assert (previous == null);
        return s;
    }

    @CompilerDirectives.TruffleBoundary
    public void freeStack(LLVMMemory memory, Thread thread) {
        if (this.mainThread != Thread.currentThread()) {
            this.free(memory, thread);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void freeMainStack(LLVMMemory memory) {
        this.free(memory, this.mainThread);
    }

    private void free(LLVMMemory memory, Thread thread) {
        LLVMStack s = this.threadMap.remove(thread);
        if (s != null) {
            s.free(memory);
        }
    }
}

