/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMForeignReadNode.class)
public final class LLVMForeignReadNodeGen
extends LLVMForeignReadNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private ValueData value_cache;

    private LLVMForeignReadNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
            }
            if ((state_0 & 2) != 0 && arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                ValueData s2_ = this.value_cache;
                while (s2_ != null) {
                    if (arg1Value_.kind == s2_.cachedKind_) {
                        return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, s2_.cachedKind_, s2_.load_, s2_.dataEscape_);
                    }
                    s2_ = s2_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Object object = LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
                return object;
            }
            if (arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                int count2_ = 0;
                ValueData s2_ = this.value_cache;
                if ((state_0 & 2) != 0) {
                    while (s2_ != null && arg1Value_.kind != s2_.cachedKind_) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && count2_ < LLVMForeignReadNode.VALUE_KIND_COUNT) {
                    s2_ = (ValueData)super.insert((Node)new ValueData(this.value_cache));
                    s2_.cachedKind_ = arg1Value_.kind;
                    s2_.load_ = s2_.insertAccessor(LLVMOffsetLoadNode.create(s2_.cachedKind_));
                    s2_.dataEscape_ = s2_.insertAccessor(LLVMDataEscapeNode.create(s2_.cachedKind_.foreignToLLVMType));
                    this.value_cache = s2_;
                    this.state_0_ = state_0 |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMForeignReadNode.doValue(arg0Value, arg1Value_, s2_.cachedKind_, s2_.load_, s2_.dataEscape_);
                    return object;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ValueData s2_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.value_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMForeignReadNode create() {
        return new LLVMForeignReadNodeGen();
    }

    public static LLVMForeignReadNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMForeignReadNode.class)
    private static final class Uncached
    extends LLVMForeignReadNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
            if (arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, arg1Value_.kind, LLVMOffsetLoadNode.getUncached(arg1Value_.kind), LLVMDataEscapeNode.getUncached(arg1Value_.kind.foreignToLLVMType));
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMForeignReadNode.class)
    private static final class ValueData
    extends Node {
        @Node.Child
        ValueData next_;
        @CompilerDirectives.CompilationFinal
        LLVMInteropType.ValueKind cachedKind_;
        @Node.Child
        LLVMOffsetLoadNode load_;
        @Node.Child
        LLVMDataEscapeNode dataEscape_;

        ValueData(ValueData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

