/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMForeignGetIndexPointerNode
extends LLVMNode {
    public abstract LLVMPointer execute(LLVMInteropType var1, LLVMPointer var2, long var3) throws UnsupportedMessageException, InvalidArrayIndexException;

    @Specialization(guards={"array.elementType == elementType"})
    static LLVMPointer doCached(LLVMInteropType.Array array, LLVMPointer pointer, long idx, @Cached(value="array.elementSize") long elementSize, @Cached(value="array.elementType") LLVMInteropType elementType, @Cached BranchProfile exception) throws InvalidArrayIndexException {
        if (Long.compareUnsigned(idx, array.length) >= 0) {
            exception.enter();
            throw InvalidArrayIndexException.create((long)idx);
        }
        return pointer.increment(idx * elementSize).export(elementType);
    }

    @Specialization(replaces={"doCached"})
    static LLVMPointer doGeneric(LLVMInteropType.Array array, LLVMPointer pointer, long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
        return LLVMForeignGetIndexPointerNode.doCached(array, pointer, idx, array.elementSize, array.elementType, exception);
    }

    @Fallback
    static LLVMPointer doError(LLVMInteropType type, LLVMPointer object, long idx) throws UnsupportedMessageException {
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }
}

