/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class ToI64
extends ForeignToLLVM {
    @Specialization
    protected long fromInt(int value) {
        return value;
    }

    @Specialization
    protected long fromChar(char value) {
        return value;
    }

    @Specialization
    protected long fromShort(short value) {
        return value;
    }

    @Specialization
    protected long fromLong(long value) {
        return value;
    }

    @Specialization
    protected long fromByte(byte value) {
        return value;
    }

    @Specialization
    protected long fromFloat(float value) {
        return (long)value;
    }

    @Specialization
    protected long fromDouble(double value) {
        return (long)value;
    }

    @Specialization
    protected long fromBoolean(boolean value) {
        return value ? 1L : 0L;
    }

    @Specialization
    protected long fromString(String value) {
        return this.getSingleStringCharacter(value);
    }

    @Specialization
    protected LLVMPointer fromPointer(LLVMPointer value) {
        return value;
    }

    @Specialization(limit="5", guards={"foreigns.isForeign(obj)", "interop.isNumber(foreigns.asForeign(obj))"})
    protected long fromForeign(Object obj, @CachedLibrary(value="obj") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        try {
            return interop.asLong(foreigns.asForeign(obj));
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Polyglot number can't be converted to long.");
        }
    }

    @Specialization(limit="5", guards={"foreigns.isForeign(obj)", "!interop.isNumber(obj)"})
    protected Object fromForeignPointer(Object obj, @CachedLibrary(value="obj") InteropLibrary interop, @Cached ToPointer toPointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return toPointer.executeWithTarget(obj);
    }

    @CompilerDirectives.TruffleBoundary
    static long slowPathPrimitiveConvert(ForeignToLLVM thiz, Object value) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            return thiz.getSingleStringCharacter((String)value);
        }
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asLong(value);
        }
        catch (UnsupportedMessageException ex) {
            throw UnsupportedTypeException.create((Object[])new Object[]{value});
        }
    }
}

