/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;

public abstract class ToI1
extends ForeignToLLVM {
    @Specialization
    protected boolean fromInt(int value) {
        return value != 0;
    }

    @Specialization
    protected boolean fromChar(char value) {
        return value != '\u0000';
    }

    @Specialization
    protected boolean fromShort(short value) {
        return value != 0;
    }

    @Specialization
    protected boolean fromLong(long value) {
        return value != 0L;
    }

    @Specialization
    protected boolean fromByte(byte value) {
        return value != 0;
    }

    @Specialization
    protected boolean fromFloat(float value) {
        return value != 0.0f;
    }

    @Specialization
    protected boolean fromDouble(double value) {
        return value != 0.0;
    }

    @Specialization
    protected boolean fromBoolean(boolean value) {
        return value;
    }

    @Specialization
    protected boolean fromString(String value) {
        return this.getSingleStringCharacter(value) != '\u0000';
    }

    @Specialization(limit="5", guards={"foreigns.isForeign(obj)", "interop.isBoolean(foreigns.asForeign(obj))"})
    protected boolean fromForeign(Object obj, @CachedLibrary(value="obj") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        try {
            return interop.asBoolean(foreigns.asForeign(obj));
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Foreign object can't be converted to boolean.");
        }
    }

    @CompilerDirectives.TruffleBoundary
    static boolean slowPathPrimitiveConvert(ForeignToLLVM thiz, Object value) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue() != '\u0000';
        }
        if (value instanceof String) {
            return thiz.getSingleStringCharacter((String)value) != '\u0000';
        }
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asBoolean(value);
        }
        catch (UnsupportedMessageException ex) {
            throw UnsupportedTypeException.create((Object[])new Object[]{value});
        }
    }
}

