/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.types.Type;

public class LLVMForeignFunctionCallNode
extends LLVMForeignCallNode {
    protected LLVMForeignFunctionCallNode(LLVMLanguage language, LLVMFunctionDescriptor function, LLVMInteropType interopType, LLVMSourceFunctionType sourceType) {
        super(language, function, interopType, sourceType, LLVMForeignFunctionCallNode.getReturnBaseType(interopType), function.getLLVMFunction().getType().getReturnType());
    }

    public static LLVMForeignFunctionCallNode create(LLVMLanguage language, LLVMFunctionDescriptor function, LLVMInteropType interopType, LLVMSourceFunctionType sourceType) {
        return new LLVMForeignFunctionCallNode(language, function, interopType, sourceType);
    }

    @Override
    protected Object doCall(VirtualFrame frame, LLVMStack stack) throws ArityException, Type.TypeOverflowException {
        return this.callNode.call(this.packArguments.execute(frame.getArguments(), stack));
    }

    private static LLVMInteropType.Structured getReturnBaseType(LLVMInteropType functionType) {
        LLVMInteropType returnType;
        if (functionType instanceof LLVMInteropType.Function && (returnType = ((LLVMInteropType.Function)functionType).getReturnType()) instanceof LLVMInteropType.Value) {
            return ((LLVMInteropType.Value)returnType).baseType;
        }
        return null;
    }
}

