/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.value;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceArrayLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceBasicType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceForeignType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import java.math.BigInteger;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class)
public abstract class LLVMDebugObject
extends LLVMDebuggerValue {
    private static final InteropLibrary UNCACHED_INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private static final String[] NO_KEYS = new String[0];
    protected final long offset;
    protected final LLVMDebugValue value;
    private final LLVMSourceType type;
    private final LLVMSourceLocation location;

    LLVMDebugObject(LLVMDebugValue value, long offset, LLVMSourceType type, LLVMSourceLocation location) {
        this.value = value;
        this.offset = offset;
        this.type = type;
        this.location = location;
    }

    public final LLVMSourceType getType() {
        return this.type;
    }

    @ExportMessage
    public final Object getMetaObject() throws UnsupportedMessageException {
        if (this.type == null) {
            throw UnsupportedMessageException.create();
        }
        return this.type;
    }

    @ExportMessage
    public final boolean hasMetaObject() {
        return this.type != null;
    }

    @ExportMessage
    final boolean hasSourceLocation() {
        return this.location != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final SourceSection getSourceLocation() {
        return this.location.getSourceSection();
    }

    public LLVMSourceLocation getDeclaration() {
        return this.location;
    }

    protected String[] getKeys() {
        if (this.value == null) {
            return NO_KEYS;
        }
        return this.getKeysSafe();
    }

    protected abstract String[] getKeysSafe();

    private Object getMember(String identifier) {
        if (identifier == null) {
            return null;
        }
        return this.getMemberSafe(identifier);
    }

    protected abstract Object getMemberSafe(String var1);

    public Object getValue() {
        if (this.value == null) {
            return "";
        }
        return this.getValueSafe();
    }

    protected abstract Object getValueSafe();

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        Object currentValue = this.getValue();
        if (LLVMManagedPointer.isInstance(currentValue)) {
            String targetString;
            LLVMManagedPointer managedPointer = LLVMManagedPointer.cast(currentValue);
            Object target = managedPointer.getObject();
            if (target instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor function = (LLVMFunctionDescriptor)target;
                targetString = "LLVM function " + function.getLLVMFunction().getName();
            } else {
                targetString = "<managed pointer>";
            }
            long targetOffset = managedPointer.getOffset();
            if (targetOffset != 0L) {
                targetString = String.format("%s + %d byte%s", targetString, targetOffset, targetOffset == 1L ? "" : "s");
            }
            currentValue = targetString;
        }
        return Objects.toString(currentValue);
    }

    @Override
    protected int getElementCountForDebugger() {
        String[] keys = this.getKeys();
        return keys == null ? 0 : keys.length;
    }

    @Override
    protected String[] getKeysForDebugger() {
        String[] keys = this.getKeys();
        return keys != null ? keys : NO_KEYS;
    }

    @Override
    protected Object getElementForDebugger(String key) {
        return this.getMember(key);
    }

    public static LLVMDebugObject create(LLVMSourceType type, long baseOffset, LLVMDebugValue value, LLVMSourceLocation declaration) {
        if (type.getActualType() == LLVMSourceType.UNKNOWN || type.getActualType() == LLVMSourceType.UNSUPPORTED) {
            return new Unsupported(value, baseOffset, LLVMSourceType.UNSUPPORTED, declaration);
        }
        if (value != null && value.isInteropValue()) {
            return new Foreign(value, baseOffset, type, declaration);
        }
        if (type.isAggregate()) {
            int elementCount = type.getElementCount();
            if (elementCount < 0) {
                elementCount = 0;
            }
            String[] memberIdentifiers = new String[elementCount];
            for (int i = 0; i < elementCount; ++i) {
                memberIdentifiers[i] = type.getElementName(i);
            }
            return new Structured(value, baseOffset, type, memberIdentifiers, declaration);
        }
        if (type.isPointer()) {
            return new Pointer(value, baseOffset, type, declaration);
        }
        if (type.isEnum()) {
            return new Enum(value, baseOffset, type, declaration);
        }
        if (type instanceof LLVMSourceStaticMemberType.CollectionType) {
            return new StaticMembers((LLVMSourceStaticMemberType.CollectionType)type);
        }
        return new Primitive(value, baseOffset, type, declaration);
    }

    private static final class Foreign
    extends LLVMDebugObject {
        private static final String VALUE = "<interop value>";

        Foreign(LLVMDebugValue value, long offset, LLVMSourceType valueType, LLVMSourceLocation location) {
            super(value, offset, new LLVMSourceForeignType(valueType), location);
        }

        @Override
        protected String[] getKeysSafe() {
            return LLVMSourceForeignType.KEYS;
        }

        @Override
        protected Object getMemberSafe(String identifier) {
            if (!"Unindexed Interop Value".equals(identifier)) {
                return null;
            }
            Object obj = this.value.asInteropValue();
            if (((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).isForeign(obj)) {
                obj = ((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).asForeign(obj);
            }
            return obj;
        }

        @Override
        protected Object getValueSafe() {
            return VALUE;
        }
    }

    private static final class Unsupported
    extends LLVMDebugObject {
        Unsupported(LLVMDebugValue value, long offset, LLVMSourceType type, LLVMSourceLocation location) {
            super(value, offset, type, location);
        }

        @Override
        protected String[] getKeysSafe() {
            return NO_KEYS;
        }

        @Override
        protected Object getMemberSafe(String identifier) {
            return null;
        }

        @Override
        protected Object getValueSafe() {
            return this.value.describeValue(0L, 0);
        }
    }

    private static final class StaticMembers
    extends LLVMDebugObject {
        StaticMembers(LLVMSourceStaticMemberType.CollectionType type) {
            super(LLVMDebugValue.UNAVAILABLE, 0L, type, null);
        }

        @Override
        public String[] getKeysSafe() {
            return ((LLVMSourceStaticMemberType.CollectionType)this.getType()).getIdentifiers();
        }

        @Override
        public Object getMemberSafe(String key) {
            LLVMSourceType elementType = this.getType().getElementType(key);
            LLVMSourceLocation declaration = this.getType().getElementDeclaration(key);
            LLVMDebugObjectBuilder debugValue = ((LLVMSourceStaticMemberType.CollectionType)this.getType()).getMemberValue(key);
            return debugValue.getValue(elementType, declaration);
        }

        @Override
        public Object getValueSafe() {
            return "";
        }
    }

    private static final class Pointer
    extends LLVMDebugObject {
        private static final String[] SAFE_DEREFERENCE_KEYS = new String[]{"<target>"};
        private static final String[] FOREIGN_KEYS = new String[]{"<foreign>", "<offset>"};
        private final LLVMSourcePointerType pointerType;

        Pointer(LLVMDebugValue value, long offset, LLVMSourceType type, LLVMSourceLocation declaration) {
            super(value, offset, type, declaration);
            LLVMSourceType actualType = this.getType().getActualType();
            this.pointerType = actualType instanceof LLVMSourcePointerType ? (LLVMSourcePointerType)actualType : null;
        }

        private boolean isPointerToForeign() {
            if (this.value.isManagedPointer()) {
                Object base = this.value.getManagedPointerBase();
                return ((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).isForeign(base);
            }
            return false;
        }

        @Override
        public String[] getKeysSafe() {
            if (this.pointerType != null && !this.pointerType.isReference() && (this.value.isAlwaysSafeToDereference(this.offset) || this.pointerType.isSafeToDereference())) {
                return SAFE_DEREFERENCE_KEYS;
            }
            if (this.isPointerToForeign()) {
                return FOREIGN_KEYS;
            }
            LLVMDebugObject target = this.dereference();
            return target == null ? NO_KEYS : target.getKeys();
        }

        @Override
        public Object getMemberSafe(String identifier) {
            if (FOREIGN_KEYS[0].equals(identifier)) {
                Object base = this.value.getManagedPointerBase();
                if (((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).isForeign(base)) {
                    return ((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).asForeign(base);
                }
                return "Cannot get foreign base pointer!";
            }
            if (FOREIGN_KEYS[1].equals(identifier)) {
                return this.value.getManagedPointerOffset();
            }
            LLVMDebugObject target = this.dereference();
            if (target == null) {
                return "Cannot dereference pointer!";
            }
            if (SAFE_DEREFERENCE_KEYS[0].equals(identifier)) {
                assert (this.pointerType != null);
                assert (!this.pointerType.isReference());
                assert (this.value.isAlwaysSafeToDereference(this.offset) || this.pointerType.isSafeToDereference());
                return target;
            }
            return target.getMember(identifier);
        }

        @Override
        protected Object getValueSafe() {
            if (this.isPointerToForeign()) {
                long o = this.offset + this.value.getManagedPointerOffset();
                if (o == 0L) {
                    return "<foreign>";
                }
                return String.format("<foreign> + %d byte", o);
            }
            if (this.pointerType == null || !this.pointerType.isReference()) {
                return this.value.readAddress(this.offset);
            }
            LLVMDebugObject target = this.dereference();
            return target == null ? this.value.readAddress(this.offset) : target.getValue();
        }

        private LLVMDebugObject dereference() {
            if (this.pointerType == null || !this.pointerType.isSafeToDereference() && !this.value.isAlwaysSafeToDereference(this.offset)) {
                return null;
            }
            LLVMDebugValue targetValue = this.value.dereferencePointer(this.offset);
            if (targetValue == null) {
                return null;
            }
            return Pointer.create(this.pointerType.getBaseType(), 0L, targetValue, null);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Primitive
    extends LLVMDebugObject {
        private static final int LONGDOUBLE_SIZE = 128;

        Primitive(LLVMDebugValue value, long offset, LLVMSourceType type, LLVMSourceLocation declaration) {
            super(value, offset, type, declaration);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isString() {
            Object v = this.getValue();
            return v instanceof String;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        String asString() throws UnsupportedMessageException {
            Object v = this.getValue();
            if (v instanceof String) {
                return (String)v;
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isNumber() {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return true;
            }
            return UNCACHED_INTEROP.isNumber(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean fitsInByte() {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                try {
                    byte b = ((BigInteger)v).byteValueExact();
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
            return UNCACHED_INTEROP.fitsInByte(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean fitsInShort() {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                try {
                    short s = ((BigInteger)v).shortValueExact();
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
            return UNCACHED_INTEROP.fitsInShort(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean fitsInInt() {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                try {
                    int i = ((BigInteger)v).intValueExact();
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
            return UNCACHED_INTEROP.fitsInInt(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean fitsInLong() {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                try {
                    long l = ((BigInteger)v).longValueExact();
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
            return UNCACHED_INTEROP.fitsInLong(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean fitsInFloat() {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return true;
            }
            return UNCACHED_INTEROP.fitsInFloat(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean fitsInDouble() {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return true;
            }
            return UNCACHED_INTEROP.fitsInDouble(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        byte asByte() throws UnsupportedMessageException {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return ((BigInteger)v).byteValue();
            }
            return UNCACHED_INTEROP.asByte(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        short asShort() throws UnsupportedMessageException {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return ((BigInteger)v).shortValue();
            }
            return UNCACHED_INTEROP.asShort(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        int asInt() throws UnsupportedMessageException {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return ((BigInteger)v).intValue();
            }
            return UNCACHED_INTEROP.asInt(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long asLong() throws UnsupportedMessageException {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return ((BigInteger)v).longValue();
            }
            return UNCACHED_INTEROP.asLong(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        float asFloat() throws UnsupportedMessageException {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return ((BigInteger)v).floatValue();
            }
            return UNCACHED_INTEROP.asFloat(v);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        double asDouble() throws UnsupportedMessageException {
            Object v = this.getValue();
            if (v instanceof BigInteger) {
                return ((BigInteger)v).doubleValue();
            }
            return UNCACHED_INTEROP.asDouble(v);
        }

        @Override
        public String[] getKeysSafe() {
            return NO_KEYS;
        }

        @Override
        public Object getMemberSafe(String identifier) {
            return null;
        }

        @Override
        public Object getValueSafe() {
            int size = (int)this.getType().getSize();
            LLVMSourceType actualType = this.getType().getActualType();
            if (actualType instanceof LLVMSourceBasicType) {
                switch (((LLVMSourceBasicType)actualType).getKind()) {
                    case ADDRESS: {
                        return this.value.readAddress(this.offset);
                    }
                    case BOOLEAN: {
                        return this.value.readBoolean(this.offset);
                    }
                    case FLOATING: {
                        return this.readFloating();
                    }
                    case SIGNED: {
                        return this.value.readBigInteger(this.offset, size, true);
                    }
                    case SIGNED_CHAR: {
                        Object intRead = this.value.readBigInteger(this.offset, size, true);
                        if (intRead instanceof BigInteger) {
                            return Character.valueOf((char)((BigInteger)intRead).byteValue());
                        }
                        return intRead;
                    }
                    case UNSIGNED: {
                        return this.value.readBigInteger(this.offset, size, false);
                    }
                    case UNSIGNED_CHAR: {
                        Object intRead = this.value.readBigInteger(this.offset, size, false);
                        if (intRead instanceof BigInteger) {
                            return Character.valueOf((char)Byte.toUnsignedInt(((BigInteger)intRead).byteValue()));
                        }
                        return intRead;
                    }
                }
            }
            return this.value.readUnknown(this.offset, size);
        }

        private Object readFloating() {
            int size = (int)this.getType().getSize();
            try {
                switch (size) {
                    case 32: {
                        return this.value.readFloat(this.offset);
                    }
                    case 64: {
                        return this.value.readDouble(this.offset);
                    }
                    case 80: 
                    case 128: {
                        return this.value.read80BitFloat(this.offset);
                    }
                }
                return this.value.readUnknown(this.offset, size);
            }
            catch (IllegalStateException e) {
                CompilerDirectives.transferToInterpreter();
                return e.getMessage();
            }
        }
    }

    private static final class Structured
    extends LLVMDebugObject {
        private static final int STRING_MAX_LENGTH = 64;
        private final String[] memberIdentifiers;

        Structured(LLVMDebugValue value, long offset, LLVMSourceType type, String[] memberIdentifiers, LLVMSourceLocation declaration) {
            super(value, offset, type, declaration);
            this.memberIdentifiers = memberIdentifiers;
        }

        @Override
        public String[] getKeysSafe() {
            return this.memberIdentifiers;
        }

        @Override
        public Object getMemberSafe(String key) {
            LLVMSourceType elementType = this.getType().getElementType(key);
            long newOffset = this.offset + elementType.getOffset();
            LLVMSourceLocation declaration = this.getType().getElementDeclaration(key);
            return Structured.create(elementType, newOffset, this.value, declaration);
        }

        @Override
        protected Object getValueSafe() {
            LLVMSourceType baseType;
            Object o = this.value.computeAddress(this.offset);
            LLVMSourceType actualType = this.getType().getActualType();
            if (actualType instanceof LLVMSourceArrayLikeType && (baseType = ((LLVMSourceArrayLikeType)actualType).getBaseType().getActualType()) instanceof LLVMSourceBasicType) {
                switch (((LLVMSourceBasicType)baseType).getKind()) {
                    case UNSIGNED_CHAR: {
                        o = this.appendString(o, false);
                        break;
                    }
                    case SIGNED_CHAR: {
                        o = this.appendString(o, true);
                    }
                }
            }
            return o;
        }

        private Object appendString(Object o, boolean signed) {
            if (this.getType().getElementCount() <= 0) {
                return o;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(o).append(" \"");
            int numChars = Math.min(this.getType().getElementCount(), 64);
            for (int i = 0; i < numChars; ++i) {
                int size;
                LLVMSourceType elementType = this.getType().getElementType(i);
                long newOffset = this.offset + elementType.getOffset();
                if (!this.value.canRead(newOffset, size = (int)elementType.getSize())) {
                    sb.append("??");
                    continue;
                }
                Object intRead = this.value.readBigInteger(newOffset, size, signed);
                if (intRead instanceof BigInteger) {
                    char ch;
                    byte byteVal = ((BigInteger)intRead).byteValue();
                    char c = ch = signed ? (char)byteVal : (char)Byte.toUnsignedInt(byteVal);
                    if (ch == '\u0000') break;
                    sb.append(ch);
                    continue;
                }
                sb.append("??");
            }
            if (numChars < this.getType().getElementCount()) {
                sb.append("... (+ ").append(this.getType().getElementCount() - numChars).append(" characters)");
            }
            sb.append("\"");
            return sb.toString();
        }
    }

    private static final class Enum
    extends LLVMDebugObject {
        Enum(LLVMDebugValue value, long offset, LLVMSourceType type, LLVMSourceLocation declaration) {
            super(value, offset, type, declaration);
        }

        @Override
        protected Object getValueSafe() {
            int size = (int)this.getType().getSize();
            Object idRead = this.value.readBigInteger(this.offset, size, false);
            if (!(idRead instanceof BigInteger)) {
                return this.value.describeValue(this.offset, size);
            }
            BigInteger id = (BigInteger)idRead;
            if (size >= 64) {
                return LLVMDebugValue.toHexString(id);
            }
            String enumVal = this.getType().getElementName(id.longValue());
            return enumVal != null ? enumVal : LLVMDebugValue.toHexString(id);
        }

        @Override
        public String[] getKeysSafe() {
            return NO_KEYS;
        }

        @Override
        public Object getMemberSafe(String identifier) {
            return null;
        }
    }
}

