/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

public abstract class DebugExprShortCircuitEvaluationNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode leftNode;
    @Node.Child
    private LLVMExpressionNode rightNode;
    @Node.Child
    private ShortCircuitOpNode op;
    private final ConditionProfile evaluateRightProfile = ConditionProfile.createCountingProfile();

    public DebugExprShortCircuitEvaluationNode(LLVMExpressionNode leftNode, LLVMExpressionNode rightNode, ShortCircuitOpNode op) {
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.op = op;
    }

    @Specialization
    public final boolean doShortCircuit(VirtualFrame frame) {
        boolean rightValue;
        boolean leftValue;
        try {
            leftValue = this.leftNode.executeI1(frame);
        }
        catch (UnexpectedResultException e) {
            throw DebugExprException.typeError(this, e.getResult(), null);
        }
        try {
            rightValue = this.evaluateRightProfile.profile(this.op.shouldEvaluateRight(leftValue)) ? this.rightNode.executeI1(frame) : false;
        }
        catch (UnexpectedResultException e) {
            throw DebugExprException.typeError(this, leftValue, e.getResult());
        }
        return this.op.execute(leftValue, rightValue);
    }

    static abstract class ShortCircuitOpNode
    extends LLVMNode {
        ShortCircuitOpNode() {
        }

        protected abstract boolean shouldEvaluateRight(boolean var1);

        protected abstract boolean execute(boolean var1, boolean var2);
    }
}

