/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprArrayElementNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DebugExprArrayElementNode.class)
public final class DebugExprArrayElementNodeGen
extends DebugExprArrayElementNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private LLVMExpressionNode base_;
    @Node.Child
    private LLVMExpressionNode index_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private InteropLibrary intIndex_library_;
    @Node.Child
    private InteropLibrary generic_library_;

    private DebugExprArrayElementNodeGen(DebugExprType type, LLVMExpressionNode base, LLVMExpressionNode index) {
        super(type);
        this.base_ = base;
        this.index_ = index;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        if ((state_0 & 2) == 0 && state_0 != 0) {
            return this.executeGeneric_int0(state_0, frameValue, baseValue_);
        }
        return this.executeGeneric_generic1(state_0, frameValue, baseValue_);
    }

    private Object executeGeneric_int0(int state_0, VirtualFrame frameValue, Object baseValue_) {
        int indexValue_;
        try {
            indexValue_ = this.index_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(baseValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return this.doIntIndex(baseValue_, indexValue_, this.intIndex_library_);
    }

    private Object executeGeneric_generic1(int state_0, VirtualFrame frameValue, Object baseValue_) {
        Object indexValue_ = this.index_.executeGeneric(frameValue);
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && indexValue_ instanceof Integer) {
                int indexValue__ = (Integer)indexValue_;
                return this.doIntIndex(baseValue_, indexValue__, this.intIndex_library_);
            }
            if ((state_0 & 2) != 0) {
                return this.doGeneric(baseValue_, indexValue_, this.generic_library_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, indexValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object baseValue, Object indexValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (indexValue instanceof Integer) {
                int indexValue_ = (Integer)indexValue;
                this.intIndex_library_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doIntIndex(baseValue, indexValue_, this.intIndex_library_);
                return object;
            }
            this.generic_library_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
            this.state_0_ = state_0 |= 2;
            lock.unlock();
            hasLock = false;
            Object object = this.doGeneric(baseValue, indexValue, this.generic_library_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static DebugExprArrayElementNode create(DebugExprType type, LLVMExpressionNode base, LLVMExpressionNode index) {
        return new DebugExprArrayElementNodeGen(type, base, index);
    }
}

