/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.datalayout;

import com.oracle.truffle.llvm.runtime.datalayout.DataLayoutType;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

final class DataLayoutParser {
    DataLayoutParser() {
    }

    private static void addIfMissing(List<DataTypeSpecification> specs, DataTypeSpecification newSpec) {
        assert (newSpec.type == DataLayoutType.INTEGER || newSpec.type == DataLayoutType.POINTER || newSpec.type == DataLayoutType.FLOAT);
        for (DataTypeSpecification spec : specs) {
            if (spec.type != newSpec.type || spec.getSize() != newSpec.getSize()) continue;
            return;
        }
        specs.add(newSpec);
    }

    static ByteOrder parseDataLayout(String layout, List<DataTypeSpecification> specs) {
        String[] layoutSpecs;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        for (String spec : layoutSpecs = layout.split("-")) {
            if (spec.equals("E")) {
                byteOrder = ByteOrder.BIG_ENDIAN;
                continue;
            }
            if (spec.equals("e")) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                continue;
            }
            DataLayoutType type = DataLayoutParser.getDataType(spec);
            DataTypeSpecification dataTypeSpec = DataLayoutParser.createDataTypeSpec(type, spec);
            if (dataTypeSpec == null) continue;
            specs.add(dataTypeSpec);
        }
        for (int i = 0; i < specs.size(); ++i) {
            DataTypeSpecification spec = specs.get(i);
            if (spec.getType() != DataLayoutType.INTEGER_WIDTHS) continue;
            for (int value : spec.getValues()) {
                DataLayoutParser.addIfMissing(specs, new DataTypeSpecification(DataLayoutType.INTEGER, value, value, value));
            }
        }
        DataLayoutParser.addIfMissing(specs, new DataTypeSpecification(DataLayoutType.FLOAT, 32, 32, 32));
        DataLayoutParser.addIfMissing(specs, new DataTypeSpecification(DataLayoutType.FLOAT, 64, 64, 64));
        DataLayoutParser.checkPointerType(specs);
        return byteOrder;
    }

    private static void checkPointerType(List<DataTypeSpecification> specs) {
        boolean isPointerTypeFound = false;
        for (DataTypeSpecification spec : specs) {
            if (spec.type != DataLayoutType.POINTER) continue;
            isPointerTypeFound = true;
            break;
        }
        if (!isPointerTypeFound) {
            int largestIntegerTypeSize = -1;
            for (DataTypeSpecification spec : specs) {
                if (spec.type != DataLayoutType.INTEGER || spec.getSize() <= largestIntegerTypeSize) continue;
                largestIntegerTypeSize = spec.getSize();
            }
            if (largestIntegerTypeSize > 0) {
                specs.add(new DataTypeSpecification(DataLayoutType.POINTER, largestIntegerTypeSize, largestIntegerTypeSize, largestIntegerTypeSize));
            }
        }
    }

    private static DataTypeSpecification createDataTypeSpec(DataLayoutType type, String spec) {
        String[] components = spec.split(":");
        components[0] = components[0].substring(1);
        if (type == DataLayoutType.INTEGER || type == DataLayoutType.FLOAT) {
            assert (components.length >= 1);
            int size = DataLayoutParser.convertToInt(components, 0);
            int abiAlignment = DataLayoutParser.convertToInt(components, 1, size);
            int preferredAlignment = DataLayoutParser.convertToInt(components, 2, abiAlignment);
            return new DataTypeSpecification(type, size, abiAlignment, preferredAlignment);
        }
        if (type == DataLayoutType.POINTER) {
            assert (components.length >= 2);
            int size = DataLayoutParser.convertToInt(components, 1);
            int abiAlignment = DataLayoutParser.convertToInt(components, 2, size);
            int preferredAlignment = DataLayoutParser.convertToInt(components, 3, abiAlignment);
            return new DataTypeSpecification(type, size, abiAlignment, preferredAlignment);
        }
        if (type == DataLayoutType.INTEGER_WIDTHS) {
            return new DataTypeSpecification(type, DataLayoutParser.convertToInt(components));
        }
        return null;
    }

    private static int[] convertToInt(String[] components) {
        int[] values = new int[components.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = DataLayoutParser.convertToInt(components, i);
        }
        return values;
    }

    private static int convertToInt(String[] components, int index) {
        return Integer.parseInt(components[index]);
    }

    private static int convertToInt(String[] components, int index, int defaultValue) {
        if (index >= components.length) {
            return defaultValue;
        }
        return Integer.parseInt(components[index]);
    }

    private static DataLayoutType getDataType(String spec) {
        if (spec.startsWith("i")) {
            return DataLayoutType.INTEGER;
        }
        if (spec.startsWith("f")) {
            return DataLayoutType.FLOAT;
        }
        if (spec.startsWith("p")) {
            return DataLayoutType.POINTER;
        }
        if (spec.startsWith("n") && !spec.startsWith("ni")) {
            return DataLayoutType.INTEGER_WIDTHS;
        }
        return null;
    }

    static final class DataTypeSpecification {
        private final DataLayoutType type;
        private final int[] values;

        private DataTypeSpecification(DataLayoutType type, int size, int abiAlignment, int preferredAlignment) {
            assert (type == DataLayoutType.INTEGER || type == DataLayoutType.POINTER || type == DataLayoutType.FLOAT);
            this.type = type;
            this.values = new int[]{size, abiAlignment, preferredAlignment};
        }

        private DataTypeSpecification(DataLayoutType type, int[] values) {
            assert (type == DataLayoutType.INTEGER_WIDTHS);
            this.type = type;
            this.values = values;
        }

        DataLayoutType getType() {
            return this.type;
        }

        int[] getValues() {
            assert (this.type == DataLayoutType.INTEGER_WIDTHS);
            return this.values;
        }

        int getSize() {
            assert (this.type == DataLayoutType.INTEGER || this.type == DataLayoutType.POINTER || this.type == DataLayoutType.FLOAT);
            return this.values[0];
        }

        int getAbiAlignment() {
            assert (this.type == DataLayoutType.INTEGER || this.type == DataLayoutType.POINTER || this.type == DataLayoutType.FLOAT);
            return this.values[1];
        }

        int getPreferredAlignment() {
            assert (this.type == DataLayoutType.INTEGER || this.type == DataLayoutType.POINTER || this.type == DataLayoutType.FLOAT);
            return this.values[2];
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DataTypeSpecification) {
                DataTypeSpecification other = (DataTypeSpecification)obj;
                return this.type == other.type && Arrays.equals(this.values, other.values);
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode() + Arrays.hashCode(this.values);
        }

        public String toString() {
            return (Object)((Object)this.getType()) + " " + Arrays.toString(this.values);
        }
    }
}

