/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignConstructorCallNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignFunctionCallNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import java.util.HashMap;
import java.util.Map;

public final class LLVMFunctionCode {
    private static final long SULONG_FUNCTION_POINTER_TAG = -4981268375154982912L;
    @CompilerDirectives.CompilationFinal
    private Function functionFinal;
    private Function functionDynamic;
    @CompilerDirectives.CompilationFinal
    private Assumption assumption;
    private final LLVMFunction llvmFunction;
    private CallTarget foreignFunctionCallTarget;
    private CallTarget foreignConstructorCallTarget;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LLVMFunctionCode(LLVMFunction llvmFunction) {
        this.llvmFunction = llvmFunction;
        this.functionFinal = this.functionDynamic = llvmFunction.getFunction();
        this.assumption = Truffle.getRuntime().createAssumption();
    }

    private static long tagSulongFunctionPointer(int id) {
        return (long)id | 0xBADEFACE00000000L;
    }

    public void resolveIfLazyLLVMIRFunction() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getFunction() instanceof LazyLLVMIRFunction) {
            this.getFunction().resolve(this);
            if (!$assertionsDisabled && !(this.getFunction() instanceof LLVMIRFunction)) {
                throw new AssertionError();
            }
        }
    }

    public boolean isLLVMIRFunction() {
        Function currentFunction = this.getFunction();
        return currentFunction instanceof LLVMIRFunction || currentFunction instanceof LazyLLVMIRFunction;
    }

    public boolean isIntrinsicFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.isIntrinsicFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public boolean isIntrinsicFunction(ResolveFunctionNode resolve) {
        return resolve.execute(this.getFunction(), this) instanceof IntrinsicFunction;
    }

    public boolean isNativeFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.isNativeFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public boolean isNativeFunction(ResolveFunctionNode resolve) {
        return resolve.execute(this.getFunction(), this) instanceof NativeFunction;
    }

    public boolean isDefined() {
        return !(this.getFunction() instanceof UnresolvedFunction);
    }

    public void define(LLVMIntrinsicProvider intrinsicProvider, NodeFactory nodeFactory) {
        Intrinsic intrinsification = new Intrinsic(intrinsicProvider, this.llvmFunction.getName(), nodeFactory);
        this.define(new IntrinsicFunction(intrinsification, this.getFunction().getSourceType()));
    }

    public void define(Function newFunction) {
        this.setFunction(newFunction);
    }

    public RootCallTarget getLLVMIRFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getLLVMIRFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public RootCallTarget getLLVMIRFunction(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        return ((LLVMIRFunction)fn).callTarget;
    }

    public Intrinsic getIntrinsicSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getIntrinsic(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public Intrinsic getIntrinsic(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        return ((IntrinsicFunction)fn).intrinsic;
    }

    public Object getNativeFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getNativeFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public Object getNativeFunction(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        Object nativeFunction = ((NativeFunction)fn).nativeFunction;
        if (nativeFunction == null) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMLinkerException("Native function " + fn.toString() + " not found");
        }
        return nativeFunction;
    }

    CallTarget getForeignCallTarget(LLVMFunctionDescriptor functionDescriptor) {
        if (this.foreignFunctionCallTarget == null) {
            CompilerDirectives.transferToInterpreter();
            LLVMLanguage language = LLVMLanguage.getLanguage();
            LLVMSourceFunctionType sourceType = this.getFunction().getSourceType();
            LLVMInteropType interopType = language.getInteropType(sourceType);
            LLVMForeignFunctionCallNode foreignCall = LLVMForeignFunctionCallNode.create(language, functionDescriptor, interopType, sourceType);
            this.foreignFunctionCallTarget = Truffle.getRuntime().createCallTarget((RootNode)foreignCall);
            if (!$assertionsDisabled && this.foreignFunctionCallTarget == null) {
                throw new AssertionError();
            }
        }
        return this.foreignFunctionCallTarget;
    }

    CallTarget getForeignConstructorCallTarget(LLVMFunctionDescriptor functionDescriptor) {
        if (this.foreignConstructorCallTarget == null) {
            CompilerDirectives.transferToInterpreter();
            LLVMLanguage language = LLVMLanguage.getLanguage();
            LLVMSourceFunctionType sourceType = this.getFunction().getSourceType();
            LLVMInteropType interopType = language.getInteropType(sourceType);
            LLVMInteropType extractedType = ((LLVMInteropType.Function)interopType).getParameter(0);
            if (extractedType instanceof LLVMInteropType.Value) {
                LLVMInteropType.Structured structured = ((LLVMInteropType.Value)extractedType).baseType;
                LLVMForeignConstructorCallNode foreignCall = LLVMForeignConstructorCallNode.create(language, functionDescriptor, interopType, sourceType, structured);
                this.foreignConstructorCallTarget = Truffle.getRuntime().createCallTarget((RootNode)foreignCall);
            }
            if (!$assertionsDisabled && this.foreignConstructorCallTarget == null) {
                throw new AssertionError();
            }
        }
        return this.foreignConstructorCallTarget;
    }

    private void setFunction(Function newFunction) {
        this.functionDynamic = this.functionFinal = newFunction;
        this.assumption.invalidate();
        this.assumption = Truffle.getRuntime().createAssumption();
    }

    public Function getFunction() {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)this)) {
            if (!this.assumption.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.functionDynamic;
            }
            return this.functionFinal;
        }
        return this.functionDynamic;
    }

    public LLVMFunction getLLVMFunction() {
        return this.llvmFunction;
    }

    static {
        boolean bl = $assertionsDisabled = !LLVMFunctionCode.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !LLVMHandleMemoryBase.isCommonHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && LLVMHandleMemoryBase.isDerefHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
    }

    public static final class NativeFunction
    extends Function {
        private final Object nativeFunction;

        public NativeFunction(Object nativeFunction) {
            this.nativeFunction = nativeFunction;
        }

        @Override
        Object createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            return this.nativeFunction;
        }
    }

    public static final class IntrinsicFunction
    extends ManagedFunction {
        private final Intrinsic intrinsic;
        private final LLVMSourceFunctionType sourceType;

        public IntrinsicFunction(Intrinsic intrinsic, LLVMSourceFunctionType sourceType) {
            this.intrinsic = intrinsic;
            this.sourceType = sourceType;
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.sourceType;
        }
    }

    public static final class UnresolvedFunction
    extends Function {
        @Override
        void resolve(LLVMFunctionCode functionCode) {
            throw new LLVMLinkerException(String.format("Unresolved external function %s cannot be found.", functionCode.getLLVMFunction().getName()));
        }

        @Override
        Object createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            this.resolve(descriptor.getFunctionCode());
            return descriptor.getFunctionCode().getFunction().createNativeWrapper(descriptor);
        }
    }

    public static final class LLVMIRFunction
    extends ManagedFunction {
        private final RootCallTarget callTarget;
        private final LLVMSourceFunctionType sourceType;

        public LLVMIRFunction(RootCallTarget callTarget, LLVMSourceFunctionType sourceType) {
            this.callTarget = callTarget;
            this.sourceType = sourceType;
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.sourceType;
        }
    }

    public static final class LazyLLVMIRFunction
    extends ManagedFunction {
        private final LazyToTruffleConverter converter;

        public LazyLLVMIRFunction(LazyToTruffleConverter converter) {
            this.converter = converter;
        }

        @Override
        void resolve(LLVMFunctionCode descriptor) {
            RootCallTarget callTarget = this.converter.convert();
            LLVMSourceFunctionType sourceType = this.converter.getSourceType();
            descriptor.setFunction(new LLVMIRFunction(callTarget, sourceType));
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.converter.getSourceType();
        }
    }

    static abstract class ManagedFunction
    extends Function {
        ManagedFunction() {
        }

        @Override
        Object createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            LLVMContext context = LLVMLanguage.getContext();
            Object wrapper = null;
            LLVMNativePointer pointer = null;
            NativeContextExtension nativeContextExtension = context.getContextExtensionOrNull(NativeContextExtension.class);
            if (nativeContextExtension != null && (wrapper = nativeContextExtension.createNativeWrapper(descriptor.getLLVMFunction(), descriptor.getFunctionCode())) != null) {
                try {
                    pointer = LLVMNativePointer.create(((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer(wrapper));
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new AssertionError((Object)e);
                }
            }
            if (wrapper == null) {
                pointer = LLVMNativePointer.create(LLVMFunctionCode.tagSulongFunctionPointer(descriptor.getLLVMFunction().getSymbolIndex(false)));
                wrapper = pointer;
            }
            context.registerFunctionPointer(pointer, descriptor);
            return wrapper;
        }
    }

    @GenerateUncached
    public static abstract class ResolveFunctionNode
    extends LLVMNode {
        abstract Function execute(Function var1, LLVMFunctionCode var2);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Function doLazyLLVMIRFunction(LazyLLVMIRFunction function, LLVMFunctionCode descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction();
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Function doUnresolvedFunction(UnresolvedFunction function, LLVMFunctionCode descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction();
        }

        private static boolean resolveDoesNothing(Function function, LLVMFunctionCode descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction() == function;
        }

        @Fallback
        Function doOther(Function function, LLVMFunctionCode descriptor) {
            assert (ResolveFunctionNode.resolveDoesNothing(function, descriptor));
            return function;
        }
    }

    public static abstract class Function {
        void resolve(LLVMFunctionCode descriptor) {
            CompilerAsserts.neverPartOfCompilation();
        }

        abstract Object createNativeWrapper(LLVMFunctionDescriptor var1);

        LLVMSourceFunctionType getSourceType() {
            return null;
        }
    }

    public static interface LazyToTruffleConverter {
        public RootCallTarget convert();

        public LLVMSourceFunctionType getSourceType();
    }

    public static final class Intrinsic {
        private final String intrinsicName;
        private final Map<FunctionType, RootCallTarget> overloadingMap;
        private final LLVMIntrinsicProvider provider;
        private final NodeFactory nodeFactory;

        public Intrinsic(LLVMIntrinsicProvider provider, String name, NodeFactory nodeFactory) {
            this.intrinsicName = name;
            this.overloadingMap = new HashMap<FunctionType, RootCallTarget>();
            this.provider = provider;
            this.nodeFactory = nodeFactory;
        }

        public RootCallTarget cachedCallTarget(FunctionType type) {
            if (this.exists(type)) {
                return this.get(type);
            }
            return this.generateTarget(type);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean exists(FunctionType type) {
            return this.overloadingMap.containsKey(type);
        }

        @CompilerDirectives.TruffleBoundary
        private RootCallTarget get(FunctionType type) {
            return this.overloadingMap.get(type);
        }

        private RootCallTarget generateTarget(FunctionType type) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RootCallTarget newTarget = this.provider.generateIntrinsicTarget(this.intrinsicName, type.getArgumentTypes(), this.nodeFactory);
            assert (newTarget != null);
            this.overloadingMap.put(type, newTarget);
            return newTarget;
        }
    }
}

