/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMArgumentBuffer;
import com.oracle.truffle.llvm.runtime.LLVMExitException;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThread;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.instruments.trace.LLVMTracerInstrument;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.options.TargetStream;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;

public final class LLVMContext {
    public static final String SULONG_INIT_CONTEXT = "__sulong_init_context";
    public static final String SULONG_DISPOSE_CONTEXT = "__sulong_dispose_context";
    private static final String START_METHOD_NAME = "_start";
    private final List<Path> libraryPaths = new ArrayList<Path>();
    private final Object libraryPathsLock = new Object();
    private final Object truffleFilesLock = new Object();
    private final Toolchain toolchain;
    @CompilerDirectives.CompilationFinal
    private Path internalLibraryPath;
    @CompilerDirectives.CompilationFinal
    private TruffleFile internalLibraryPathFile;
    private final List<TruffleFile> truffleFiles = new ArrayList<TruffleFile>();
    private final List<String> internalLibraryNames;
    private final ConcurrentHashMap<LLVMPointer, List<LLVMSymbol>> symbolsReverseMap = new ConcurrentHashMap();
    protected final ArrayList<LLVMPointer> globalsNonPointerStore = new ArrayList();
    protected final EconomicMap<Integer, LLVMPointer> globalsReadOnlyStore = EconomicMap.create();
    private final Object globalsStoreLock = new Object();
    private final List<LLVMThread> runningThreads = new ArrayList<LLVMThread>();
    @CompilerDirectives.CompilationFinal
    private LLVMThreadingStack threadingStack;
    private Object[] mainArguments;
    private final ArrayList<LLVMNativePointer> caughtExceptionStack = new ArrayList();
    private ConcurrentHashMap<String, Integer> nativeCallStatistics;
    private final LLVMMemory.HandleContainer handleContainer;
    private final LLVMMemory.HandleContainer derefHandleContainer;
    private final LLVMSourceContext sourceContext;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private ContextExtension[] contextExtensions;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.Env env;
    private final LLVMScope globalScope;
    private final ArrayList<LLVMLocalScope> localScopes;
    private final DynamicLinkChain dynamicLinkChain;
    private final DynamicLinkChain dynamicLinkChainForScopes;
    private final List<RootCallTarget> destructorFunctions;
    private final LLVMFunctionPointerRegistry functionPointerRegistry;
    private final Map<Thread, Object> tls = new ConcurrentHashMap<Thread, Object>();
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private LLVMPointer[][] symbolFinalStorage;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private LLVMPointer[][] symbolDynamicStorage;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private Assumption[][] symbolAssumptions;
    private boolean[] libraryLoaded;
    private final LLVMNativePointer sigDfl;
    private final LLVMNativePointer sigIgn;
    private final LLVMNativePointer sigErr;
    private final LLVMPThreadContext pThreadContext;
    @CompilerDirectives.CompilationFinal
    Object freeGlobalsBlockFunction;
    @CompilerDirectives.CompilationFinal
    Object allocateGlobalsBlockFunction;
    @CompilerDirectives.CompilationFinal
    Object protectGlobalsBlockFunction;
    protected boolean initialized;
    protected boolean cleanupNecessary;
    private boolean initializeContextCalled;
    private DataLayout libsulongDatalayout;
    private Boolean datalayoutInitialised;
    private final LLVMLanguage language;
    private LLVMTracerInstrument tracer;
    @CompilerDirectives.CompilationFinal
    private TargetStream loaderTraceStream;
    @CompilerDirectives.CompilationFinal
    private TargetStream syscallTraceStream;
    @CompilerDirectives.CompilationFinal
    private TargetStream nativeCallStatsStream;
    @CompilerDirectives.CompilationFinal
    private TargetStream lifetimeAnalysisStream;
    @CompilerDirectives.CompilationFinal
    private TargetStream llDebugVerboseStream;

    LLVMContext(LLVMLanguage language, TruffleLanguage.Env env, Toolchain toolchain) {
        this.language = language;
        this.libsulongDatalayout = null;
        this.datalayoutInitialised = false;
        this.env = env;
        this.initialized = false;
        this.cleanupNecessary = false;
        this.destructorFunctions = new ArrayList<RootCallTarget>();
        this.nativeCallStatistics = SulongEngineOption.optionEnabled((String)env.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS)) ? new ConcurrentHashMap() : null;
        this.sigDfl = LLVMNativePointer.create(0L);
        this.sigIgn = LLVMNativePointer.create(1L);
        this.sigErr = LLVMNativePointer.create(-1L);
        LLVMMemory memory = language.getLLVMMemory();
        this.handleContainer = memory.createHandleContainer(false, language.getNoCommonHandleAssumption());
        this.derefHandleContainer = memory.createHandleContainer(true, language.getNoDerefHandleAssumption());
        this.functionPointerRegistry = new LLVMFunctionPointerRegistry();
        this.sourceContext = new LLVMSourceContext();
        this.toolchain = toolchain;
        this.internalLibraryNames = Collections.unmodifiableList(Arrays.asList(language.getCapability(PlatformCapability.class).getSulongDefaultLibraries()));
        assert (!this.internalLibraryNames.isEmpty()) : "No internal libraries?";
        this.globalScope = new LLVMScope();
        this.localScopes = new ArrayList();
        this.dynamicLinkChain = new DynamicLinkChain();
        this.dynamicLinkChainForScopes = new DynamicLinkChain();
        this.mainArguments = LLVMContext.getMainArguments(env);
        this.addLibraryPaths(SulongEngineOption.getPolyglotOptionSearchPaths(env));
        this.pThreadContext = new LLVMPThreadContext(this.getEnv(), this.getLanguage(), this.getLibsulongDataLayout());
        this.symbolAssumptions = new Assumption[10][];
        this.symbolDynamicStorage = new LLVMPointer[10][];
        this.symbolFinalStorage = this.symbolDynamicStorage;
        this.libraryLoaded = new boolean[10];
    }

    boolean patchContext(TruffleLanguage.Env newEnv) {
        if (this.initializeContextCalled) {
            return false;
        }
        this.env = newEnv;
        this.nativeCallStatistics = SulongEngineOption.optionEnabled((String)this.env.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS)) ? new ConcurrentHashMap() : null;
        this.mainArguments = LLVMContext.getMainArguments(newEnv);
        return true;
    }

    private static Object[] getMainArguments(TruffleLanguage.Env environment) {
        Object mainArgs = environment.getConfig().get("Sulong Main Args");
        return mainArgs == null ? environment.getApplicationArguments() : (Object[])mainArgs;
    }

    void initialize(ContextExtension[] contextExtens) {
        this.initializeContextCalled = true;
        assert (this.threadingStack == null);
        this.contextExtensions = contextExtens;
        String opt = (String)this.env.getOptions().get(SulongEngineOption.LD_DEBUG);
        this.loaderTraceStream = SulongEngineOption.optionEnabled(opt) ? new TargetStream(this.env, opt) : null;
        opt = (String)this.env.getOptions().get(SulongEngineOption.DEBUG_SYSCALLS);
        this.syscallTraceStream = SulongEngineOption.optionEnabled(opt) ? new TargetStream(this.env, opt) : null;
        opt = (String)this.env.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS);
        this.nativeCallStatsStream = SulongEngineOption.optionEnabled(opt) ? new TargetStream(this.env, opt) : null;
        opt = (String)this.env.getOptions().get(SulongEngineOption.PRINT_LIFE_TIME_ANALYSIS_STATS);
        this.lifetimeAnalysisStream = SulongEngineOption.optionEnabled(opt) ? new TargetStream(this.env, opt) : null;
        opt = (String)this.env.getOptions().get(SulongEngineOption.LL_DEBUG_VERBOSE);
        this.llDebugVerboseStream = SulongEngineOption.optionEnabled(opt) && (Boolean)this.env.getOptions().get(SulongEngineOption.LL_DEBUG) != false ? new TargetStream(this.env, opt) : null;
        opt = (String)this.env.getOptions().get(SulongEngineOption.TRACE_IR);
        if (SulongEngineOption.optionEnabled(opt)) {
            if (!((Boolean)this.env.getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
                throw new IllegalStateException("'--llvm.traceIR' requires '--llvm.llDebug=true'");
            }
            this.tracer = new LLVMTracerInstrument(this.env, opt);
        }
        this.threadingStack = new LLVMThreadingStack(Thread.currentThread(), LLVMContext.parseStackSize((String)this.env.getOptions().get(SulongEngineOption.STACK_SIZE)));
        String languageHome = this.language.getLLVMLanguageHome();
        if (languageHome != null) {
            PlatformCapability sysContextExt = this.language.getCapability(PlatformCapability.class);
            this.internalLibraryPath = Paths.get(languageHome, new String[0]).resolve(sysContextExt.getSulongLibrariesPath());
            this.internalLibraryPathFile = this.env.getInternalTruffleFile(this.internalLibraryPath.toUri());
            this.addLibraryPath(this.internalLibraryPath.toString());
        }
        for (ContextExtension ext : this.contextExtensions) {
            ext.initialize(this);
        }
        try {
            String[] sulongLibraryNames = this.language.getCapability(PlatformCapability.class).getSulongDefaultLibraries();
            for (int i = sulongLibraryNames.length - 1; i >= 0; --i) {
                TruffleFile file = InternalLibraryLocator.INSTANCE.locateLibrary(this, sulongLibraryNames[i], "<default bitcode library>");
                this.env.parseInternal(Source.newBuilder((String)"llvm", (TruffleFile)file).internal(this.isInternalLibraryFile(file)).build(), new String[0]);
            }
            this.setLibsulongAuxFunction(SULONG_INIT_CONTEXT);
            this.setLibsulongAuxFunction(SULONG_DISPOSE_CONTEXT);
            this.setLibsulongAuxFunction(START_METHOD_NAME);
            CallTarget builtinsLibrary = this.env.parseInternal(Source.newBuilder((String)"llvm", (TruffleFile)this.env.getInternalTruffleFile(this.internalLibraryPath.resolve(this.language.getCapability(PlatformCapability.class).getBuiltinsLibrary()).toUri())).internal(true).build(), new String[0]);
            builtinsLibrary.call(new Object[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setLibsulongAuxFunction(String name) {
        LLVMScope fileScope = this.language.getInternalFileScopes("libsulong");
        LLVMSymbol contextFunction = fileScope.get(name);
        if (contextFunction != null && contextFunction.isFunction()) {
            if (name.equals(SULONG_INIT_CONTEXT)) {
                this.language.setSulongInitContext(contextFunction.asFunction());
            } else if (name.equals(SULONG_DISPOSE_CONTEXT)) {
                this.language.setSulongDisposeContext(contextFunction.asFunction());
            } else if (name.equals(START_METHOD_NAME)) {
                this.language.setStartFunctionCode(new LLVMFunctionCode(contextFunction.asFunction()));
            }
        } else {
            throw new IllegalStateException("Context cannot be initialized: " + name + " was not found in sulong libraries");
        }
    }

    ContextExtension getContextExtension(int index) {
        CompilerAsserts.partialEvaluationConstant((int)index);
        return this.contextExtensions[index];
    }

    public <T extends ContextExtension> T getContextExtension(Class<T> type) {
        CompilerAsserts.neverPartOfCompilation();
        ContextExtension.Key<T> key = this.language.lookupContextExtension(type);
        if (key == null) {
            throw new IllegalStateException("Context extension of type " + type.getSimpleName() + " not found");
        }
        return key.get(this);
    }

    public <T extends ContextExtension> T getContextExtensionOrNull(Class<T> type) {
        CompilerAsserts.neverPartOfCompilation();
        ContextExtension.Key<T> key = this.language.lookupContextExtension(type);
        if (key == null) {
            return null;
        }
        return key.get(this);
    }

    public Path getInternalLibraryPath() {
        assert (this.isInitialized());
        return this.internalLibraryPath;
    }

    private static long parseStackSize(String v) {
        String valueString = v.trim();
        long scale = 1L;
        switch (valueString.charAt(valueString.length() - 1)) {
            case 'K': 
            case 'k': {
                scale = 1024L;
                break;
            }
            case 'M': 
            case 'm': {
                scale = 0x100000L;
                break;
            }
            case 'G': 
            case 'g': {
                scale = 0x40000000L;
                break;
            }
            case 'T': 
            case 't': {
                scale = 0x10000000000L;
            }
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    public boolean isInitialized() {
        return this.threadingStack != null;
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    @CompilerDirectives.TruffleBoundary
    protected LLVMManagedPointer getApplicationArguments() {
        String[] result;
        if (this.mainArguments == null) {
            result = new String[]{""};
        } else {
            result = new String[this.mainArguments.length + 1];
            result[0] = "";
            for (int i = 1; i < result.length; ++i) {
                result[i] = this.mainArguments[i - 1].toString();
            }
        }
        return LLVMContext.toManagedObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    protected static LLVMManagedPointer getEnvironmentVariables() {
        String[] result = (String[])System.getenv().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
        return LLVMContext.toManagedObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    protected static LLVMManagedPointer getRandomValues() {
        byte[] result = new byte[16];
        LLVMContext.secureRandom().nextBytes(result);
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer(result));
    }

    private static SecureRandom secureRandom() {
        return new SecureRandom();
    }

    public static LLVMManagedPointer toManagedObjects(String[] values) {
        LLVMArgumentBuffer[] result = new LLVMArgumentBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = new LLVMArgumentBuffer(values[i]);
        }
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer.LLVMArgumentArray(result));
    }

    private static LLVMManagedPointer toManagedPointer(Object value) {
        return LLVMManagedPointer.create(value);
    }

    public void addLibsulongDataLayout(DataLayout datalayout) {
        if (this.datalayoutInitialised.booleanValue()) {
            throw new NullPointerException("The default datalayout cannot be overrwitten");
        }
        this.libsulongDatalayout = datalayout;
        this.datalayoutInitialised = true;
    }

    public DataLayout getLibsulongDataLayout() {
        return this.libsulongDatalayout;
    }

    void finalizeContext(LLVMFunction sulongDisposeContext) {
        this.pThreadContext.joinAllThreads();
        if (this.cleanupNecessary) {
            try {
                if (sulongDisposeContext == null) {
                    throw new IllegalStateException("Context cannot be disposed: __sulong_dispose_context was not found");
                }
                LLVMPointer pointer = this.getSymbol(sulongDisposeContext);
                if (!LLVMManagedPointer.isInstance(pointer)) {
                    throw new IllegalStateException("Context cannot be disposed: __sulong_dispose_context is not a function or enclosed inside a LLVMManagedPointer");
                }
                LLVMFunctionDescriptor functionDescriptor = (LLVMFunctionDescriptor)LLVMManagedPointer.cast(pointer).getObject();
                RootCallTarget disposeContext = functionDescriptor.getFunctionCode().getLLVMIRFunctionSlowPath();
                LLVMStack stack = this.threadingStack.getStack();
                disposeContext.call(new Object[]{stack});
            }
            catch (ControlFlowException | LLVMExitException object) {
                // empty catch block
            }
        }
        if (this.language.getFreeGlobalBlocks() != null) {
            this.language.getFreeGlobalBlocks().call(new Object[0]);
        }
    }

    public Object getFreeReadOnlyGlobalsBlockFunction() {
        if (this.freeGlobalsBlockFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            NativeContextExtension nativeContextExtension = this.getContextExtensionOrNull(NativeContextExtension.class);
            this.freeGlobalsBlockFunction = nativeContextExtension.getNativeFunction("__sulong_free_globals_block", "(POINTER):VOID");
        }
        return this.freeGlobalsBlockFunction;
    }

    public Object getProtectReadOnlyGlobalsBlockFunction() {
        if (this.protectGlobalsBlockFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            NativeContextExtension nativeContextExtension = this.getContextExtensionOrNull(NativeContextExtension.class);
            this.protectGlobalsBlockFunction = nativeContextExtension.getNativeFunction("__sulong_protect_readonly_globals_block", "(POINTER):VOID");
        }
        return this.protectGlobalsBlockFunction;
    }

    public Object getAllocateGlobalsBlockFunction() {
        if (this.allocateGlobalsBlockFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            NativeContextExtension nativeContextExtension = this.getContextExtensionOrNull(NativeContextExtension.class);
            this.allocateGlobalsBlockFunction = nativeContextExtension.getNativeFunction("__sulong_allocate_globals_block", "(UINT64):POINTER");
        }
        return this.allocateGlobalsBlockFunction;
    }

    void dispose(LLVMMemory memory) {
        this.printNativeCallStatistics();
        if (this.isInitialized()) {
            this.threadingStack.freeMainStack(memory);
        }
        for (LLVMPointer pointer : this.symbolsReverseMap.keySet()) {
            Object object;
            if (!LLVMManagedPointer.isInstance(pointer) || !((object = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMGlobalContainer)) continue;
            ((LLVMGlobalContainer)object).dispose();
        }
        if (this.tracer != null) {
            this.tracer.dispose();
        }
        if (this.loaderTraceStream != null) {
            this.loaderTraceStream.dispose();
        }
        if (this.syscallTraceStream != null) {
            this.syscallTraceStream.dispose();
        }
        if (this.nativeCallStatsStream != null) {
            assert (this.nativeCallStatistics != null);
            this.nativeCallStatsStream.dispose();
        }
        if (this.lifetimeAnalysisStream != null) {
            this.lifetimeAnalysisStream.dispose();
        }
    }

    public List<String> preprocessDependencies(List<String> libraries, TruffleFile file) {
        return this.language.getCapability(PlatformCapability.class).preprocessDependencies(this, file, libraries);
    }

    public boolean isInternalLibraryFile(TruffleFile file) {
        return file.normalize().startsWith(this.internalLibraryPathFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TruffleFile getOrAddTruffleFile(TruffleFile file) {
        Object object = this.truffleFilesLock;
        synchronized (object) {
            int index = this.truffleFiles.indexOf(file);
            if (index >= 0) {
                TruffleFile ret = this.truffleFiles.get(index);
                assert (ret.equals((Object)file));
                return ret;
            }
            this.truffleFiles.add(file);
            return file;
        }
    }

    public void addLibraryPaths(List<String> paths) {
        for (String p : paths) {
            this.addLibraryPath(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibraryPath(String p) {
        Path path = Paths.get(p, new String[0]);
        TruffleFile file = this.getEnv().getInternalTruffleFile(path.toString());
        if (file.isDirectory(new LinkOption[0])) {
            Object object = this.libraryPathsLock;
            synchronized (object) {
                if (!this.libraryPaths.contains(path)) {
                    this.libraryPaths.add(path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Path> getLibraryPaths() {
        Object object = this.libraryPathsLock;
        synchronized (object) {
            return this.libraryPaths;
        }
    }

    public boolean isLibraryAlreadyLoaded(int id) {
        return id < this.libraryLoaded.length && this.libraryLoaded[id];
    }

    public void markLibraryLoaded(int id) {
        if (id >= this.libraryLoaded.length) {
            int newLength = id + 1 + (id + 1) / 2;
            boolean[] temp = new boolean[newLength];
            System.arraycopy(this.libraryLoaded, 0, temp, 0, this.libraryLoaded.length);
            this.libraryLoaded = temp;
        }
        this.libraryLoaded[id] = true;
    }

    public LLVMLanguage getLanguage() {
        return this.language;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public LLVMScope getGlobalScope() {
        return this.globalScope;
    }

    public void addLocalScope(LLVMLocalScope scope) {
        this.localScopes.add(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMLocalScope getLocalScope(int id) {
        for (LLVMLocalScope scope : this.localScopes) {
            if (!scope.containID(id)) continue;
            return scope;
        }
        return null;
    }

    public LLVMPointer getSymbol(LLVMSymbol symbol) {
        assert (!symbol.isAlias());
        int bitcodeID = symbol.getBitcodeID(false);
        int index = symbol.getSymbolIndex(false);
        if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant((Object)this)) {
            if (!this.symbolAssumptions[bitcodeID][index].isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.symbolFinalStorage[bitcodeID][index];
        }
        return this.symbolDynamicStorage[bitcodeID][index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void initializeSymbol(LLVMSymbol symbol, LLVMPointer value) {
        assert (!symbol.isAlias());
        int bitcodeID = symbol.getBitcodeID(false);
        LLVMPointer[] symbols = this.symbolDynamicStorage[bitcodeID];
        Assumption[] assumptions = this.symbolAssumptions[bitcodeID];
        LLVMPointer[] lLVMPointerArray = symbols;
        synchronized (symbols) {
            try {
                int index = symbol.getSymbolIndex(false);
                symbols[index] = value;
                assumptions[index] = Truffle.getRuntime().createAssumption();
                if (symbol instanceof LLVMFunction) {
                    ((LLVMFunction)symbol).setValue(value);
                }
            }
            catch (LLVMIllegalSymbolIndexException e) {
                throw new LLVMLinkerException("Writing symbol into symbol table is inconsistent.");
            }
            return;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean checkSymbol(LLVMSymbol symbol) {
        int bitcodeID;
        assert (!symbol.isAlias());
        if (symbol.hasValidIndexAndID() && (bitcodeID = symbol.getBitcodeID(false)) < this.symbolDynamicStorage.length && this.symbolDynamicStorage[bitcodeID] != null) {
            LLVMPointer[] symbols = this.symbolDynamicStorage[bitcodeID];
            int index = symbol.getSymbolIndex(false);
            return symbols[index] != null;
        }
        throw new LLVMLinkerException(String.format("External %s %s cannot be found.", symbol.getKind(), symbol.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSymbol(LLVMSymbol symbol, LLVMPointer value) {
        CompilerAsserts.neverPartOfCompilation();
        LLVMSymbol target = LLVMAlias.resolveAlias(symbol);
        int bitcodeID = target.getBitcodeID(false);
        LLVMPointer[] symbols = this.symbolDynamicStorage[bitcodeID];
        Assumption[] assumptions = this.symbolAssumptions[bitcodeID];
        LLVMPointer[] lLVMPointerArray = symbols;
        synchronized (symbols) {
            try {
                int index = target.getSymbolIndex(false);
                symbols[index] = value;
                assumptions[index].invalidate();
                assumptions[index] = Truffle.getRuntime().createAssumption();
                if (target instanceof LLVMFunction) {
                    ((LLVMFunction)target).setValue(value);
                }
            }
            catch (LLVMIllegalSymbolIndexException e) {
                throw CompilerDirectives.shouldNotReachHere((String)("symbol to be replaced was not found: " + target));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void initializeSymbolTable(int index, int globalLength) {
        LLVMContext lLVMContext = this;
        synchronized (lLVMContext) {
            assert (this.symbolDynamicStorage == this.symbolFinalStorage);
            if (index >= this.symbolDynamicStorage.length) {
                int newLength = index + 1 + (index + 1) / 2;
                this.symbolAssumptions = (Assumption[][])Arrays.copyOf(this.symbolAssumptions, newLength);
                this.symbolDynamicStorage = (LLVMPointer[][])Arrays.copyOf(this.symbolDynamicStorage, newLength);
                this.symbolFinalStorage = this.symbolDynamicStorage;
            }
            if (this.symbolDynamicStorage[index] != null) {
                throw new IllegalStateException("Registering a new symbol table for an existing id. ");
            }
            this.symbolAssumptions[index] = new Assumption[globalLength];
            this.symbolDynamicStorage[index] = new LLVMPointer[globalLength];
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object getThreadLocalStorage() {
        Object value = this.tls.get(Thread.currentThread());
        if (value != null) {
            return value;
        }
        return LLVMNativePointer.createNull();
    }

    @CompilerDirectives.TruffleBoundary
    public void setThreadLocalStorage(Object value) {
        this.tls.put(Thread.currentThread(), value);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor getFunctionDescriptor(LLVMNativePointer handle) {
        return this.functionPointerRegistry.getDescriptor(handle);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor createFunctionDescriptor(LLVMFunction functionDetail, LLVMFunctionCode functionCode) {
        return this.functionPointerRegistry.create(functionDetail, functionCode);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerFunctionPointer(LLVMNativePointer address, LLVMFunctionDescriptor descriptor) {
        this.functionPointerRegistry.register(address, descriptor);
    }

    public LLVMNativePointer getSigDfl() {
        return this.sigDfl;
    }

    public LLVMNativePointer getSigIgn() {
        return this.sigIgn;
    }

    public LLVMNativePointer getSigErr() {
        return this.sigErr;
    }

    public LLVMMemory.HandleContainer getHandleContainer() {
        return this.handleContainer;
    }

    public LLVMMemory.HandleContainer getDerefHandleContainer() {
        return this.derefHandleContainer;
    }

    @CompilerDirectives.TruffleBoundary
    public void registerNativeCall(LLVMFunctionDescriptor descriptor) {
        if (this.nativeCallStatistics != null) {
            String name = descriptor.getLLVMFunction().getName() + " " + descriptor.getLLVMFunction().getType();
            if (this.nativeCallStatistics.containsKey(name)) {
                int count = this.nativeCallStatistics.get(name) + 1;
                this.nativeCallStatistics.put(name, count);
            } else {
                this.nativeCallStatistics.put(name, 1);
            }
        }
    }

    public List<LLVMNativePointer> getCaughtExceptionStack() {
        return this.caughtExceptionStack;
    }

    public LLVMThreadingStack getThreadingStack() {
        assert (this.threadingStack != null);
        return this.threadingStack;
    }

    public void registerDestructorFunctions(RootCallTarget destructor) {
        assert (destructor != null);
        assert (!this.destructorFunctions.contains(destructor));
        this.destructorFunctions.add(destructor);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isScopeLoaded(LLVMScope scope) {
        return this.dynamicLinkChain.containsScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerScope(LLVMScope scope) {
        this.dynamicLinkChain.addScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isScopeLoadedForScopes(LLVMScope scope) {
        return this.dynamicLinkChainForScopes.containsScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerScopeForScopes(LLVMScope scope) {
        this.dynamicLinkChainForScopes.addScope(scope);
    }

    public synchronized void registerThread(LLVMThread thread) {
        assert (!this.runningThreads.contains(thread));
        this.runningThreads.add(thread);
    }

    public synchronized void unregisterThread(LLVMThread thread) {
        this.runningThreads.remove(thread);
        assert (!this.runningThreads.contains(thread));
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void shutdownThreads() {
        for (LLVMThread node : new ArrayList<LLVMThread>(this.runningThreads)) {
            node.stop();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void awaitThreadTermination() {
        this.shutdownThreads();
        while (!this.runningThreads.isEmpty()) {
            LLVMThread node = this.runningThreads.get(0);
            node.awaitFinish();
            assert (!this.runningThreads.contains(node));
        }
    }

    public RootCallTarget[] getDestructorFunctions() {
        return this.destructorFunctions.toArray(new RootCallTarget[this.destructorFunctions.size()]);
    }

    public synchronized List<LLVMThread> getRunningThreads() {
        return Collections.unmodifiableList(this.runningThreads);
    }

    public LLVMSourceContext getSourceContext() {
        return this.sourceContext;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMGlobal findGlobal(LLVMPointer pointer) {
        List<LLVMSymbol> symbols = this.symbolsReverseMap.get(pointer);
        if (symbols == null) {
            return null;
        }
        return symbols.get(0).asGlobalVariable();
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSymbol> findSymbols(LLVMPointer pointer) {
        return this.symbolsReverseMap.get(pointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerReadOnlyGlobals(int id, LLVMPointer nonPointerStore, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.language.initFreeGlobalBlocks(nodeFactory);
            this.globalsReadOnlyStore.put((Object)id, (Object)nonPointerStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getReadOnlyGlobals(int id) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            return (LLVMPointer)this.globalsReadOnlyStore.get((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerGlobals(LLVMPointer nonPointerStore, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.language.initFreeGlobalBlocks(nodeFactory);
            this.globalsNonPointerStore.add(nonPointerStore);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void registerSymbolReverseMap(List<LLVMSymbol> symbols, LLVMPointer pointer) {
        this.symbolsReverseMap.put(pointer, symbols);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerSymbol(LLVMSymbol symbol, LLVMPointer pointer) {
        this.symbolsReverseMap.get(pointer).add(symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSymbol> removeSymbolReverseMap(LLVMPointer pointer) {
        return this.symbolsReverseMap.remove(pointer);
    }

    public void setCleanupNecessary(boolean value) {
        this.cleanupNecessary = value;
    }

    private void printNativeCallStatistics() {
        if (this.nativeCallStatistics != null) {
            LinkedHashMap sorted = this.nativeCallStatistics.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            TargetStream stream = this.nativeCallStatsStream();
            for (String s : sorted.keySet()) {
                stream.printf("Function %s \t count: %d\n", s, sorted.get(s));
            }
        }
    }

    public LLVMPThreadContext getpThreadContext() {
        return this.pThreadContext;
    }

    public TargetStream loaderTraceStream() {
        return this.loaderTraceStream;
    }

    public TargetStream syscallTraceStream() {
        return this.syscallTraceStream;
    }

    public TargetStream nativeCallStatsStream() {
        return this.nativeCallStatsStream;
    }

    public TargetStream lifetimeAnalysisStream() {
        return this.lifetimeAnalysisStream;
    }

    public TargetStream llDebugVerboseStream() {
        return this.llDebugVerboseStream;
    }

    private static class DynamicLinkChain {
        private final ArrayList<LLVMScope> scopes = new ArrayList();

        DynamicLinkChain() {
        }

        private void addScope(LLVMScope newScope) {
            assert (!this.scopes.contains(newScope));
            this.scopes.add(newScope);
        }

        private boolean containsScope(LLVMScope scope) {
            return this.scopes.contains(scope);
        }
    }

    public static final class InternalLibraryLocator
    extends LibraryLocator {
        public static final InternalLibraryLocator INSTANCE = new InternalLibraryLocator();

        @Override
        protected TruffleFile locateLibrary(LLVMContext context, String lib, Object reason) {
            if (context.internalLibraryPath == null) {
                throw new LLVMLinkerException(String.format("Cannot load \"%s\". Internal library path not set", lib));
            }
            TruffleFile absPath = context.internalLibraryPathFile.resolve(lib);
            if (absPath.exists(new LinkOption[0])) {
                return absPath;
            }
            return context.env.getInternalTruffleFile(lib);
        }
    }

    private final class LLVMFunctionPointerRegistry {
        private final HashMap<LLVMNativePointer, LLVMFunctionDescriptor> functionDescriptors = new HashMap();

        private LLVMFunctionPointerRegistry() {
        }

        synchronized LLVMFunctionDescriptor getDescriptor(LLVMNativePointer pointer) {
            return this.functionDescriptors.get(pointer);
        }

        synchronized void register(LLVMNativePointer pointer, LLVMFunctionDescriptor desc) {
            this.functionDescriptors.put(pointer, desc);
        }

        synchronized LLVMFunctionDescriptor create(LLVMFunction functionDetail, LLVMFunctionCode functionCode) {
            return new LLVMFunctionDescriptor(functionDetail, functionCode);
        }
    }
}

