/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.BinaryOperator;
import com.oracle.truffle.llvm.parser.model.enums.Flag;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;

public final class BinaryOperationInstruction
extends ValueInstruction {
    private final BinaryOperator operator;
    private final Flag[] flags;
    private SymbolImpl lhs;
    private SymbolImpl rhs;

    private BinaryOperationInstruction(Type type, BinaryOperator operator, Flag[] flags) {
        super(type);
        this.operator = operator;
        this.flags = flags;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public Flag[] getFlags() {
        return this.flags;
    }

    public SymbolImpl getLHS() {
        return this.lhs;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public SymbolImpl getRHS() {
        return this.rhs;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.lhs == original) {
            this.lhs = replacement;
        }
        if (this.rhs == original) {
            this.rhs = replacement;
        }
    }

    public static BinaryOperationInstruction fromSymbols(SymbolTable symbols, Type type, int opcode, int flags, int lhs, int rhs) {
        boolean isFloatingPoint = Type.isFloatingpointType(type) || type instanceof VectorType && Type.isFloatingpointType(((VectorType)type).getElementType());
        BinaryOperator operator = BinaryOperator.decode(opcode, isFloatingPoint);
        BinaryOperationInstruction inst = new BinaryOperationInstruction(type, operator, Flag.decode(operator, flags));
        inst.lhs = symbols.getForwardReferenced(lhs, inst);
        inst.rhs = symbols.getForwardReferenced(rhs, inst);
        return inst;
    }
}

