/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.parser.factories.BasicPlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallArchPrctlNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallBrkNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallFutexNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallGetcwdNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallMmapNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallRtSigactionNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallRtSigprocmaskNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallSetTidAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMNativeSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallExitNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.linux.amd64.LinuxAMD64Syscall;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_64VaListStorage;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.Type;

final class LinuxAMD64PlatformCapability
extends BasicPlatformCapability<LinuxAMD64Syscall> {
    LinuxAMD64PlatformCapability(boolean loadCxxLibraries) {
        super(LinuxAMD64Syscall.class, loadCxxLibraries);
    }

    @Override
    protected LLVMSyscallOperationNode createSyscallNode(LinuxAMD64Syscall syscall) {
        switch (syscall) {
            case SYS_mmap: {
                return LLVMAMD64SyscallMmapNodeGen.create();
            }
            case SYS_brk: {
                return LLVMAMD64SyscallBrkNodeGen.create();
            }
            case SYS_rt_sigaction: {
                return LLVMAMD64SyscallRtSigactionNodeGen.create();
            }
            case SYS_rt_sigprocmask: {
                return LLVMAMD64SyscallRtSigprocmaskNodeGen.create();
            }
            case SYS_exit: 
            case SYS_exit_group: {
                return new LLVMSyscallExitNode();
            }
            case SYS_getcwd: {
                return LLVMAMD64SyscallGetcwdNodeGen.create();
            }
            case SYS_arch_prctl: {
                return LLVMAMD64SyscallArchPrctlNodeGen.create();
            }
            case SYS_futex: {
                return LLVMAMD64SyscallFutexNodeGen.create();
            }
            case SYS_set_tid_address: {
                return LLVMAMD64SyscallSetTidAddressNodeGen.create();
            }
        }
        return new LLVMNativeSyscallNode(syscall);
    }

    @Override
    public Object createVAListStorage(RootNode rootNode) {
        return new LLVMX86_64VaListStorage(rootNode);
    }

    @Override
    public Type getVAListType() {
        return LLVMX86_64VaListStorage.VA_LIST_TYPE;
    }

    @Override
    public Object createNativeVAListWrapper(LLVMNativePointer vaListPtr, RootNode rootNode) {
        return new LLVMX86_64VaListStorage.NativeVAListWrapper(vaListPtr, rootNode);
    }
}

