/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.parser.factories.BasicPlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMNativeSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallExitNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.linux.aarch64.LinuxAArch64Syscall;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_64VaListStorage;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.Type;

final class LinuxAArch64PlatformCapability
extends BasicPlatformCapability<LinuxAArch64Syscall> {
    LinuxAArch64PlatformCapability(boolean loadCxxLibraries) {
        super(LinuxAArch64Syscall.class, loadCxxLibraries);
    }

    @Override
    protected LLVMSyscallOperationNode createSyscallNode(LinuxAArch64Syscall syscall) {
        switch (syscall) {
            case SYS_exit: 
            case SYS_exit_group: {
                return new LLVMSyscallExitNode();
            }
        }
        return new LLVMNativeSyscallNode(syscall);
    }

    @Override
    public Object createVAListStorage(RootNode rootNode) {
        return new LLVMX86_64VaListStorage(rootNode);
    }

    @Override
    public Type getVAListType() {
        return LLVMX86_64VaListStorage.VA_LIST_TYPE;
    }

    @Override
    public Object createNativeVAListWrapper(LLVMNativePointer vaListPtr, RootNode rootNode) {
        return new LLVMX86_64VaListStorage.NativeVAListWrapper(vaListPtr, rootNode);
    }
}

