/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.LazyToTruffleConverterImpl;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.CastConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalAlias;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.ArrayList;
import java.util.List;

public final class LLVMParser {
    private final Source source;
    private final LLVMParserRuntime runtime;

    public LLVMParser(Source source, LLVMParserRuntime runtime) {
        this.source = source;
        this.runtime = runtime;
    }

    public LLVMParserResult parse(ModelModule module, DataLayout targetDataLayout) {
        ArrayList<GlobalVariable> externalGlobals = new ArrayList<GlobalVariable>();
        ArrayList<GlobalVariable> definedGlobals = new ArrayList<GlobalVariable>();
        ArrayList<FunctionSymbol> externalFunctions = new ArrayList<FunctionSymbol>();
        ArrayList<FunctionSymbol> definedFunctions = new ArrayList<FunctionSymbol>();
        this.defineGlobals(module.getGlobalVariables(), definedGlobals, externalGlobals);
        this.defineFunctions(module, definedFunctions, externalFunctions, targetDataLayout);
        this.defineAliases(module.getAliases());
        return new LLVMParserResult(this.runtime, definedFunctions, externalFunctions, definedGlobals, externalGlobals, targetDataLayout);
    }

    private void defineGlobals(List<GlobalVariable> globals, List<GlobalVariable> definedGlobals, List<GlobalVariable> externalGlobals) {
        for (GlobalVariable global : globals) {
            if (global.isExternal()) {
                externalGlobals.add(global);
                continue;
            }
            this.defineGlobal(global);
            definedGlobals.add(global);
        }
    }

    private void defineFunctions(ModelModule model, List<FunctionSymbol> definedFunctions, List<FunctionSymbol> externalFunctions, DataLayout dataLayout) {
        for (FunctionDefinition functionDefinition : model.getDefinedFunctions()) {
            if (functionDefinition.isExternal()) {
                externalFunctions.add(functionDefinition);
                continue;
            }
            this.defineFunction(functionDefinition, model, dataLayout);
            definedFunctions.add(functionDefinition);
        }
        for (FunctionDeclaration functionDeclaration : model.getDeclaredFunctions()) {
            assert (functionDeclaration.isExternal());
            externalFunctions.add(functionDeclaration);
        }
    }

    private void defineAliases(List<GlobalAlias> aliases) {
        for (GlobalAlias alias : aliases) {
            this.defineAlias(alias);
        }
    }

    private void defineGlobal(GlobalVariable global) {
        assert (!global.isExternal());
        LLVMGlobal globalSymbol = LLVMGlobal.create(global.getName(), global.getType(), global.getSourceSymbol(), global.isReadOnly(), global.getIndex(), this.runtime.getBitcodeID(), global.isExported());
        this.runtime.getFileScope().register(globalSymbol);
    }

    private void defineFunction(FunctionSymbol functionSymbol, ModelModule model, DataLayout dataLayout) {
        assert (!functionSymbol.isExternal());
        FunctionDefinition functionDefinition = (FunctionDefinition)functionSymbol;
        LazyToTruffleConverterImpl lazyConverter = new LazyToTruffleConverterImpl(this.runtime, functionDefinition, this.source, model.getFunctionParser(functionDefinition), model.getFunctionProcessor(), dataLayout);
        LLVMFunctionCode.LazyLLVMIRFunction function = new LLVMFunctionCode.LazyLLVMIRFunction(lazyConverter);
        LLVMFunction llvmFunction = LLVMFunction.create(functionSymbol.getName(), function, functionSymbol.getType(), this.runtime.getBitcodeID(), functionSymbol.getIndex(), functionDefinition.isExported(), this.runtime.getFile().getPath());
        this.runtime.getFileScope().register(llvmFunction);
        boolean cxxInterop = (Boolean)LLVMLanguage.getContext().getEnv().getOptions().get(SulongEngineOption.CXX_INTEROP);
        if (cxxInterop) {
            model.getFunctionParser(functionDefinition).parseLinkageName(this.runtime);
        }
    }

    private void defineAlias(GlobalAlias alias) {
        LLVMSymbol alreadyRegisteredSymbol = this.runtime.getFileScope().get(alias.getName());
        if (alreadyRegisteredSymbol != null) {
            assert (alreadyRegisteredSymbol instanceof LLVMAlias);
            return;
        }
        this.defineAlias(alias.getName(), alias.isExported(), alias.getValue());
    }

    private void defineAlias(String aliasName, boolean isAliasExported, SymbolImpl value) {
        if (value instanceof FunctionSymbol) {
            FunctionSymbol function = (FunctionSymbol)value;
            this.defineAlias(function.getName(), aliasName, isAliasExported);
        } else if (value instanceof GlobalVariable) {
            GlobalVariable global = (GlobalVariable)value;
            this.defineAlias(global.getName(), aliasName, isAliasExported);
        } else if (value instanceof GlobalAlias) {
            GlobalAlias target = (GlobalAlias)value;
            this.defineAlias(target);
            this.defineAlias(target.getName(), aliasName, isAliasExported);
        } else if (value instanceof CastConstant) {
            CastConstant cast = (CastConstant)value;
            this.defineAlias(aliasName, isAliasExported, cast.getValue());
        } else {
            throw new LLVMLinkerException("Unknown alias type: " + value.getClass());
        }
    }

    private void defineAlias(String existingName, String newName, boolean newExported) {
        LLVMSymbol aliasTarget = this.runtime.lookupSymbol(existingName);
        LLVMAlias aliasSymbol = new LLVMAlias(newName, aliasTarget, newExported);
        this.runtime.getFileScope().register(aliasSymbol);
    }
}

