/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.initialization.LoadModulesNode;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;

public final class LoadNativeNode
extends RootNode {
    private final String path;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> ctxRef;

    private LoadNativeNode(FrameDescriptor rootFrame, LLVMLanguage language, TruffleFile file) {
        super((TruffleLanguage)language, rootFrame);
        this.path = file.getPath();
    }

    public static LoadNativeNode create(FrameDescriptor rootFrame, LLVMLanguage language, TruffleFile file) {
        return new LoadNativeNode(rootFrame, language, file);
    }

    public Object execute(VirtualFrame frame) {
        if (this.ctxRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
        }
        if (frame.getArguments().length <= 0 || !(frame.getArguments()[0] instanceof LoadModulesNode.LLVMLoadingPhase)) {
            if (frame.getArguments().length == 0) {
                throw new LLVMParserException((Node)this, "Toplevel executable %s does not contain bitcode", this.path);
            }
            throw new LLVMParserException((Node)this, "LoadNativeNode is called either with unexpected arguments or as a toplevel", new Object[0]);
        }
        LoadModulesNode.LLVMLoadingPhase phase = (LoadModulesNode.LLVMLoadingPhase)((Object)frame.getArguments()[0]);
        if (LoadModulesNode.LLVMLoadingPhase.INIT_SYMBOLS.isActive(phase)) {
            LLVMContext context = (LLVMContext)this.ctxRef.get();
            this.parseAndInitialiseNativeLib(context);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private void parseAndInitialiseNativeLib(LLVMContext context) {
        NativeContextExtension nativeContextExtension = context.getContextExtensionOrNull(NativeContextExtension.class);
        if (nativeContextExtension != null) {
            CallTarget callTarget = nativeContextExtension.parseNativeLibrary(this.path, context);
            nativeContextExtension.addLibraryHandles(callTarget.call(new Object[0]));
        }
    }
}

