/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.initialization.AllocExternalSymbolNode;
import com.oracle.truffle.llvm.initialization.AllocExternalSymbolNodeFactory;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.ArrayList;

public final class InitializeOverwriteNode
extends LLVMNode {
    @Node.Children
    private final AllocExternalSymbolNode[] allocExternalSymbols;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMSymbol[] symbols;

    public InitializeOverwriteNode(LLVMParserResult result) {
        ArrayList<LLVMSymbol> symbolsList = new ArrayList<LLVMSymbol>();
        ArrayList<AllocExternalSymbolNode.AllocExistingLocalSymbolsNode> allocExternaSymbolsList = new ArrayList<AllocExternalSymbolNode.AllocExistingLocalSymbolsNode>();
        LLVMScope fileScope = result.getRuntime().getFileScope();
        for (FunctionSymbol functionSymbol : result.getDefinedFunctions()) {
            if (!functionSymbol.isOverridable()) continue;
            LLVMFunction function = fileScope.getFunction(functionSymbol.getName());
            symbolsList.add(function);
            allocExternaSymbolsList.add(AllocExternalSymbolNodeFactory.AllocExistingLocalSymbolsNodeGen.create(function));
        }
        for (GlobalSymbol globalSymbol : result.getDefinedGlobals()) {
            if (!globalSymbol.isOverridable() || globalSymbol.isIntrinsicGlobalVariable()) continue;
            LLVMGlobal global = fileScope.getGlobalVariable(globalSymbol.getName());
            symbolsList.add(global);
            allocExternaSymbolsList.add(AllocExternalSymbolNodeFactory.AllocExistingLocalSymbolsNodeGen.AllocExistingGlobalSymbolsNodeGen.AllocExternalGlobalNodeGen.create(global));
        }
        this.symbols = symbolsList.toArray(LLVMSymbol.EMPTY);
        this.allocExternalSymbols = allocExternaSymbolsList.toArray(AllocExternalSymbolNode.EMPTY);
    }

    public void execute(LLVMContext context, LLVMLocalScope localScope) {
        LLVMScope globalScope = context.getGlobalScope();
        for (int i = 0; i < this.allocExternalSymbols.length; ++i) {
            AllocExternalSymbolNode allocSymbol = this.allocExternalSymbols[i];
            LLVMPointer pointer = allocSymbol.execute(localScope, globalScope, null, null, context);
            if (pointer == null) continue;
            context.initializeSymbol(this.symbols[i], pointer);
        }
    }
}

