/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.model.CatalogContents;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.remote.FileDownloader;
import org.graalvm.component.installer.remote.MergeStorage;

public class RemoteCatalogDownloader
implements SoftwareChannel {
    private final CommandInput input;
    private final Feedback feedback;
    private Iterable<SoftwareChannel.Factory> factories;
    private List<SoftwareChannelSource> channelSources = new ArrayList<SoftwareChannelSource>();
    private CatalogContents union;
    private String overrideCatalogSpec;
    private String defaultCatalogSpec;
    private boolean catalogURLParsed;
    private boolean remoteSourcesAllowed = true;
    private MergeStorage mergedStorage;
    static final String CAP_CATALOG_URL_SUFFIX = "_url";
    private static final Comparator<String> CHANNEL_KEY_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String k1 = o1.substring("component_catalog_".length());
            String k2 = o2.substring("component_catalog_".length());
            int i1 = Integer.MAX_VALUE;
            int i2 = Integer.MAX_VALUE;
            try {
                i1 = Integer.parseInt(k1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                i2 = Integer.parseInt(k2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (i1 != i2) {
                return i1 - i2;
            }
            return k1.compareToIgnoreCase(k2);
        }
    };

    public RemoteCatalogDownloader(CommandInput in, Feedback out, String overrideCatalogSpec) {
        this.input = in;
        this.feedback = out.withBundle(RemoteCatalogDownloader.class);
        this.overrideCatalogSpec = overrideCatalogSpec;
        this.factories = ServiceLoader.load(SoftwareChannel.Factory.class);
    }

    public RemoteCatalogDownloader(CommandInput in, Feedback out, URL catalogURL) {
        this(in, out, catalogURL == null ? null : catalogURL.toString());
    }

    public void addLocalChannelSource(SoftwareChannelSource src) {
        src.setParameter("reportErrors", Boolean.FALSE.toString());
        this.channelSources.add(src);
    }

    public void setRemoteSourcesAllowed(boolean remoteSourcesAllowed) {
        this.remoteSourcesAllowed = remoteSourcesAllowed;
    }

    public boolean isRemoteSourcesAllowed() {
        return this.remoteSourcesAllowed;
    }

    void setChannels(Iterable<SoftwareChannel.Factory> chan) {
        this.factories = chan;
    }

    public void setDefaultCatalog(String defaultCatalogSpec) {
        this.defaultCatalogSpec = defaultCatalogSpec;
    }

    public String getOverrideCatalogSpec() {
        return this.overrideCatalogSpec;
    }

    List<SoftwareChannelSource> parseChannelSources(String overrideSpec) {
        String[] parts;
        ArrayList<SoftwareChannelSource> sources = new ArrayList<SoftwareChannelSource>();
        if (overrideSpec == null) {
            return sources;
        }
        for (String s : parts = overrideSpec.split("\\|")) {
            try {
                sources.add(new SoftwareChannelSource(s));
            }
            catch (MalformedURLException ex) {
                this.feedback.error("REMOTE_FailedToParseParameter", ex, s);
            }
        }
        return sources;
    }

    List<SoftwareChannelSource> getChannelSources() {
        if (this.catalogURLParsed) {
            return this.channelSources;
        }
        List<Object> sources = Collections.emptyList();
        if (this.remoteSourcesAllowed) {
            if (this.overrideCatalogSpec != null) {
                sources = this.parseChannelSources(this.overrideCatalogSpec);
            } else {
                sources = this.readChannelSources();
                if (sources.isEmpty()) {
                    sources = this.parseChannelSources(this.defaultCatalogSpec);
                }
            }
        }
        this.channelSources.addAll(0, sources);
        this.catalogURLParsed = true;
        return this.channelSources;
    }

    private static Map<String, String> lowercaseMap(Map<String, String> map) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String s : map.keySet()) {
            res.put(s.toLowerCase(Locale.ENGLISH), map.get(s));
        }
        return res;
    }

    List<SoftwareChannelSource> readChannelSources(String pref, Map<String, String> graalCaps) {
        String prefix = pref + "component_catalog_";
        List orderedKeys = graalCaps.keySet().stream().filter(k -> {
            String lk = k.toLowerCase(Locale.ENGLISH);
            return lk.startsWith(prefix) && lk.endsWith(CAP_CATALOG_URL_SUFFIX);
        }).map(k -> k.substring(0, k.length() - CAP_CATALOG_URL_SUFFIX.length())).collect(Collectors.toList());
        Collections.sort(orderedKeys, CHANNEL_KEY_COMPARATOR);
        ArrayList<SoftwareChannelSource> sources = new ArrayList<SoftwareChannelSource>();
        for (String key : orderedKeys) {
            String url = graalCaps.get(key + CAP_CATALOG_URL_SUFFIX);
            String lab = graalCaps.get(key + "_" + "label");
            if (url == null) continue;
            SoftwareChannelSource s = new SoftwareChannelSource(url, lab);
            block8: for (String a : graalCaps.keySet()) {
                String k2;
                if (!a.startsWith(key) || a.length() <= key.length() + 1) continue;
                switch (k2 = a.substring(key.length() + 1).toLowerCase(Locale.ENGLISH)) {
                    case "label": 
                    case "url": {
                        continue block8;
                    }
                }
                s.setParameter(k2, graalCaps.get(a));
            }
            sources.add(s);
        }
        return sources;
    }

    List<SoftwareChannelSource> readChannelSources() {
        Map<String, String> lcEnv = RemoteCatalogDownloader.lowercaseMap(this.input.parameters(false));
        List<SoftwareChannelSource> res = this.readChannelSources("GRAALVM_".toLowerCase(Locale.ENGLISH), lcEnv);
        if (res != null && !res.isEmpty()) {
            return res;
        }
        if (this.remoteSourcesAllowed) {
            return this.readChannelSources("", this.input.getLocalRegistry().getGraalCapabilities());
        }
        return Collections.emptyList();
    }

    private MergeStorage mergeChannels() {
        if (this.mergedStorage != null) {
            return this.mergedStorage;
        }
        this.mergedStorage = new MergeStorage(this.input.getLocalRegistry(), this.feedback);
        this.mergedStorage.setIgnoreCatalogErrors(this.input.hasOption("E"));
        for (SoftwareChannelSource spec : this.getChannelSources()) {
            SoftwareChannel.Factory f;
            SoftwareChannel ch = null;
            Iterator<SoftwareChannel.Factory> iterator = this.factories.iterator();
            while (iterator.hasNext() && (ch = (f = iterator.next()).createChannel(spec, this.input, this.feedback)) == null) {
            }
            if (ch == null) continue;
            this.mergedStorage.addChannel(spec, ch);
        }
        return this.mergedStorage;
    }

    SoftwareChannel delegate(ComponentInfo ci) {
        return this.mergeChannels().getOrigin(ci);
    }

    public ComponentCollection getRegistry() {
        if (this.union == null) {
            this.union = new CatalogContents(this.feedback, this.mergeChannels(), this.input.getLocalRegistry());
            this.union.getComponentIDs();
        }
        return this.union;
    }

    @Override
    public FileDownloader configureDownloader(ComponentInfo cInfo, FileDownloader dn) {
        return this.delegate(cInfo).configureDownloader(cInfo, dn);
    }

    @Override
    public ComponentStorage getStorage() {
        return this.mergeChannels();
    }
}

