/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.component.installer.Version;

public final class ReleaseEntry {
    private final String id;
    private final String label;
    private final Version version;
    private final URL licenseURL;
    private final URL catalogURL;
    private String licenseLabel;
    private String edition;
    private String javaVersion;
    private final List<BasePackage> basePackages = new ArrayList<BasePackage>();

    public ReleaseEntry(String aId, String aLabel, Version aVersion, URL aLicenseURL, URL aCatalogURL) {
        this.id = aId;
        this.label = aLabel;
        this.version = aVersion;
        this.licenseURL = aLicenseURL;
        this.catalogURL = aCatalogURL;
    }

    public String getLicenseLabel() {
        return this.licenseLabel;
    }

    void setLicenseLabel(String licenseLabel) {
        this.licenseLabel = licenseLabel;
    }

    public String getId() {
        return this.id;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    void setJavaVersion(String aJavaVersion) {
        this.javaVersion = aJavaVersion;
    }

    void setEdition(String edition) {
        this.edition = edition;
    }

    public String getLabel() {
        return this.label;
    }

    public Version getVersion() {
        return this.version;
    }

    public URL getLicenseURL() {
        return this.licenseURL;
    }

    public URL getCatalogURL() {
        return this.catalogURL;
    }

    public List<BasePackage> getBasePackages() {
        return Collections.unmodifiableList(this.basePackages);
    }

    public void addBasePackage(BasePackage p) {
        this.basePackages.add(p);
    }

    public String toString() {
        return "Release[" + this.id + ", java=" + this.getJavaVersion() + ", ed=" + this.getEdition() + "]";
    }

    public static class BasePackage {
        private final String os;
        private final String arch;
        private final URL downloadURL;

        public BasePackage(String aOs, String aArch, URL aDonloadURL) {
            this.os = aOs;
            this.arch = aArch;
            this.downloadURL = aDonloadURL;
        }

        public String getOs() {
            return this.os;
        }

        public String getArch() {
            return this.arch;
        }

        public URL getDownloadURL() {
            return this.downloadURL;
        }
    }
}

