/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;

public abstract class QueryCommandBase
implements InstallerCommand {
    protected static final Map<String, String> BASE_OPTIONS = new HashMap<String, String>();
    protected CommandInput input;
    protected ComponentRegistry registry;
    protected ComponentCollection catalog;
    protected Feedback feedback;
    protected boolean verbose;
    protected boolean printTable;
    protected boolean listFiles;
    protected List<ComponentParam> componentParams = new ArrayList<ComponentParam>();
    protected List<ComponentInfo> components = new ArrayList<ComponentInfo>();
    protected boolean simpleFormat;

    @Override
    public Map<String, String> supportedOptions() {
        return BASE_OPTIONS;
    }

    public ComponentRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ComponentRegistry registry) {
        this.registry = registry;
    }

    public Feedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected ComponentCollection initRegistry() {
        this.registry = this.input.getLocalRegistry();
        if (this.input.optValue("c") != null || this.input.optValue("C") != null) {
            return this.input.getRegistry();
        }
        return this.registry;
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        this.input = commandInput;
        this.catalog = this.initRegistry();
        this.feedback = feedBack;
        this.listFiles = commandInput.optValue("l") != null;
        this.verbose = commandInput.optValue("v") != null;
        this.printTable = !this.listFiles && !this.verbose;
        this.processOutputFormat();
    }

    protected void addComponent(ComponentParam param, ComponentInfo info) {
        this.componentParams.add(param);
        this.components.add(info);
    }

    public List<ComponentInfo> getComponents() {
        return this.components;
    }

    protected void printComponents() {
        this.printHeader();
        Iterator<ComponentParam> itpar = this.componentParams.iterator();
        for (ComponentInfo info : this.components) {
            this.printDetails(itpar.next(), info);
            this.printFileList(info);
            this.printSeparator(info);
        }
    }

    void printHeader() {
        if (this.simpleFormat) {
            this.feedback.output("LIST_ComponentShortListHeader_Simple@", new Object[0]);
            return;
        }
        if (this.printTable) {
            this.feedback.output("LIST_ComponentShortListHeader", new Object[0]);
        }
    }

    String val(String s) {
        if (this.simpleFormat) {
            return s == null ? "" : s;
        }
        return s == null ? this.feedback.l10n("LIST_MetadataUnknown", new Object[0]) : s;
    }

    protected String shortenComponentId(ComponentInfo info) {
        return this.registry.shortenComponentId(info);
    }

    void printDetails(ComponentParam param, ComponentInfo info) {
        String org;
        URL u = info.getRemoteURL();
        if (this.simpleFormat) {
            org = u == null ? "" : u.toString();
        } else if (u == null) {
            org = "";
        } else if (u.getProtocol().equals("file")) {
            try {
                org = new File(u.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException ex) {
                org = u.toString();
            }
        } else {
            org = u.getHost();
        }
        if (this.printTable) {
            String fmt = this.simpleFormat ? "LIST_ComponentShortList_Simple@" : "LIST_ComponentShortList";
            String line = String.format(this.feedback.l10n(fmt, new Object[0]), this.shortenComponentId(info), info.getVersion().displayString(), info.getName(), org, info.getId(), info.getStability().displayName(this.feedback));
            this.feedback.verbatimOut(line, false);
        } else {
            String fmt = this.simpleFormat ? "LIST_ComponentBasicInfo_Simple@" : "LIST_ComponentBasicInfo";
            this.feedback.output(fmt, this.shortenComponentId(info), info.getVersion().displayString(), info.getName(), this.findRequiredGraalVMVersion(info), u == null ? "" : u, info.getId(), info.getStability().displayName(this.feedback));
        }
    }

    protected String findRequiredGraalVMVersion(ComponentInfo info) {
        String s = info.getRequiredGraalValues().get("graalvm_version");
        if (s == null) {
            return this.val(s);
        }
        Version v = Version.fromString(s);
        return v.displayString();
    }

    void printFileList(ComponentInfo info) {
        if (!this.listFiles) {
            return;
        }
        ArrayList<String> files = new ArrayList<String>(info.getPaths());
        this.feedback.output(this.simpleFormat ? "LIST_ComponentFilesHeader_Simple@" : "LIST_ComponentFilesHeader", files.size());
        Collections.sort(files);
        for (String s : files) {
            this.feedback.verbatimOut(s, false);
        }
        if (this.simpleFormat) {
            this.feedback.output("LIST_ComponentFilesEnd@", new Object[0]);
        }
    }

    void printSeparator(ComponentInfo info) {
        if (this.simpleFormat || this.printTable) {
            return;
        }
        this.feedback.verbatimOut("", true);
    }

    void processOutputFormat() {
        if (Boolean.TRUE.toString().equals(System.getProperty("org.graalvm.component.installer.SimpleOutput"))) {
            this.simpleFormat = true;
        }
    }

    static {
        BASE_OPTIONS.put("l", "");
        BASE_OPTIONS.put("list-files", "l");
    }
}

