/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.Installer;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ManagementStorage;

public class GraalVMInstaller
extends Installer {
    private static final String SYMLINK_NAME = "active";
    private Path currentInstallPath;
    private boolean disableSymlinks;
    private boolean createSymlink;

    public GraalVMInstaller(Feedback feedback, FileOperations fops, ComponentRegistry current, ComponentInfo componentInfo, ComponentCollection collection, Archive a) {
        super(feedback, fops, componentInfo, new ComponentRegistry(feedback, new TransientStorage(componentInfo.getVersion(), current.getGraalCapabilities(), componentInfo.getProvidedValues())), collection, a);
    }

    public Path getCurrentInstallPath() {
        return this.currentInstallPath;
    }

    public Path getInstalledPath() {
        return this.getInstallPath().resolve(SystemUtils.getGraalVMJDKRoot(this.registry));
    }

    public void setCurrentInstallPath(Path currentInstallPath) {
        this.currentInstallPath = currentInstallPath.normalize();
    }

    public boolean isDisableSymlinks() {
        return this.disableSymlinks;
    }

    public void setDisableSymlinks(boolean disableSymlinks) {
        this.disableSymlinks = disableSymlinks;
    }

    public boolean isCreateSymlink() {
        return this.createSymlink;
    }

    public void setCreateSymlink(boolean createSymlink) {
        this.createSymlink = createSymlink;
    }

    void createSymlink() throws IOException {
        if (Files.getFileStore(this.getInstallPath()).supportsFileAttributeView("isSymbolicLink")) {
            return;
        }
        this.createSymlink(this.findSymlink(this.getInstalledPath().getParent()).orElse(null));
    }

    Path createSymlink(Path linkFile) {
        Path linkTarget;
        Path parent;
        Path path = parent = linkFile == null ? this.getInstallPath().getParent() : linkFile.getParent();
        if (parent == null) {
            return null;
        }
        try {
            linkTarget = parent.relativize(this.getInstallPath());
        }
        catch (IllegalArgumentException ex) {
            linkTarget = this.getInstallPath();
        }
        if (!this.disableSymlinks) {
            if (linkFile != null) {
                boolean create = false;
                try {
                    this.feedback.output("UPGRADE_UpdatingSymlink", linkFile, linkTarget);
                    Files.delete(linkFile);
                    create = true;
                    Files.createSymbolicLink(linkFile, linkTarget, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    this.feedback.error(create ? "UPGRADE_CantCreateNewSymlink" : "UPGRADE_CantDeleteOldSymlink", ex, linkFile, ex.getLocalizedMessage());
                }
            } else if (this.createSymlink) {
                Path linkSource = parent.resolve(SYMLINK_NAME);
                try {
                    this.feedback.output("UPGRADE_CreatingSymlink", linkSource, linkTarget);
                    Files.createSymbolicLink(linkSource, linkTarget, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    this.feedback.error("UPGRADE_CantCreateNewSymlink", ex, linkFile, ex.getLocalizedMessage());
                }
            }
        }
        return linkFile;
    }

    Optional<Path> findSymlink(Path parentPath) throws IOException {
        return Files.list(parentPath).filter(p -> {
            if (!Files.isSymbolicLink(p)) {
                return false;
            }
            try {
                Path target = Files.readSymbolicLink(p);
                return Files.isSameFile(p.resolveSibling(target), this.currentInstallPath);
            }
            catch (IOException ex) {
                return false;
            }
        }).findAny();
    }

    Path existingSymlink() throws IOException {
        Path parentPath = this.getInstallPath().getParent();
        Optional<Path> existingLink = this.findSymlink(parentPath);
        if (!existingLink.isPresent()) {
            existingLink = this.findSymlink(this.getInstallPath().toRealPath(new LinkOption[0]).getParent());
        }
        return existingLink.orElse(null);
    }

    @Override
    void installContent() throws IOException {
        Path registryPath = this.getInstalledPath().resolve(SystemUtils.fromCommonRelative("lib/installer/components"));
        Files.createDirectories(registryPath, new FileAttribute[0]);
        super.installContent();
    }

    static class TransientStorage
    implements ManagementStorage {
        private final Map<String, String> graalCaps = new HashMap<String, String>();

        TransientStorage(Version newGraalVersion, Map<String, String> graalCaps, Map<String, Object> newCaps) {
            this.graalCaps.putAll(graalCaps);
            graalCaps.put("graalvm_version", newGraalVersion.toString());
            for (String s : newCaps.keySet()) {
                graalCaps.put(s, newCaps.get(s).toString());
            }
        }

        @Override
        public void deleteComponent(String id) throws IOException {
        }

        @Override
        public Set<String> listComponentIDs() throws IOException {
            return Collections.emptySet();
        }

        @Override
        public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
            return ci;
        }

        @Override
        public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
            return null;
        }

        @Override
        public Map<String, String> loadGraalVersionInfo() {
            return Collections.unmodifiableMap(this.graalCaps);
        }

        @Override
        public Map<String, Collection<String>> readReplacedFiles() throws IOException {
            return Collections.emptyMap();
        }

        @Override
        public void saveComponent(ComponentInfo info) throws IOException {
        }

        @Override
        public void updateReplacedFiles(Map<String, Collection<String>> replacedFiles) throws IOException {
        }

        @Override
        public Date licenseAccepted(ComponentInfo info, String licenseID) {
            return null;
        }

        @Override
        public void recordLicenseAccepted(ComponentInfo info, String licenseID, String licenseText, Date d) throws IOException {
        }

        @Override
        public Map<String, Collection<String>> findAcceptedLicenses() {
            return Collections.emptyMap();
        }

        @Override
        public String licenseText(String licID) {
            return "";
        }
    }
}

