/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectArrayItemNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.LocalDynamicObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptType;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleLocalObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectArrayItemNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleOpenNodeActionProvider;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleTypeNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.ui.Formatters;

public class JavaScriptNodes
extends TruffleOpenNodeActionProvider<JavaScriptObject, JavaScriptType, JavaScriptHeapFragment, JavaScriptLanguage> {
    private static final int MAX_LOGVALUE_LENGTH = 160;

    public boolean supportsView(HeapContext context, String viewID) {
        return JavaScriptHeapFragment.isJavaScriptHeap(context);
    }

    @Override
    protected boolean supportsNode(HeapViewerNode node) {
        return node instanceof JavaScriptNode;
    }

    @Override
    protected JavaScriptLanguage getLanguage() {
        return JavaScriptLanguage.instance();
    }

    static String getLogicalValue(JavaScriptObject object, String type, Heap heap) {
        String logicalValue = null;
        if ("Function".equals(type) || "JSFunction".equals(type)) {
            FieldValue dataField = object.getFieldValue("functionData (hidden)");
            Instance data = dataField instanceof ObjectFieldValue ? ((ObjectFieldValue)dataField).getInstance() : null;
            String string = logicalValue = data == null ? null : DetailsSupport.getDetailsString((Instance)data, (Heap)heap);
            logicalValue = logicalValue != null ? logicalValue + "()" : DetailsSupport.getDetailsString((Instance)object.getInstance(), (Heap)heap);
        } else if ("JavaPackage".equals(type)) {
            FieldValue nameField = object.getFieldValue("packageName (hidden)");
            Instance name = nameField instanceof ObjectFieldValue ? ((ObjectFieldValue)nameField).getInstance() : null;
            String string = logicalValue = name == null ? null : DetailsSupport.getDetailsString((Instance)name, (Heap)heap);
            if (logicalValue == null) {
                logicalValue = DetailsSupport.getDetailsString((Instance)object.getInstance(), (Heap)heap);
            }
        } else if ("Object".equals(type) || "JSObject".equals(type)) {
            String head = "properties [";
            String sep = ", ";
            StringBuilder sb = new StringBuilder();
            sb.append(head);
            List<FieldValue> fields = object.getFieldValues();
            for (FieldValue field : fields) {
                String name = field.getField().getName();
                if (name.contains("(hidden)")) continue;
                sb.append(name).append(sep);
            }
            int length = sb.length();
            if (length > head.length()) {
                sb.delete(length - sep.length(), length);
            }
            sb.append("]");
            logicalValue = sb.toString();
        } else if ("Array".equals(type) || "JSArray".equals(type)) {
            Integer length;
            FieldValue lengthField = object.getFieldValue("length (hidden)");
            if (lengthField == null) {
                lengthField = object.getFieldValue("usedLength (hidden)");
            }
            if ((length = lengthField != null ? Integer.valueOf(Integer.parseInt(lengthField.getValue())) : (Integer)object.getInstance().getValueOfField("length")) != null) {
                logicalValue = Formatters.numberFormat().format(length) + (length == 1 ? " item" : " items");
            }
        } else if ("Null$NullClass".equals(type)) {
            logicalValue = DetailsSupport.getDetailsString((Instance)object.getInstance(), (Heap)heap);
        } else if ("Date".equals(type) || "JSDate".equals(type)) {
            FieldValue timeField = object.getFieldValue("timeMillis (hidden)");
            if (timeField != null) {
                double time = Double.parseDouble(timeField.getValue());
                logicalValue = new Date((long)time).toString();
            }
        } else if ("JSBoolean".equals(type) || "JSNumber".equals(type)) {
            FieldValue valueField = object.getFieldValue("value (hidden)");
            if (valueField != null) {
                if (valueField instanceof ObjectFieldValue) {
                    Instance val = ((ObjectFieldValue)valueField).getInstance();
                    logicalValue = DetailsSupport.getDetailsString((Instance)val, (Heap)heap);
                } else {
                    logicalValue = valueField.getValue();
                }
            }
        } else if ("String".equals(type) || "JSString".equals(type)) {
            FieldValue stringField = object.getFieldValue("string (hidden)");
            if (stringField instanceof ObjectFieldValue) {
                Instance val = ((ObjectFieldValue)stringField).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)val, (Heap)heap);
            }
        } else if ("Error".equals(type)) {
            FieldValue valueField = object.getFieldValue("name");
            if (valueField != null) {
                if (valueField instanceof ObjectFieldValue) {
                    Instance val = ((ObjectFieldValue)valueField).getInstance();
                    logicalValue = DetailsSupport.getDetailsString((Instance)val, (Heap)heap);
                } else {
                    logicalValue = valueField.getValue();
                }
            }
        } else {
            String rawType = DynamicObject.getType(object.getInstance(), heap);
            if (!Objects.equals(type, rawType)) {
                return JavaScriptNodes.getLogicalValue(object, rawType, heap);
            }
        }
        if (logicalValue != null && logicalValue.length() > 160) {
            logicalValue = logicalValue.substring(0, 160) + "...";
        }
        return logicalValue;
    }

    private static String computeObjectName(TruffleObjectNode.InstanceBased<JavaScriptObject> node, Heap heap) {
        return ((JavaScriptObject)node.getTruffleObject()).computeDisplayType(heap) + "#" + node.getInstance().getInstanceNumber();
    }

    private static JavaScriptObjectNode createCopy(TruffleObjectNode.InstanceBased<JavaScriptObject> node) {
        return new JavaScriptObjectNode((JavaScriptObject)node.getTruffleObject(), node.getTypeName());
    }

    public static class JavaScriptNodesRendererProvider
    extends HeapViewerRenderer.Provider {
        public boolean supportsView(HeapContext context, String viewID) {
            return true;
        }

        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            JavaScriptLanguage language = JavaScriptLanguage.instance();
            Icon instanceIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Instance"));
            Icon packageIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Package"));
            Heap heap = context.getFragment().getHeap();
            renderers.put(JavaScriptObjectNode.class, new TruffleObjectNode.Renderer(heap, instanceIcon));
            renderers.put(JavaScriptTypeNode.class, new TruffleTypeNode.Renderer(packageIcon));
            renderers.put(JavaScriptObjectFieldNode.class, new TruffleObjectFieldNode.Renderer(heap, instanceIcon));
            renderers.put(JavaScriptObjectArrayItemNode.class, new TruffleObjectArrayItemNode.Renderer(heap, instanceIcon));
            renderers.put(JavaScriptObjectReferenceNode.class, new TruffleObjectReferenceNode.Renderer(heap, instanceIcon));
            renderers.put(JavaScriptLocalObjectNode.class, new TruffleLocalObjectNode.Renderer(heap, instanceIcon));
        }
    }

    static class JavaScriptLocalObjectNode
    extends LocalDynamicObjectNode<JavaScriptObject>
    implements JavaScriptNode {
        JavaScriptLocalObjectNode(JavaScriptObject object, String type) {
            super(object, type);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return JavaScriptNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(JavaScriptObject object, String type, Heap heap) {
            String logicalValue = JavaScriptNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public JavaScriptObjectNode createCopy() {
            return JavaScriptNodes.createCopy(this);
        }
    }

    static class JavaScriptObjectReferenceNode
    extends DynamicObjectReferenceNode<JavaScriptObject>
    implements JavaScriptNode {
        JavaScriptObjectReferenceNode(JavaScriptObject object, String type, FieldValue value) {
            super(object, type, value);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return JavaScriptNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(JavaScriptObject object, String type, Heap heap) {
            String logicalValue = JavaScriptNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public JavaScriptObjectNode createCopy() {
            return JavaScriptNodes.createCopy(this);
        }
    }

    static class JavaScriptObjectArrayItemNode
    extends DynamicObjectArrayItemNode<JavaScriptObject>
    implements JavaScriptNode {
        JavaScriptObjectArrayItemNode(JavaScriptObject object, String type, ArrayItemValue item) {
            super(object, type, item);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return JavaScriptNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(JavaScriptObject object, String type, Heap heap) {
            String logicalValue = JavaScriptNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public JavaScriptObjectNode createCopy() {
            return JavaScriptNodes.createCopy(this);
        }
    }

    static class JavaScriptObjectFieldNode
    extends DynamicObjectFieldNode<JavaScriptObject>
    implements JavaScriptNode {
        JavaScriptObjectFieldNode(JavaScriptObject object, String type, FieldValue field) {
            super(object, type, field);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return JavaScriptNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(JavaScriptObject object, String type, Heap heap) {
            String logicalValue = JavaScriptNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public JavaScriptObjectNode createCopy() {
            return JavaScriptNodes.createCopy(this);
        }
    }

    static class JavaScriptTypeNode
    extends TruffleTypeNode<JavaScriptObject, JavaScriptType>
    implements JavaScriptNode {
        JavaScriptTypeNode(JavaScriptType type) {
            super(type);
        }

        @Override
        public HeapViewerNode createNode(JavaScriptObject object, Heap heap) {
            String type = ((JavaScriptType)this.getType()).getName();
            return !type.startsWith("<") ? new JavaScriptObjectNode(object, type) : new JavaScriptObjectNode(object, object.getType(heap));
        }

        @Override
        public TruffleTypeNode createCopy() {
            JavaScriptTypeNode copy = new JavaScriptTypeNode((JavaScriptType)this.getType());
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(JavaScriptTypeNode copy) {
            super.setupCopy(copy);
        }
    }

    static class JavaScriptObjectNode
    extends DynamicObjectNode<JavaScriptObject>
    implements JavaScriptNode {
        JavaScriptObjectNode(JavaScriptObject object, String type) {
            super(object, type);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return JavaScriptNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(JavaScriptObject object, String type, Heap heap) {
            String logicalValue = JavaScriptNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        public JavaScriptObjectNode createCopy() {
            JavaScriptObjectNode copy = JavaScriptNodes.createCopy(this);
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(JavaScriptObjectNode copy) {
            super.setupCopy(copy);
        }
    }

    static interface JavaScriptNode {
    }
}

