/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import javax.management.DynamicMBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.management.AggregatedMemoryPoolBean;
import org.graalvm.compiler.hotspot.management.Factory;
import org.graalvm.compiler.hotspot.management.JMXFromLibGraalEntryPoints;
import org.graalvm.compiler.hotspot.management.JMXToLibGraalCalls;
import org.graalvm.compiler.hotspot.management.LibGraalMBean;
import org.graalvm.compiler.hotspot.management.libgraal.LibGraalMemoryPoolMBean;
import org.graalvm.compiler.hotspot.management.libgraal.MBeanProxyGen;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIExceptionWrapper;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class MBeanProxy<T extends DynamicMBean> {
    private static final Method getCurrentJavaThreadMethod;
    private static final ClassData HS_BEAN_CLASS;
    private static final ClassData HS_BEAN_FACTORY_CLASS;
    private static final ClassData HS_CALLS_CLASS;
    private static final ClassData HS_PUSHBACK_ITER_CLASS;
    private static final ClassData HS_ENTRYPOINTS_CLASS;
    private static final ClassData HS_AGGREGATED_MEMORY_POOL_BEAN_CLASS;
    private static Queue<MBeanProxy<?>> registrations;
    private static JNI.JClass fromLibGraalEntryPoints;
    private static volatile long jniEnvOffset;
    private static LibGraalMemoryPoolMBean memPoolBean;
    private static State state;
    private T bean;
    private String name;
    private ObjectName objName;
    private volatile boolean needsRegistration = true;

    MBeanProxy() {
    }

    MBeanProxy(T mbean, String strName) throws MalformedObjectNameException {
        this.initialize(mbean, strName, new ObjectName(strName));
    }

    void initialize(T mbean, String strName, ObjectName objectName) {
        Objects.requireNonNull(mbean);
        Objects.requireNonNull(strName);
        Objects.requireNonNull(objectName);
        if (this.bean != null) {
            throw new IllegalStateException("Already initialized.");
        }
        assert (this.name == null);
        assert (this.objName == null);
        this.bean = mbean;
        this.name = strName;
        this.objName = objectName;
    }

    T getBean() {
        return this.bean;
    }

    void finishRegistration() {
        this.needsRegistration = false;
    }

    String getName() {
        return this.name;
    }

    ObjectName poll() {
        LibGraalMemoryPoolMBean memPool = memPoolBean;
        if (memPool != null) {
            memPool.update();
        }
        if (this.bean == null || this.needsRegistration) {
            return null;
        }
        return this.objName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean initializeJNI(GraalHotSpotVMConfig config) {
        if (getCurrentJavaThreadMethod == null) {
            return false;
        }
        if (jniEnvOffset != 0L) return true;
        Class<MBeanProxy> clazz = MBeanProxy.class;
        synchronized (MBeanProxy.class) {
            if (jniEnvOffset != 0L) return true;
            if (config.jniEnvironmentOffset == Integer.MIN_VALUE) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            memPoolBean = new LibGraalMemoryPoolMBean();
            jniEnvOffset = config.jniEnvironmentOffset;
            MBeanProxy.defineClassesInHotSpot(MBeanProxy.getCurrentJNIEnv());
            try {
                MBeanProxy<LibGraalMemoryPoolMBean> memPoolMBean = new MBeanProxy<LibGraalMemoryPoolMBean>(memPoolBean, memPoolBean.getObjectId());
                MBeanProxy.enqueueForRegistration(memPoolMBean);
            }
            catch (MalformedObjectNameException mon) {
                throw new AssertionError("Invlid object name.", mon);
            }
            return true;
        }
    }

    static JNI.JClass getHotSpotEntryPoints() {
        return fromLibGraalEntryPoints;
    }

    static JNI.JNIEnv getCurrentJNIEnv() {
        if (jniEnvOffset == 0L) {
            throw new IllegalStateException("JniEnvOffset is not yet initialized.");
        }
        if (getCurrentJavaThreadMethod == null) {
            throw new IllegalStateException("CurrentJavaThread not supported by JVMCI.");
        }
        try {
            long currentJavaThreadAddr = (Long)getCurrentJavaThreadMethod.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[0]);
            return (JNI.JNIEnv)WordFactory.pointer((long)(currentJavaThreadAddr + jniEnvOffset));
        }
        catch (ReflectiveOperationException reflectiveException) {
            throw new RuntimeException("Failed to invoke HotSpotJVMCIRuntime::getCurrentJavaThread", reflectiveException);
        }
    }

    static synchronized List<MBeanProxy<?>> drainRegistrations() {
        if (state != State.ACTIVE || registrations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList res = new ArrayList(registrations);
        registrations.clear();
        return res;
    }

    static <T extends MBeanProxy<?>> T enqueueForRegistrationAndNotify(T instance, HotSpotGraalRuntime runtime) {
        T res = MBeanProxy.enqueueForRegistration(instance);
        if (res != null) {
            MBeanProxy.signalRegistrationRequest(runtime);
        }
        return res;
    }

    static String nameWithIsolateId(String name) {
        long id = IsolateUtil.getIsolateID();
        return id == 0L ? name : name + ",isolate=" + id;
    }

    private static synchronized <T extends MBeanProxy<?>> T enqueueForRegistration(T instance) {
        if (state == State.CLOSED) {
            return null;
        }
        registrations.add(instance);
        return instance;
    }

    private static synchronized void updateStateToActive(HotSpotGraalRuntime runtime) {
        if (state == State.INIT) {
            state = State.ACTIVE;
            runtime.addShutdownHook((Runnable)new OnShutDown());
        }
    }

    private static void defineClassesInHotSpot(JNI.JNIEnv env) {
        Pointer barrier = MBeanProxy.getDefineClassesStatePointer();
        JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader((JNI.JNIEnv)env);
        Runnable defineAction = () -> {
            MBeanProxy.defineClassInHotSpot(env, classLoader, HS_CALLS_CLASS);
            long entryPoints = MBeanProxy.defineClassInHotSpot(env, classLoader, HS_ENTRYPOINTS_CLASS).rawValue();
            MBeanProxy.defineClassInHotSpot(env, classLoader, HS_BEAN_CLASS);
            MBeanProxy.defineClassInHotSpot(env, classLoader, HS_BEAN_FACTORY_CLASS);
            MBeanProxy.defineClassInHotSpot(env, classLoader, HS_PUSHBACK_ITER_CLASS);
            MBeanProxy.defineClassInHotSpot(env, classLoader, HS_AGGREGATED_MEMORY_POOL_BEAN_CLASS);
            fromLibGraalEntryPoints = (JNI.JClass)JNIUtil.NewGlobalRef((JNI.JNIEnv)env, (JNI.JObject)((JNI.JClass)WordFactory.pointer((long)entryPoints)), (String)("Class<" + MBeanProxy.HS_ENTRYPOINTS_CLASS.binaryName + ">"));
        };
        Runnable loadAction = () -> {
            long entryPoints = JNIUtil.findClass((JNI.JNIEnv)env, (JNI.JObject)classLoader, (String)MBeanProxy.HS_ENTRYPOINTS_CLASS.binaryName, (boolean)true).rawValue();
            fromLibGraalEntryPoints = (JNI.JClass)JNIUtil.NewGlobalRef((JNI.JNIEnv)env, (JNI.JObject)((JNI.JClass)WordFactory.pointer((long)entryPoints)), (String)("Class<" + MBeanProxy.HS_ENTRYPOINTS_CLASS.binaryName + ">"));
        };
        MBeanProxy.runGuarded(barrier, defineAction, loadAction);
    }

    private static void runGuarded(Pointer barrier, Runnable defineAction, Runnable loadAction) {
        if (barrier.isNull()) {
            throw new IllegalStateException("Missing substitution for MBeanProxy.defineClassesInHotSpot");
        }
        long undefined = 0L;
        long defining = 1L;
        long defined = 2L;
        long defineClassState = barrier.readLong(0);
        if (defineClassState == 2L) {
            loadAction.run();
        } else {
            while (true) {
                if ((defineClassState = barrier.readLong(0)) == 0L) {
                    if (barrier.compareAndSwapLong(0, 0L, 1L, LocationIdentity.ANY_LOCATION) != 0L) continue;
                    defineAction.run();
                    barrier.writeLong(0, 2L);
                    break;
                }
                if (defineClassState == 2L) {
                    loadAction.run();
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * Loose catch block
     */
    private static JNI.JClass defineClassInHotSpot(JNI.JNIEnv env, JNI.JObject classLoader, ClassData classData) {
        JNI.JClass jClass;
        CTypeConversion.CCharPointerHolder className;
        CCharPointer classDataPointer;
        block8: {
            JNI.JClass definedClass;
            classDataPointer = (CCharPointer)UnmanagedMemory.malloc((int)classData.byteCode.length);
            ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)classDataPointer, (int)classData.byteCode.length);
            buffer.put(classData.byteCode);
            className = CTypeConversion.toCString((CharSequence)classData.binaryName);
            jClass = definedClass = JNIUtil.DefineClass((JNI.JNIEnv)env, (CCharPointer)className.get(), (JNI.JObject)classLoader, (CCharPointer)classDataPointer, (int)classData.byteCode.length);
            if (className == null) break block8;
            className.close();
        }
        UnmanagedMemory.free((PointerBase)classDataPointer);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[]{LinkageError.class});
        return jClass;
        {
            catch (Throwable throwable) {
                try {
                    if (className != null) {
                        try {
                            className.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    UnmanagedMemory.free((PointerBase)classDataPointer);
                    JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[]{LinkageError.class});
                    throw throwable3;
                }
            }
        }
    }

    private static JNI.JObject getFactory(JNI.JNIEnv env) {
        return MBeanProxyGen.callGetFactory(env);
    }

    private static void signalRegistrationRequest(HotSpotGraalRuntime runtime) {
        JNI.JNIEnv env = MBeanProxy.getCurrentJNIEnv();
        JNI.JObject factory = MBeanProxy.getFactory(env);
        MBeanProxy.updateStateToActive(runtime);
        MBeanProxyGen.callSignalRegistrationRequest(env, factory, CurrentIsolate.getIsolate().rawValue());
    }

    private static void unregister() {
        JNI.JNIEnv env = MBeanProxy.getCurrentJNIEnv();
        JNI.JObject factory = MBeanProxy.getFactory(env);
        MBeanProxyGen.callUnregister(env, factory, CurrentIsolate.getIsolate().rawValue());
    }

    private static Pointer getDefineClassesStatePointer() {
        return (Pointer)WordFactory.nullPointer();
    }

    static /* synthetic */ State access$100() {
        return state;
    }

    static /* synthetic */ State access$102(State x0) {
        state = x0;
        return state;
    }

    static /* synthetic */ void access$200() {
        MBeanProxy.unregister();
    }

    static {
        Method m;
        try {
            m = HotSpotJVMCIRuntime.class.getMethod("getCurrentJavaThread", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        getCurrentJavaThreadMethod = m;
        HS_BEAN_CLASS = ClassData.create(LibGraalMBean.class);
        HS_BEAN_FACTORY_CLASS = ClassData.create(Factory.class);
        HS_CALLS_CLASS = ClassData.create(JMXToLibGraalCalls.class);
        HS_PUSHBACK_ITER_CLASS = ClassData.create(LibGraalMBean.PushBackIterator.class);
        HS_ENTRYPOINTS_CLASS = ClassData.create(JMXFromLibGraalEntryPoints.class);
        HS_AGGREGATED_MEMORY_POOL_BEAN_CLASS = ClassData.create(AggregatedMemoryPoolBean.class);
        registrations = new ArrayDeque();
        state = State.INIT;
    }

    private static final class ClassData {
        final String binaryName;
        final byte[] byteCode;

        private ClassData(String binaryName, byte[] byteCode) {
            this.binaryName = binaryName;
            this.byteCode = byteCode;
        }

        static ClassData create(Class<?> clz) {
            ClassData classData;
            String binaryName = JNIUtil.getBinaryName((String)clz.getName());
            DataInputStream in = new DataInputStream(clz.getResourceAsStream('/' + binaryName + ".class"));
            try {
                byte[] buffer = new byte[in.available()];
                in.readFully(buffer);
                classData = new ClassData(binaryName, buffer);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new InternalError("Error loading class file for %s: " + clz.getName(), ioe);
                }
            }
            in.close();
            return classData;
        }
    }

    private static final class OnShutDown
    implements Runnable {
        private OnShutDown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<MBeanProxy> clazz = MBeanProxy.class;
            synchronized (MBeanProxy.class) {
                State prevState = state;
                state = State.CLOSED;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                if (prevState == State.ACTIVE) {
                    MBeanProxy.unregister();
                }
                return;
            }
        }
    }

    private static enum State {
        INIT,
        ACTIVE,
        CLOSED;

    }
}

