/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFIBackendLibrary.class)
final class NFIBackendLibraryGen
extends LibraryFactory<NFIBackendLibrary> {
    private static final Class<NFIBackendLibrary> LIBRARY_CLASS = NFIBackendLibraryGen.lazyLibraryClass();
    private static final Message GET_SIMPLE_TYPE = new MessageImpl("getSimpleType", 0, Object.class, Object.class, NativeSimpleType.class);
    private static final Message GET_ARRAY_TYPE = new MessageImpl("getArrayType", 1, Object.class, Object.class, NativeSimpleType.class);
    private static final Message GET_ENV_TYPE = new MessageImpl("getEnvType", 2, Object.class, Object.class);
    private static final Message CREATE_SIGNATURE_BUILDER = new MessageImpl("createSignatureBuilder", 3, Object.class, Object.class);
    private static final NFIBackendLibraryGen INSTANCE = new NFIBackendLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NFIBackendLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(GET_SIMPLE_TYPE, GET_ARRAY_TYPE, GET_ENV_TYPE, CREATE_SIGNATURE_BUILDER)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NFIBackendLibrary.class;
    }

    protected NFIBackendLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected NFIBackendLibrary createDelegate(NFIBackendLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NFIBackendLibrary lib = (NFIBackendLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.getSimpleType(receiver, (NativeSimpleType)((Object)args[offset]));
            }
            case 1: {
                return lib.getArrayType(receiver, (NativeSimpleType)((Object)args[offset]));
            }
            case 2: {
                return lib.getEnvType(receiver);
            }
            case 3: {
                return lib.createSignatureBuilder(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected NFIBackendLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NFIBackendLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NFIBackendLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.spi.NFIBackendLibrary", false, NFIBackendLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static abstract class CachedDispatch
    extends NFIBackendLibrary {
        @Node.Child
        NFIBackendLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NFIBackendLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getSimpleType(receiver_, type);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getArrayType(receiver_, type);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getEnvType(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getEnvType(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object createSignatureBuilder(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createSignatureBuilder(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            NFIBackendLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (NFIBackendLibrary)this.insert((Node)((NFIBackendLibrary)INSTANCE.create(receiver_)));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NFIBackendLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NFIBackendLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NFIBackendLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(NFIBackendLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NFIBackendLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static final class UncachedDispatch
    extends NFIBackendLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            return ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).getSimpleType(receiver_, type);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            return ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).getArrayType(receiver_, type);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getEnvType(Object receiver_) {
            return ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).getEnvType(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createSignatureBuilder(Object receiver_) {
            return ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).createSignatureBuilder(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NFIBackendLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).getSimpleType(receiver_, type);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).getArrayType(receiver_, type);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getEnvType(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).getEnvType(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createSignatureBuilder(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFIBackendLibrary)INSTANCE.getUncached(receiver_)).createSignatureBuilder(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static final class Delegate
    extends NFIBackendLibrary {
        @Node.Child
        private NFIBackendLibrary delegateLibrary;

        Delegate(NFIBackendLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            if (NFIBackendLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = NFIBackendLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFIBackendLibrary)NFIBackendLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getSimpleType(delegate, type);
            }
            return this.delegateLibrary.getSimpleType(receiver_, type);
        }

        @Override
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            if (NFIBackendLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = NFIBackendLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFIBackendLibrary)NFIBackendLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getArrayType(delegate, type);
            }
            return this.delegateLibrary.getArrayType(receiver_, type);
        }

        @Override
        public Object getEnvType(Object receiver_) {
            if (NFIBackendLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = NFIBackendLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFIBackendLibrary)NFIBackendLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getEnvType(delegate);
            }
            return this.delegateLibrary.getEnvType(receiver_);
        }

        @Override
        public Object createSignatureBuilder(Object receiver_) {
            if (NFIBackendLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = NFIBackendLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFIBackendLibrary)NFIBackendLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createSignatureBuilder(delegate);
            }
            return this.delegateLibrary.createSignatureBuilder(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static final class Proxy
    extends NFIBackendLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            try {
                return this.lib.send(receiver_, GET_SIMPLE_TYPE, new Object[]{type});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            try {
                return this.lib.send(receiver_, GET_ARRAY_TYPE, new Object[]{type});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getEnvType(Object receiver_) {
            try {
                return this.lib.send(receiver_, GET_ENV_TYPE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object createSignatureBuilder(Object receiver_) {
            try {
                return this.lib.send(receiver_, CREATE_SIGNATURE_BUILDER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=NFIBackendLibrary.class)
    private static final class Default
    extends LibraryExport<NFIBackendLibrary> {
        private Default() {
            super(NFIBackendLibrary.class, Object.class, false);
        }

        protected NFIBackendLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NFIBackendLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFIBackendLibrary.class)
        private static final class Uncached
        extends NFIBackendLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getEnvType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createSignatureBuilder(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=NFIBackendLibrary.class)
        private static final class Cached
        extends NFIBackendLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getEnvType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createSignatureBuilder(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }
}

