/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.LibFFIClosure;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeAllocation;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativePointer;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureBuilderLibrary;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.util.ProfiledArrayBuilder;

@ExportLibrary(value=NFIBackendSignatureLibrary.class)
final class LibFFISignature {
    private final long cif;
    final CachedSignatureInfo signatureInfo;

    @CompilerDirectives.TruffleBoundary
    public static LibFFISignature create(NFIContext context, CachedSignatureInfo info, LibFFIType retType, int argCount, int fixedArgCount, LibFFIType[] argTypes) {
        LibFFIType realRetType = retType;
        if (retType == null) {
            realRetType = context.lookupSimpleType(NativeSimpleType.VOID);
        }
        long cif = fixedArgCount == -1 ? context.prepareSignature(realRetType, argCount, argTypes) : context.prepareSignatureVarargs(realRetType, argCount, fixedArgCount, argTypes);
        return LibFFISignature.create(cif, info);
    }

    private static LibFFISignature create(long cif, CachedSignatureInfo info) {
        LibFFISignature ret = new LibFFISignature(cif, info);
        NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, new NativeAllocation.FreeDestructor(cif));
        return ret;
    }

    @ExportMessage(limit="3")
    Object call(Object functionPointer, Object[] args, @CachedLibrary(value="functionPointer") InteropLibrary interop, @Cached BranchProfile toNative, @Cached BranchProfile error, @Cached FunctionExecuteNode functionExecute) throws ArityException, UnsupportedTypeException {
        long pointer;
        if (!interop.isPointer(functionPointer)) {
            toNative.enter();
            interop.toNative(functionPointer);
        }
        try {
            pointer = interop.asPointer(functionPointer);
        }
        catch (UnsupportedMessageException e) {
            error.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{functionPointer}, (String)"functionPointer", (Throwable)e);
        }
        return functionExecute.execute(pointer, this, args);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object createClosure(LibFFISignature signature, Object executable, @CachedContext(value=NFILanguageImpl.class) TruffleLanguage.ContextReference<NFIContext> ctxRef) {
        return LibFFIClosure.create(signature, executable, ctxRef);
    }

    @CompilerDirectives.TruffleBoundary
    public static CachedSignatureInfo prepareSignatureInfo(NFILanguageImpl language, LibFFIType.CachedTypeInfo retTypeInfo, ArgsState state) {
        LibFFIType.Direction allowedCallDirection;
        if (retTypeInfo instanceof LibFFIType.ArrayType) {
            throw new IllegalArgumentException("array type as return value is not supported");
        }
        boolean allowJavaToNativeCall = state.allowJavaToNativeCall;
        boolean allowNativeToJavaCall = state.allowNativeToJavaCall;
        switch (retTypeInfo.allowedDataFlowDirection) {
            case JAVA_TO_NATIVE_ONLY: {
                allowJavaToNativeCall = false;
                break;
            }
            case NATIVE_TO_JAVA_ONLY: {
                allowNativeToJavaCall = false;
            }
        }
        if (allowNativeToJavaCall) {
            allowedCallDirection = allowJavaToNativeCall ? LibFFIType.Direction.BOTH : LibFFIType.Direction.NATIVE_TO_JAVA_ONLY;
        } else if (allowJavaToNativeCall) {
            allowedCallDirection = LibFFIType.Direction.JAVA_TO_NATIVE_ONLY;
        } else {
            throw new IllegalArgumentException("invalid signature");
        }
        LibFFIType.CachedTypeInfo[] argTypesInfo = new LibFFIType.CachedTypeInfo[state.argCount];
        ArgsState curState = state;
        for (int i = state.argCount - 1; i >= 0; --i) {
            argTypesInfo[i] = curState.lastArg;
            curState = curState.prev;
        }
        return new CachedSignatureInfo(language, retTypeInfo, argTypesInfo, state.primitiveSize, state.objectCount, allowedCallDirection);
    }

    private LibFFISignature(long cif, CachedSignatureInfo signatureInfo) {
        this.cif = cif;
        this.signatureInfo = signatureInfo;
    }

    @ExportLibrary(value=NFIBackendSignatureBuilderLibrary.class)
    static final class SignatureBuilder {
        static final int NOT_VARARGS = -1;
        ArgsState state = ArgsState.NO_ARGS;
        LibFFIType.CachedTypeInfo retTypeInfo;
        LibFFIType retType;
        ProfiledArrayBuilder<LibFFIType> argTypes;
        int fixedArgCount = -1;
        private static final ProfiledArrayBuilder.ArrayFactory<LibFFIType> FACTORY = new ProfiledArrayBuilder.ArrayFactory<LibFFIType>(){

            public LibFFIType[] create(int size) {
                return new LibFFIType[size];
            }
        };

        SignatureBuilder(ProfiledArrayBuilder.ArrayBuilderFactory factory) {
            this.argTypes = factory.allocate(FACTORY);
        }

        void addArg(LibFFIType arg, ArgsState newState) {
            assert (this.state.argCount + 1 == newState.argCount);
            this.argTypes.add(arg);
            this.state = newState;
        }

        @ExportMessage
        void makeVarargs() {
            this.fixedArgCount = this.state.argCount;
        }

        @ExportMessage
        @ImportStatic(value={LibFFISignature.class})
        static class Build {
            Build() {
            }

            @Specialization(guards={"builder.state == cachedState", "builder.retTypeInfo == cachedRetType"})
            static Object doCached(SignatureBuilder builder, @Cached(value="builder.state") ArgsState cachedState, @Cached(value="builder.retType.typeInfo") LibFFIType.CachedTypeInfo cachedRetType, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx, @Cached(value="prepareSignatureInfo(ctx.language, cachedRetType, cachedState)") CachedSignatureInfo cachedSigInfo) {
                return LibFFISignature.create(ctx, cachedSigInfo, builder.retType, cachedState.argCount, builder.fixedArgCount, builder.argTypes.getFinalArray());
            }

            @Specialization(replaces={"doCached"})
            static Object doGeneric(SignatureBuilder builder, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx) {
                CachedSignatureInfo sigInfo = LibFFISignature.prepareSignatureInfo(ctx.language, builder.retType.typeInfo, builder.state);
                return LibFFISignature.create(ctx, sigInfo, builder.retType, builder.state.argCount, builder.fixedArgCount, builder.argTypes.getFinalArray());
            }
        }

        @ExportMessage
        static class AddArgument {
            AddArgument() {
            }

            @Specialization(guards={"builder.state == oldState", "argType.typeInfo == cachedTypeInfo"})
            static void doCached(SignatureBuilder builder, LibFFIType argType, @Cached(value="builder.state") ArgsState oldState, @Cached(value="argType.typeInfo") LibFFIType.CachedTypeInfo cachedTypeInfo, @Cached(value="oldState.addArg(cachedTypeInfo)") ArgsState newState) {
                assert (builder.state == oldState && argType.typeInfo == cachedTypeInfo);
                builder.addArg(argType, newState);
            }

            @Specialization(replaces={"doCached"})
            static void doGeneric(SignatureBuilder builder, LibFFIType argType) {
                ArgsState newState = builder.state.addArg(argType.typeInfo);
                builder.addArg(argType, newState);
            }
        }

        @ExportMessage
        static class SetReturnType {
            SetReturnType() {
            }

            @Specialization
            static void doSet(SignatureBuilder builder, LibFFIType retType) {
                builder.retType = retType;
                builder.retTypeInfo = retType.typeInfo;
            }
        }
    }

    static final class ArgsState {
        static final ArgsState NO_ARGS = new ArgsState(0, 0, 0, true, true, null, null);
        final int argCount;
        final int primitiveSize;
        final int objectCount;
        final boolean allowJavaToNativeCall;
        final boolean allowNativeToJavaCall;
        final LibFFIType.CachedTypeInfo lastArg;
        final ArgsState prev;

        ArgsState(int argCount, int primitiveSize, int objectCount, boolean allowJavaToNativeCall, boolean allowNativeToJavaCall, LibFFIType.CachedTypeInfo lastArg, ArgsState prev) {
            this.argCount = argCount;
            this.primitiveSize = primitiveSize;
            this.objectCount = objectCount;
            this.allowJavaToNativeCall = allowJavaToNativeCall;
            this.allowNativeToJavaCall = allowNativeToJavaCall;
            this.lastArg = lastArg;
            this.prev = prev;
        }

        ArgsState addArg(LibFFIType.CachedTypeInfo typeInfo) {
            if (typeInfo instanceof LibFFIType.VoidType) {
                throw new IllegalArgumentException("void is not a valid argument type");
            }
            boolean newAllowNativeToJavaCall = this.allowNativeToJavaCall;
            boolean newAllowJavaToNativeCall = this.allowJavaToNativeCall;
            switch (typeInfo.allowedDataFlowDirection) {
                case JAVA_TO_NATIVE_ONLY: {
                    newAllowNativeToJavaCall = false;
                    break;
                }
                case NATIVE_TO_JAVA_ONLY: {
                    newAllowJavaToNativeCall = false;
                }
            }
            int align = typeInfo.alignment;
            int newPrimitiveSize = this.primitiveSize;
            if (this.primitiveSize % align != 0) {
                newPrimitiveSize += align - this.primitiveSize % align;
            }
            int newObjectCount = this.objectCount + typeInfo.objectCount;
            return new ArgsState(this.argCount + 1, newPrimitiveSize += typeInfo.size, newObjectCount, newAllowJavaToNativeCall, newAllowNativeToJavaCall, typeInfo, this);
        }
    }

    static final class CachedSignatureInfo {
        final LibFFIType.CachedTypeInfo retType;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final LibFFIType.CachedTypeInfo[] argTypes;
        final int primitiveSize;
        final int objectCount;
        final LibFFIType.Direction allowedCallDirection;
        final CallTarget callTarget;

        CachedSignatureInfo(NFILanguageImpl language, LibFFIType.CachedTypeInfo retType, LibFFIType.CachedTypeInfo[] argTypes, int primitiveSize, int objectCount, LibFFIType.Direction allowedCallDirection) {
            this.retType = retType;
            this.argTypes = argTypes;
            this.primitiveSize = primitiveSize;
            this.objectCount = objectCount;
            this.allowedCallDirection = allowedCallDirection;
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new FunctionExecuteNode.SignatureExecuteNode(language, this));
        }

        NativeArgumentBuffer.Array prepareBuffer() {
            return new NativeArgumentBuffer.Array(this.primitiveSize, this.objectCount);
        }

        LibFFIType.CachedTypeInfo[] getArgTypes() {
            return this.argTypes;
        }

        LibFFIType.CachedTypeInfo getRetType() {
            return this.retType;
        }

        LibFFIType.Direction getAllowedCallDirection() {
            return this.allowedCallDirection;
        }

        Object execute(LibFFISignature signature, NFIContext ctx, long functionPointer, NativeArgumentBuffer.Array argBuffer) {
            assert (signature.signatureInfo == this);
            CompilerAsserts.partialEvaluationConstant((Object)this.retType);
            if (this.retType instanceof LibFFIType.ObjectType) {
                Object ret = ctx.executeObject(signature.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects);
                if (ret == null) {
                    return NativePointer.create(ctx.language, 0L);
                }
                return ret;
            }
            if (this.retType instanceof LibFFIType.SimpleType) {
                LibFFIType.SimpleType simpleType = (LibFFIType.SimpleType)this.retType;
                long ret = ctx.executePrimitive(signature.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects);
                return simpleType.fromPrimitive(ret);
            }
            NativeArgumentBuffer.Array retBuffer = new NativeArgumentBuffer.Array(this.retType.size, this.retType.objectCount);
            ctx.executeNative(signature.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects, retBuffer.prim);
            return this.retType.deserializeRet(retBuffer, ctx.language);
        }
    }
}

