/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.NFIRootNode;
import com.oracle.truffle.nfi.spi.NFIBackend;
import com.oracle.truffle.nfi.spi.types.NativeLibraryDescriptor;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFIRootNode.class)
final class NFIRootNodeFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    NFIRootNodeFactory() {
    }

    @GeneratedBy(value=NFIRootNode.LoadLibraryNode.class)
    static final class LoadLibraryNodeGen
    extends NFIRootNode.LoadLibraryNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private CachedData cached_cache;
        @Node.Child
        private IndirectCallNode generic_callNode_;

        private LoadLibraryNodeGen(NativeLibraryDescriptor descriptor) {
            super(descriptor);
        }

        @Override
        @ExplodeLoop
        protected Object execute(NFIBackend arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value == s1_.cachedBackend_) {
                            return this.doCached(arg0Value, s1_.cachedBackend_, s1_.callNode_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.doGeneric(arg0Value, this.generic_callNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(NFIBackend arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null && arg0Value != s1_.cachedBackend_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 5) {
                        s1_ = (CachedData)super.insert((Node)new CachedData(this.cached_cache));
                        s1_.cachedBackend_ = arg0Value;
                        s1_.callNode_ = s1_.insertAccessor(DirectCallNode.create((CallTarget)this.parseLibrary(s1_.cachedBackend_)));
                        this.cached_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doCached(arg0Value, s1_.cachedBackend_, s1_.callNode_);
                        return object;
                    }
                }
                this.generic_callNode_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arg0Value, this.generic_callNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static NFIRootNode.LoadLibraryNode create(NativeLibraryDescriptor descriptor) {
            return new LoadLibraryNodeGen(descriptor);
        }

        @GeneratedBy(value=NFIRootNode.LoadLibraryNode.class)
        private static final class CachedData
        extends Node {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            NFIBackend cachedBackend_;
            @Node.Child
            DirectCallNode callNode_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=NFIRootNode.LookupAndBindNode.class)
    static final class LookupAndBindNodeGen
    extends NFIRootNode.LookupAndBindNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private InteropLibrary symInterop;
        @Node.Child
        private InteropLibrary lookupAndBind0_libInterop_;

        private LookupAndBindNodeGen(String name, String signature) {
            super(name, signature);
        }

        @Override
        Object execute(Object arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && this.lookupAndBind0_libInterop_.accepts(arg0Value)) {
                    return this.doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                }
                if ((state_0 & 2) != 0) {
                    return this.lookupAndBind1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object lookupAndBind1Boundary(int state_0, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary lookupAndBind1_libInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                Object object = this.doLookupAndBind(arg0Value, lookupAndBind1_libInterop__, this.symInterop);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                Object object;
                if (exclude == 0) {
                    boolean LookupAndBind0_duplicateFound_ = false;
                    if ((state_0 & 1) != 0 && this.lookupAndBind0_libInterop_.accepts(arg0Value)) {
                        LookupAndBind0_duplicateFound_ = true;
                    }
                    if (!LookupAndBind0_duplicateFound_ && (state_0 & 1) == 0) {
                        this.lookupAndBind0_libInterop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value)));
                        if (this.symInterop == null) {
                            this.symInterop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                        }
                        this.state_0_ = state_0 |= 1;
                        LookupAndBind0_duplicateFound_ = true;
                    }
                    if (LookupAndBind0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                        return object2;
                    }
                }
                InteropLibrary lookupAndBind1_libInterop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    lookupAndBind1_libInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    if (this.symInterop == null) {
                        this.symInterop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.exclude_ = exclude |= 1;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.doLookupAndBind(arg0Value, lookupAndBind1_libInterop__, this.symInterop);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static NFIRootNode.LookupAndBindNode create(String name, String signature) {
            return new LookupAndBindNodeGen(name, signature);
        }
    }
}

