/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory;
import com.oracle.truffle.nfi.NFIClosure;
import com.oracle.truffle.nfi.NFISignature;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFIClosure.class)
final class NFIClosureGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private NFIClosureGen() {
    }

    static {
        LibraryExport.register(NFIClosure.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=NFIClosure.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NFIClosure.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFIClosure);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NFIClosure);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFIClosure.class)
        private static final class Uncached
        extends InteropLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFIClosure) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIClosure;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                if (arg0Value.signature.cachedState != null) {
                    return NFIClosure.Execute.doOptimizedIndirect(arg0Value, arg1Value, IndirectCallNode.getUncached());
                }
                if (arg0Value.signature.cachedState == null) {
                    return NFIClosure.Execute.doSlowPath(arg0Value, arg1Value, BranchProfile.getUncached(), ConvertTypeNodeFactory.ConvertFromNativeNodeGen.getUncached(), ConvertTypeNodeFactory.ConvertToNativeNodeGen.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.executable));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                return arg0Value.isExecutable((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.executable));
            }
        }

        @GeneratedBy(value=NFIClosure.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private InteropLibrary receiverExecutableInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private ExecuteOptimizedDirectData execute_optimizedDirect_cache;
            @Node.Child
            private IndirectCallNode execute_optimizedIndirect_call_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile execute_slowPath_exception_;
            @Node.Child
            private ConvertTypeNode.ConvertFromNativeNode execute_slowPath_convertArg_;
            @Node.Child
            private ConvertTypeNode.ConvertToNativeNode execute_slowPath_convertRet_;

            protected Cached(Object receiver) {
                NFIClosure castReceiver = (NFIClosure)receiver;
                this.receiverExecutableInteropLibrary_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(castReceiver.executable)));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFIClosure) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFIClosure)) {
                    return false;
                }
                return this.receiverExecutableInteropLibrary_.accepts(((NFIClosure)receiver).executable);
            }

            @ExplodeLoop
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (arg0Value_ instanceof NFIClosure) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg0Value.signature.cachedState != null) {
                        ExecuteOptimizedDirectData s1_ = this.execute_optimizedDirect_cache;
                        while (s1_ != null) {
                            if (arg0Value.signature.cachedState == s1_.cachedState_) {
                                return NFIClosure.Execute.doOptimizedDirect(arg0Value, arg1Value, s1_.cachedState_, s1_.call_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && arg0Value.signature.cachedState != null) {
                        return NFIClosure.Execute.doOptimizedIndirect(arg0Value, arg1Value, this.execute_optimizedIndirect_call_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value.signature.cachedState == null) {
                        InteropLibrary execute_slowPath_interop__ = this.receiverExecutableInteropLibrary_;
                        return NFIClosure.Execute.doSlowPath(arg0Value, arg1Value, this.execute_slowPath_exception_, this.execute_slowPath_convertArg_, this.execute_slowPath_convertRet_, execute_slowPath_interop__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIClosure arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    if (exclude == 0 && arg0Value.signature.cachedState != null) {
                        int count1_ = 0;
                        ExecuteOptimizedDirectData s1_ = this.execute_optimizedDirect_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null && arg0Value.signature.cachedState != s1_.cachedState_) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = (ExecuteOptimizedDirectData)super.insert((Node)new ExecuteOptimizedDirectData(this.execute_optimizedDirect_cache));
                            s1_.cachedState_ = arg0Value.signature.cachedState;
                            s1_.call_ = s1_.insertAccessor(s1_.cachedState_.createOptimizedClosureCall());
                            this.execute_optimizedDirect_cache = s1_;
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = NFIClosure.Execute.doOptimizedDirect(arg0Value, arg1Value, s1_.cachedState_, s1_.call_);
                            return object;
                        }
                    }
                    if (arg0Value.signature.cachedState != null) {
                        this.execute_optimizedIndirect_call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                        this.exclude_ = exclude |= 1;
                        this.execute_optimizedDirect_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object count1_ = NFIClosure.Execute.doOptimizedIndirect(arg0Value, arg1Value, this.execute_optimizedIndirect_call_);
                        return count1_;
                    }
                    InteropLibrary execute_slowPath_interop__ = null;
                    if (arg0Value.signature.cachedState == null) {
                        this.execute_slowPath_exception_ = BranchProfile.create();
                        this.execute_slowPath_convertArg_ = (ConvertTypeNode.ConvertFromNativeNode)super.insert((Node)ConvertTypeNodeFactory.ConvertFromNativeNodeGen.create());
                        this.execute_slowPath_convertRet_ = (ConvertTypeNode.ConvertToNativeNode)super.insert((Node)ConvertTypeNodeFactory.ConvertToNativeNodeGen.create());
                        execute_slowPath_interop__ = this.receiverExecutableInteropLibrary_;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        Object object = NFIClosure.Execute.doSlowPath(arg0Value, arg1Value, this.execute_slowPath_exception_, this.execute_slowPath_convertArg_, this.execute_slowPath_convertRet_, execute_slowPath_interop__);
                        return object;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                ExecuteOptimizedDirectData s1_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.execute_optimizedDirect_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (arg0Value_ instanceof NFIClosure) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFIClosure arg0Value = (NFIClosure)arg0Value_;
                InteropLibrary isExecutableNode__interop__ = this.receiverExecutableInteropLibrary_;
                return arg0Value.isExecutable(isExecutableNode__interop__);
            }

            @GeneratedBy(value=NFIClosure.class)
            private static final class ExecuteOptimizedDirectData
            extends Node {
                @Node.Child
                ExecuteOptimizedDirectData next_;
                @CompilerDirectives.CompilationFinal
                NFISignature.SignatureCachedState cachedState_;
                @Node.Child
                CallSignatureNode call_;

                ExecuteOptimizedDirectData(ExecuteOptimizedDirectData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

