/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.uisupport;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLabelUI;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.CloseButton;
import org.graalvm.visualvm.uisupport.Bundle;
import sun.swing.SwingUtilities2;

public class ProfilerTabbedPane
extends JTabbedPane {
    private static final boolean IS_AQUA = UIUtils.isAquaLookAndFeel();
    private static final boolean IS_GTK = UIUtils.isGTKLookAndFeel();

    public ProfilerTabbedPane() {
        this.setFocusable(false);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!ProfilerTabbedPane.this.mouseWheelScrolls()) {
                    return;
                }
                int units = e.getWheelRotation();
                int selected = ProfilerTabbedPane.this.getSelectedIndex();
                int newSelected = selected + units;
                if (newSelected < 0) {
                    newSelected = 0;
                } else if (newSelected >= ProfilerTabbedPane.this.getTabCount()) {
                    newSelected = ProfilerTabbedPane.this.getTabCount() - 1;
                }
                ProfilerTabbedPane.this.setSelectedIndex(newSelected);
            }
        });
    }

    public void addTab(String title, Icon icon, final Component component, String tip, boolean closable) {
        int tabCount = this.getTabCount();
        if (component.getMouseWheelListeners().length == 0 && UIUtils.isAquaLookAndFeel()) {
            component.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                }
            });
        }
        super.addTab(title, icon, component, tip);
        Runnable closer = closable ? new Runnable(){

            @Override
            public void run() {
                ProfilerTabbedPane.this.closeTab(component);
            }
        } : null;
        this.setTabComponentAt(tabCount, new TabCaption(title, icon, closer));
    }

    public void insertTab(String title, Icon icon, final Component component, String tip, boolean closable, int index) {
        if (component.getMouseWheelListeners().length == 0 && UIUtils.isAquaLookAndFeel()) {
            component.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                }
            });
        }
        super.insertTab(title, icon, component, tip, index);
        Runnable closer = closable ? new Runnable(){

            @Override
            public void run() {
                ProfilerTabbedPane.this.closeTab(component);
            }
        } : null;
        this.setTabComponentAt(index, new TabCaption(title, icon, closer));
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        this.tabCaptionAt(index).setTitle(title);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        this.tabCaptionAt(index).setIcon(icon);
    }

    @Override
    public void setForegroundAt(int index, Color foreground) {
        super.setForegroundAt(index, foreground);
        this.tabCaptionAt(index).setForeground(foreground);
    }

    @Override
    public Color getForegroundAt(int index) {
        return this.tabCaptionAt(index).getForeground();
    }

    boolean isClosableAt(int index) {
        return this.tabCaptionAt(index).isClosable();
    }

    protected boolean mouseWheelScrolls() {
        return UIUtils.isAquaLookAndFeel() || this.getTabLayoutPolicy() == 1;
    }

    protected void closeTab(Component component) {
        this.remove(this.indexOfComponent(component));
    }

    public void close(Component component) {
        this.closeTab(component);
    }

    public void closeOther(Component component) {
        for (Object[] comp : this.components()) {
            if (comp[1] == component || !((Boolean)comp[0]).booleanValue()) continue;
            this.close((Component)comp[1]);
        }
    }

    public void closeOtherToTheRight(Component component) {
        boolean visited = false;
        for (Object[] comp : this.components()) {
            if (comp[1] == component) {
                visited = true;
                continue;
            }
            if (!visited || !((Boolean)comp[0]).booleanValue()) continue;
            this.close((Component)comp[1]);
        }
    }

    public void closeAll() {
        for (Object[] comp : this.components()) {
            if (!((Boolean)comp[0]).booleanValue()) continue;
            this.close((Component)comp[1]);
        }
    }

    private Object[][] components() {
        int componentCount = this.getTabCount();
        Object[][] components = new Object[componentCount][2];
        for (int i = 0; i < this.getTabCount(); ++i) {
            components[i][0] = this.isClosableAt(i);
            components[i][1] = this.getComponentAt(i);
        }
        return components;
    }

    private TabCaption tabCaptionAt(int index) {
        return (TabCaption)this.getTabComponentAt(index);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int index = this.indexAtLocation(e.getX(), e.getY());
        if (index != -1) {
            if (e.isPopupTrigger()) {
                final MouseEvent _e = e;
                final int _index = index;
                final Component _component = this.getComponentAt(index);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerTabbedPane.this.showPopupMenu(_index, _component, _e);
                    }
                });
                e.consume();
                return;
            }
            if (e.getID() == 500 && SwingUtilities.isMiddleMouseButton(e)) {
                if (this.isClosableAt(index)) {
                    this.closeTab(this.getComponentAt(index));
                }
                e.consume();
                return;
            }
            if (e.getID() == 501 && !SwingUtilities.isLeftMouseButton(e)) {
                e.consume();
                return;
            }
        }
        super.processMouseEvent(e);
    }

    private void showPopupMenu(int index, Component component, MouseEvent e) {
        JPopupMenu popup = new JPopupMenu(){};
        this.populatePopup(popup, index, component);
        if (popup.getComponentCount() > 0 && e != null) {
            popup.show(this, e.getX(), e.getY());
        }
    }

    private void populatePopup(JPopupMenu popup, int index, final Component component) {
        boolean anyClosable = false;
        boolean otherClosable = false;
        boolean otherToTheRightClosable = false;
        boolean visited = false;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component c = this.getComponentAt(i);
            boolean invoker = c == component;
            boolean closable = this.isClosableAt(i);
            if (closable) {
                anyClosable = true;
                if (!invoker) {
                    otherClosable = true;
                }
                if (visited) {
                    otherToTheRightClosable = true;
                }
                if (otherToTheRightClosable) break;
            }
            if (!invoker) continue;
            visited = true;
        }
        final boolean _closable = this.isClosableAt(index);
        final boolean _anyClosable = anyClosable;
        final boolean _otherClosable = otherClosable;
        final boolean _otherToTheRightClosable = otherToTheRightClosable;
        popup.add(new JMenuItem(Bundle.ProfilerTabbedPane_Close()){
            {
                super(x0);
                this.setEnabled(_closable);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerTabbedPane.this.close(component);
            }
        });
        popup.addSeparator();
        popup.add(new JMenuItem(Bundle.ProfilerTabbedPane_CloseOther()){
            {
                super(x0);
                this.setEnabled(_otherClosable);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerTabbedPane.this.closeOther(component);
            }
        });
        popup.add(new JMenuItem(Bundle.ProfilerTabbedPane_CloseOtherRight()){
            {
                super(x0);
                this.setEnabled(_otherToTheRightClosable);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerTabbedPane.this.closeOtherToTheRight(component);
            }
        });
        popup.addSeparator();
        popup.add(new JMenuItem(Bundle.ProfilerTabbedPane_CloseAll()){
            {
                super(x0);
                this.setEnabled(_anyClosable);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerTabbedPane.this.closeAll();
            }
        });
    }

    private class TabCaption
    extends JPanel {
        private JLabel caption;

        TabCaption(String text, Icon icon, Runnable closer) {
            this.setFocusable(false);
            this.setOpaque(false);
            if (IS_AQUA) {
                this.setBorder(BorderFactory.createEmptyBorder(ProfilerTabbedPane.this.getTabPlacement() == 3 ? 1 : 0, 0, 0, closer == null ? -2 : 0));
            } else if (IS_GTK) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, closer == null ? 1 : 0));
            } else if (UIUtils.isWindowsLookAndFeel()) {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, closer == null ? 1 : 0));
            } else if (UIUtils.isMetalLookAndFeel()) {
                this.setBorder(BorderFactory.createEmptyBorder(ProfilerTabbedPane.this.getTabPlacement() == 3 ? 1 : 2, 0, 0, 0));
            }
            this.setLayout(new BoxLayout(this, 2));
            this.caption = new JLabel(text, icon, 10);
            this.caption.setUI(new BasicLabelUI(){

                @Override
                protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
                    Window w = IS_AQUA ? SwingUtilities.getWindowAncestor(TabCaption.this) : null;
                    boolean focused = w == null ? true : w.isFocused();
                    int selectedIndex = ProfilerTabbedPane.this.getSelectedIndex();
                    boolean selected = ProfilerTabbedPane.this.getTabComponentAt(selectedIndex) == TabCaption.this;
                    g.setFont(l.getFont());
                    if (focused && selected) {
                        Color foreground;
                        Color shadow = UIManager.getColor("TabbedPane.selectedTabTitleShadowNormalColor");
                        if (shadow != null) {
                            g.setColor(shadow);
                            SwingUtilities2.drawString((JComponent)l, g, s, textX, textY + 1);
                        }
                        if ((foreground = UIManager.getColor("TabbedPane.selectedTabTitleNormalColor")) != null) {
                            g.setColor(foreground);
                            SwingUtilities2.drawString((JComponent)l, g, s, textX, textY);
                        } else {
                            super.paintEnabledText(l, g, s, textX, textY);
                        }
                    } else {
                        Color foreground = UIManager.getColor("TabbedPane.nonSelectedTabTitleNormalColor");
                        if (foreground != null) {
                            g.setColor(foreground);
                            SwingUtilities2.drawString((JComponent)l, g, s, textX, textY);
                        } else {
                            super.paintEnabledText(l, g, s, textX, textY);
                        }
                    }
                }
            });
            this.add(this.caption);
            if (closer != null) {
                this.add(Box.createHorizontalStrut(5));
                this.add(Box.createHorizontalGlue());
                JPanel p = new JPanel(new BorderLayout()){

                    @Override
                    public Dimension getMinimumSize() {
                        Dimension dim = super.getMinimumSize();
                        dim.height = ((TabCaption)TabCaption.this).caption.getPreferredSize().height;
                        return dim;
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return this.getMinimumSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getMinimumSize();
                    }
                };
                p.setOpaque(false);
                p.add((Component)CloseButton.createSmall((Runnable)closer), "Center");
                this.add(p);
            }
        }

        boolean isClosable() {
            return this.getComponentCount() > 1;
        }

        private void setTitle(String title) {
            this.caption.setText(title);
        }

        private void setIcon(Icon icon) {
            this.caption.setIcon(icon);
        }

        @Override
        public void setForeground(Color foreground) {
            if (this.caption == null) {
                super.setForeground(foreground);
            } else {
                this.caption.setForeground(foreground);
            }
        }

        @Override
        public Color getForeground() {
            return this.caption == null ? super.getForeground() : this.caption.getForeground();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (IS_GTK) {
                dim.height = super.getMinimumSize().height;
            }
            return dim;
        }
    }
}

