/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraalRepeated;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleToLibGraal;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerRuntimeGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.LibGraalObjectHandles;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.WordFactory;

final class HSTruffleCompilerRuntime
extends HSObject
implements HotSpotTruffleCompilerRuntime {
    private final ResolvedJavaType classLoaderDelegate;
    private final OptionValues initialOptions;
    private final ConcurrentHashMap<ResolvedJavaMethod, MethodCache> methodCache = new ConcurrentHashMap();
    private volatile JavaKind[] frameSlotKindToTag;
    private volatile int[] javaKindToTag;

    HSTruffleCompilerRuntime(JNI.JNIEnv env, JNI.JObject handle, ResolvedJavaType classLoaderDelegate, OptionValues options) {
        super(env, handle);
        this.classLoaderDelegate = classLoaderDelegate;
        this.initialOptions = options;
    }

    private MethodCache getMethodCache(ResolvedJavaMethod method) {
        return this.methodCache.computeIfAbsent(method, m -> new MethodCache(this.getLoopExplosionKindImpl(method), this.getInlineKindImpl(method, true), this.getInlineKindImpl(method, false), this.isTruffleBoundaryImpl(method), this.isBytecodeInterpreterSwitchImpl(method), this.isBytecodeInterpreterSwitchBoundaryImpl(method)));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateInliningPlan)
    public TruffleMetaAccessProvider createInliningPlan() {
        JNILibGraalScope scope = JNILibGraalScope.scopeOrNull();
        if (scope == null) {
            return null;
        }
        Object hsInliningPlan = HSTruffleCompilerRuntimeGen.callCreateInliningPlan(scope.getEnv(), this.getHandle());
        return new HSTruffleInliningPlan((JNILibGraalScope<TruffleToLibGraal.Id>)scope.narrow(TruffleToLibGraal.Id.class), (JNI.JObject)hsInliningPlan);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsCompilableTruffleAST)
    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        JNILibGraalScope scope = JNILibGraalScope.scopeOrNull();
        if (scope == null) {
            return null;
        }
        long constantHandle = LibGraal.translate((Object)constant);
        Object hsCompilable = HSTruffleCompilerRuntimeGen.callAsCompilableTruffleAST(scope.getEnv(), this.getHandle(), constantHandle);
        if (hsCompilable.isNull()) {
            return null;
        }
        return new HSCompilableTruffleAST((JNILibGraalScope<TruffleToLibGraal.Id>)scope.narrow(TruffleToLibGraal.Id.class), (JNI.JObject)hsCompilable);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCodeInstallation)
    public void onCodeInstallation(CompilableTruffleAST compilable, InstalledCode installedCode) {
        long installedCodeHandle = LibGraal.translate((Object)installedCode);
        JNI.JNIEnv env = JNILibGraalScope.env();
        HSTruffleCompilerRuntimeGen.callOnCodeInstallation(env, this.getHandle(), ((HSCompilableTruffleAST)compilable).getHandle(), installedCodeHandle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.RegisterOptimizedAssumptionDependency)
    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumption) {
        long optimizedAssumptionHandle = LibGraal.translate((Object)optimizedAssumption);
        JNI.JNIEnv env = JNILibGraalScope.env();
        Object assumptionConsumer = HSTruffleCompilerRuntimeGen.callRegisterOptimizedAssumptionDependency(env, this.getHandle(), optimizedAssumptionHandle);
        return assumptionConsumer.isNull() ? null : new HSConsumer((JNILibGraalScope<TruffleToLibGraal.Id>)JNILibGraalScope.scope().narrow(TruffleToLibGraal.Id.class), (JNI.JObject)assumptionConsumer);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallTargetForCallNode)
    public JavaConstant getCallTargetForCallNode(JavaConstant callNode) {
        long callNodeHandle = LibGraal.translate((Object)callNode);
        JNI.JNIEnv env = JNILibGraalScope.env();
        long callTargetHandle = HSTruffleCompilerRuntimeGen.callGetCallTargetForCallNode(env, this.getHandle(), callNodeHandle);
        return (JavaConstant)LibGraal.unhand(JavaConstant.class, (long)callTargetHandle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTruffleBoundary)
    public boolean isTruffleBoundary(ResolvedJavaMethod method) {
        MethodCache cache = this.getMethodCache(method);
        return cache.isTruffleBoundary;
    }

    private boolean isTruffleBoundaryImpl(ResolvedJavaMethod method) {
        return HSTruffleCompilerRuntimeGen.callIsTruffleBoundary(JNILibGraalScope.env(), this.getHandle(), LibGraal.translate((Object)method));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSpecializationMethod)
    public boolean isSpecializationMethod(ResolvedJavaMethod method) {
        return HSTruffleCompilerRuntimeGen.callIsSpecializationMethod(JNILibGraalScope.env(), this.getHandle(), LibGraal.translate((Object)method));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsBytecodeInterpreterSwitch)
    public boolean isBytecodeInterpreterSwitch(ResolvedJavaMethod method) {
        if (JNILibGraalScope.scope() != null) {
            MethodCache cache = this.getMethodCache(method);
            return cache.isBytecodeInterpreterSwitch;
        }
        return false;
    }

    private boolean isBytecodeInterpreterSwitchImpl(ResolvedJavaMethod method) {
        return HSTruffleCompilerRuntimeGen.callIsBytecodeInterpreterSwitch(JNILibGraalScope.env(), this.getHandle(), LibGraal.translate((Object)method));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsBytecodeInterpreterSwitchBoundary)
    public boolean isBytecodeInterpreterSwitchBoundary(ResolvedJavaMethod method) {
        if (JNILibGraalScope.scope() != null) {
            MethodCache cache = this.getMethodCache(method);
            return cache.isBytecodeInterpreterSwitchBoundary;
        }
        return false;
    }

    private boolean isBytecodeInterpreterSwitchBoundaryImpl(ResolvedJavaMethod method) {
        return HSTruffleCompilerRuntimeGen.callIsBytecodeInterpreterSwitchBoundary(JNILibGraalScope.env(), this.getHandle(), LibGraal.translate((Object)method));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsValueType)
    public boolean isValueType(ResolvedJavaType type) {
        return HSTruffleCompilerRuntimeGen.callIsValueType(JNILibGraalScope.env(), this.getHandle(), LibGraal.translate((Object)type));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetInlineKind)
    public TruffleCompilerRuntime.InlineKind getInlineKind(ResolvedJavaMethod method, boolean duringPartialEvaluation) {
        MethodCache cache = this.getMethodCache(method);
        if (duringPartialEvaluation) {
            return cache.inlineKindPE;
        }
        return cache.inlineKindNonPE;
    }

    private TruffleCompilerRuntime.InlineKind getInlineKindImpl(ResolvedJavaMethod original, boolean duringPartialEvaluation) {
        long methodHandle = LibGraal.translate((Object)original);
        int inlineKindOrdinal = HSTruffleCompilerRuntimeGen.callGetInlineKind(JNILibGraalScope.env(), this.getHandle(), methodHandle, duringPartialEvaluation);
        return TruffleCompilerRuntime.InlineKind.values()[inlineKindOrdinal];
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLoopExplosionKind)
    public TruffleCompilerRuntime.LoopExplosionKind getLoopExplosionKind(ResolvedJavaMethod method) {
        return this.getMethodCache((ResolvedJavaMethod)method).explosionKind;
    }

    private TruffleCompilerRuntime.LoopExplosionKind getLoopExplosionKindImpl(ResolvedJavaMethod method) {
        long methodHandle = LibGraal.translate((Object)method);
        int loopExplosionKindOrdinal = HSTruffleCompilerRuntimeGen.callGetLoopExplosionKind(JNILibGraalScope.env(), this.getHandle(), methodHandle);
        return TruffleCompilerRuntime.LoopExplosionKind.values()[loopExplosionKindOrdinal];
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetConstantFieldInfo)
    public TruffleCompilerRuntime.ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        ResolvedJavaType enclosingType = field.getDeclaringClass();
        boolean isStatic = field.isStatic();
        Object[] declaredFields = isStatic ? enclosingType.getStaticFields() : enclosingType.getInstanceFields(false);
        int fieldIndex = -1;
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!field.equals(declaredFields[i])) continue;
            fieldIndex = i;
            break;
        }
        if (fieldIndex == -1) {
            throw new IllegalStateException(String.format("%s field: %s declared in: %s is not in declared fields: %s", isStatic ? "Static" : "Instance", field, enclosingType, Arrays.toString(declaredFields)));
        }
        long typeHandle = LibGraal.translate((Object)enclosingType);
        int fieldInfoDimension = HSTruffleCompilerRuntimeGen.callGetConstantFieldInfo(JNILibGraalScope.env(), this.getHandle(), typeHandle, isStatic, fieldIndex);
        switch (fieldInfoDimension) {
            case -2147483648: {
                return null;
            }
            case -2: {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILDREN;
            }
            case -1: {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILD;
            }
        }
        return TruffleCompilerRuntime.ConstantFieldInfo.forDimensions((int)fieldInfoDimension);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetJavaKindForFrameSlotKind)
    public JavaKind getJavaKindForFrameSlotKind(int frameSlotTag) {
        JavaKind[] values = this.frameSlotKindToTag;
        if (values == null) {
            JavaKind[] newValues = new JavaKind[HSTruffleCompilerRuntimeGen.callGetFrameSlotKindTagsCount(JNILibGraalScope.env(), this.getHandle())];
            for (int tag = 0; tag < newValues.length; ++tag) {
                newValues[tag] = JavaKind.values()[HSTruffleCompilerRuntimeGen.callGetJavaKindForFrameSlotKind(JNILibGraalScope.env(), this.getHandle(), tag)];
            }
            values = newValues;
            this.frameSlotKindToTag = newValues;
        }
        return values[frameSlotTag];
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagForJavaKind)
    public int getFrameSlotKindTagForJavaKind(JavaKind kind) {
        int[] values = this.javaKindToTag;
        if (values == null) {
            int[] newValues = new int[JavaKind.values().length];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = HSTruffleCompilerRuntimeGen.callGetFrameSlotKindTagForJavaKind(JNILibGraalScope.env(), this.getHandle(), i);
            }
            values = newValues;
            this.javaKindToTag = newValues;
        }
        return values[kind.ordinal()];
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagsCount)
    public int getFrameSlotKindTagsCount() {
        JavaKind[] kinds = this.frameSlotKindToTag;
        if (kinds == null) {
            return HSTruffleCompilerRuntimeGen.callGetFrameSlotKindTagsCount(JNILibGraalScope.env(), this.getHandle());
        }
        return kinds.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetTruffleCallBoundaryMethods)
    public Iterable<ResolvedJavaMethod> getTruffleCallBoundaryMethods() {
        JNI.JNIEnv env = JNILibGraalScope.env();
        JNI.JLongArray handles = (JNI.JLongArray)HSTruffleCompilerRuntimeGen.callGetTruffleCallBoundaryMethods(env, this.getHandle());
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)handles);
        ArrayList<ResolvedJavaMethod> res = new ArrayList<ResolvedJavaMethod>();
        CLongPointer longs = JNIUtil.GetLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            for (int i = 0; i < len; ++i) {
                res.add((ResolvedJavaMethod)LibGraal.unhand(ResolvedJavaMethod.class, (long)longs.read(i)));
            }
        }
        finally {
            JNIUtil.ReleaseLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (CLongPointer)longs, (int)2);
        }
        return res;
    }

    public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className, boolean required) {
        String internalName = JNIUtil.getInternalName((String)className);
        JavaType jt = HotSpotJVMCIRuntime.runtime().lookupType(internalName, (HotSpotResolvedObjectType)this.classLoaderDelegate, true);
        if (jt instanceof UnresolvedJavaType) {
            if (required) {
                throw new NoClassDefFoundError(internalName);
            }
            return null;
        }
        return (ResolvedJavaType)jt;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.Log)
    public void log(String loggerId, CompilableTruffleAST compilable, String message) {
        JNI.JNIEnv env = JNILibGraalScope.env();
        JNI.JString jniLoggerId = JNIUtil.createHSString((JNI.JNIEnv)env, (String)loggerId);
        JNI.JString jniMessage = JNIUtil.createHSString((JNI.JNIEnv)env, (String)message);
        HSTruffleCompilerRuntimeGen.callLog(env, this.getHandle(), (JNI.JObject)jniLoggerId, ((HSCompilableTruffleAST)compilable).getHandle(), (JNI.JObject)jniMessage);
    }

    public <T> T getGraalOptions(Class<T> optionValuesType) {
        if (optionValuesType == OptionValues.class) {
            return optionValuesType.cast(this.initialOptions);
        }
        return (T)super.getGraalOptions(optionValuesType);
    }

    public TruffleCompiler getTruffleCompiler(CompilableTruffleAST compilable) {
        throw new UnsupportedOperationException("Should never be called in the compiler.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TruffleFromLibGraalRepeated(value={@TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateStringSupplier), @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSuppressedFailure)})
    public boolean isSuppressedFailure(CompilableTruffleAST compilable, Supplier<String> serializedException) {
        long serializedExceptionHandle = LibGraalObjectHandles.create(serializedException);
        boolean success = false;
        JNI.JNIEnv env = JNILibGraalScope.env();
        try {
            Object instance = HSTruffleCompilerRuntimeGen.callCreateStringSupplier(env, serializedExceptionHandle);
            boolean res = HSTruffleCompilerRuntimeGen.callIsSuppressedFailure(env, this.getHandle(), ((HSCompilableTruffleAST)compilable).getHandle(), instance);
            success = true;
            boolean bl = res;
            return bl;
        }
        finally {
            if (!success) {
                LibGraalObjectHandles.remove(serializedExceptionHandle);
            }
        }
    }

    private static class HSConsumer
    extends HSObject
    implements Consumer<OptimizedAssumptionDependency> {
        HSConsumer(JNILibGraalScope<TruffleToLibGraal.Id> scope, JNI.JObject handle) {
            super(scope, handle);
        }

        @Override
        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.ConsumeOptimizedAssumptionDependency)
        public void accept(OptimizedAssumptionDependency dependency) {
            JNI.JObject dependencyHandle = dependency == null ? (JNI.JObject)WordFactory.nullPointer() : ((HSCompilableTruffleAST)dependency).getHandle();
            HSTruffleCompilerRuntimeGen.callConsumeOptimizedAssumptionDependency(JNILibGraalScope.env(), this.getHandle(), dependencyHandle);
        }
    }

    static final class MethodCache {
        final TruffleCompilerRuntime.LoopExplosionKind explosionKind;
        final TruffleCompilerRuntime.InlineKind inlineKindPE;
        final TruffleCompilerRuntime.InlineKind inlineKindNonPE;
        final boolean isTruffleBoundary;
        final boolean isBytecodeInterpreterSwitch;
        final boolean isBytecodeInterpreterSwitchBoundary;

        MethodCache(TruffleCompilerRuntime.LoopExplosionKind explosionKind, TruffleCompilerRuntime.InlineKind inlineKindPE, TruffleCompilerRuntime.InlineKind inlineKindNonPE, boolean isTruffleBoundary, boolean isBytecodeInterpreterSwitch, boolean isBytecodeInterpreterSwitchBoundary) {
            this.explosionKind = explosionKind;
            this.inlineKindPE = inlineKindPE;
            this.inlineKindNonPE = inlineKindNonPE;
            this.isTruffleBoundary = isTruffleBoundary;
            this.isBytecodeInterpreterSwitch = isBytecodeInterpreterSwitch;
            this.isBytecodeInterpreterSwitchBoundary = isBytecodeInterpreterSwitchBoundary;
        }
    }
}

