/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.threading;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingBuiltins;

public final class SharedMemMessagingBindings
extends JSNonProxy {
    private static final SharedMemMessagingBindings INSTANCE = new SharedMemMessagingBindings();
    private static final JSBuiltinsContainer BUILTINS = new SharedMemMessagingBuiltins();
    private static final String CLASS_NAME = "SharedMemMessaging";

    private SharedMemMessagingBindings() {
    }

    public static GraalJSAccess getApiField(Instance self) {
        return self.graalJSAccess;
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject create(JSContext context, GraalJSAccess graalJSAccess) {
        Shape shape = context.makeEmptyShapeWithNullPrototype((JSClass)INSTANCE);
        Instance obj = new Instance(shape, graalJSAccess);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)context.getRealm(), (DynamicObject)obj, (JSBuiltinsContainer)BUILTINS);
        return obj;
    }

    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object createInitFunction(final GraalJSAccess graalJSAccess, final JSContext context) {
        JSRealm realm = context.getRealm();
        JavaScriptRootNode wrapperNode = new JavaScriptRootNode(){

            public Object execute(VirtualFrame frame) {
                return SharedMemMessagingBindings.create(context, graalJSAccess);
            }
        };
        JSFunctionData functionData = JSFunctionData.createCallOnly((JSContext)context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)wrapperNode), (int)2, (String)"SharedMemMessagingInit");
        return JSFunction.create((JSRealm)realm, (JSFunctionData)functionData);
    }

    public static final class Instance
    extends JSNonProxyObject {
        final GraalJSAccess graalJSAccess;

        protected Instance(Shape shape, GraalJSAccess graalJSAccess) {
            super(shape);
            this.graalJSAccess = graalJSAccess;
        }
    }
}

