/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.macho.MachOSymtab;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class ExportTrieElement
extends MachOObjectFile.LinkEditElement {
    private final MachOObjectFile owner;
    int totalNodesInTree;
    TrieNode root;

    ExportTrieElement(String name, MachOObjectFile owner) {
        MachOObjectFile machOObjectFile = owner;
        Objects.requireNonNull(machOObjectFile);
        super(name, owner.getLinkEditSegment());
        this.owner = owner;
        this.root = new TrieNode();
        this.root.suffix = "";
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return ObjectFile.defaultDependencies(decisions, this);
    }

    int commonPrefixLength(String s1, String s2) {
        int i;
        for (i = 0; s1.length() > i && s2.length() > i && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    private void addSymbol(String s, long addr) {
        TrieNode whereToCreateTerminal;
        TrieNode nodeToInsertAt;
        TrieNode longestPrefixNode = this.root.findLongestPrefixNode(s, 0);
        String longestPrefixValue = longestPrefixNode.value();
        if (longestPrefixValue.equals(s)) assert (longestPrefixNode.terminal == null);
        TrieNode childWithPrefix = null;
        int childPrefixLength = 0;
        int childPosition = 0;
        for (TrieNode child : longestPrefixNode.children) {
            childPrefixLength = this.commonPrefixLength(child.suffix, s.substring(longestPrefixValue.length()));
            if (childPrefixLength > 0) {
                assert (childWithPrefix == null);
                childWithPrefix = child;
                break;
            }
            ++childPosition;
        }
        if (childWithPrefix == null) {
            childPosition = -1;
        }
        if (childWithPrefix != null) {
            assert (childPrefixLength > 0);
            String suffixToInsert = childWithPrefix.suffix.substring(0, childPrefixLength);
            String newChildSuffix = childWithPrefix.suffix.substring(childPrefixLength);
            assert (longestPrefixNode.children.indexOf(childWithPrefix) == childPosition);
            assert (longestPrefixNode.children.lastIndexOf(childWithPrefix) == childPosition);
            longestPrefixNode.children.remove(childPosition);
            assert (longestPrefixNode.children.indexOf(childWithPrefix) == -1);
            TrieNode newChild = new TrieNode(longestPrefixNode, null);
            assert (newChild.children.size() == 0);
            childWithPrefix.suffix = newChildSuffix;
            childWithPrefix.parent = newChild;
            newChild.children.add(childWithPrefix);
            assert (newChild.children.size() == 1);
            newChild.suffix = suffixToInsert;
            nodeToInsertAt = newChild;
        } else {
            nodeToInsertAt = longestPrefixNode;
        }
        String stringToInsertAt = nodeToInsertAt.value();
        if (s.length() > stringToInsertAt.length()) {
            whereToCreateTerminal = new TrieNode(nodeToInsertAt, null);
            whereToCreateTerminal.suffix = s.substring(stringToInsertAt.length());
        } else {
            whereToCreateTerminal = nodeToInsertAt;
        }
        assert (whereToCreateTerminal.terminal == null);
        whereToCreateTerminal.terminal = new TrieTerminal();
        whereToCreateTerminal.terminal.address = addr;
        whereToCreateTerminal.terminal.terminalFlags = 0;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        for (MachOSymtab.Entry ent : ((MachOObjectFile.LinkEditSegment64Command)this.owner.getLinkEditSegment()).getSymtab().getSortedEntries()) {
            if (!ent.isExternal() || !ent.isDefined()) continue;
            long symbolVaddr = (long)((Integer)alreadyDecided.get(ent.getDefinedSection()).getDecidedValue(LayoutDecision.Kind.VADDR)).intValue() + ent.getDefinedOffset();
            this.addSymbol(ent.getNameInObject(), symbolVaddr);
        }
        OutputAssembler oa = AssemblyBuffer.createOutputAssembler(this.getOwner().getByteOrder());
        this.root.writeRoot(oa);
        return oa.getBlob();
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return ((byte[])alreadyDecided.get(this).getDecidedValue(LayoutDecision.Kind.CONTENT)).length;
    }

    class TrieNode {
        TrieTerminal terminal;
        String suffix;
        List<TrieNode> children;
        TrieNode parent;

        private int encodedTerminalSize() {
            return this.terminal == null ? 0 : 1 + MachOObjectFile.encodedLengthLEB128(this.terminal.address);
        }

        private int worstCaseChildRecordSize(int childNum) {
            String childSuffix = this.children.get((int)childNum).suffix;
            int nullTerminatorSize = 1;
            return (childSuffix == null ? 0 : childSuffix.length()) + nullTerminatorSize + 10;
        }

        private int worstCaseNodeRecordSize() {
            int childRecords = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                childRecords += this.worstCaseChildRecordSize(i);
            }
            return 1 + this.encodedTerminalSize() + 1 + childRecords;
        }

        void writeRoot(OutputAssembler out) {
            assert (this == ExportTrieElement.this.root);
            ArrayDeque<TrieNode> nodes = new ArrayDeque<TrieNode>();
            ArrayDeque<Integer> offsetUpperBounds = new ArrayDeque<Integer>();
            HashMap<TrieNode, Integer> upperBoundsByNode = new HashMap<TrieNode, Integer>();
            HashMap<TrieNode, Integer> offsetsByWrittenNode = new HashMap<TrieNode, Integer>();
            HashMap<TrieNode, Integer> childPointerOffsets = new HashMap<TrieNode, Integer>();
            HashMap<TrieNode, Integer> childPointerGapSizes = new HashMap<TrieNode, Integer>();
            nodes.addLast(ExportTrieElement.this.root);
            offsetUpperBounds.addLast(0);
            upperBoundsByNode.put(ExportTrieElement.this.root, 0);
            while (!nodes.isEmpty()) {
                TrieNode node = (TrieNode)nodes.removeFirst();
                int ourUpperBound = (Integer)offsetUpperBounds.removeFirst();
                upperBoundsByNode.remove(node);
                int nodeStartPos = out.pos();
                assert (ourUpperBound >= nodeStartPos);
                out.skip(1);
                int terminalStartPos = out.pos();
                if (node.terminal != null) {
                    node.terminal.write(out);
                }
                int terminalSize = out.pos() - terminalStartPos;
                out.pushSeek(nodeStartPos);
                out.writeByte((byte)terminalSize);
                out.pop();
                offsetsByWrittenNode.put(node, nodeStartPos);
                assert (node.children.size() <= 255);
                out.writeByte((byte)node.children.size());
                for (TrieNode child : node.children) {
                    nodes.addLast(child);
                    int childUpperBound = offsetUpperBounds.size() == 0 ? nodeStartPos + node.worstCaseNodeRecordSize() : (Integer)offsetUpperBounds.peekLast() + ((TrieNode)nodes.peekLast()).worstCaseNodeRecordSize();
                    offsetUpperBounds.addLast(childUpperBound);
                    upperBoundsByNode.put(child, childUpperBound);
                }
                for (TrieNode child : node.children) {
                    out.writeString(child.suffix);
                    int childPointerPos = out.pos();
                    int gapSize = MachOObjectFile.encodedLengthLEB128(((Integer)upperBoundsByNode.get(child)).intValue());
                    out.skip(gapSize);
                    childPointerOffsets.put(child, childPointerPos);
                    childPointerGapSizes.put(child, gapSize);
                }
                if (node == ExportTrieElement.this.root) continue;
                int pointerOffset = (Integer)childPointerOffsets.get(node);
                int gapSize = (Integer)childPointerGapSizes.get(node);
                assert (MachOObjectFile.encodedLengthLEB128(nodeStartPos) <= gapSize);
                out.pushSeek(pointerOffset);
                out.writeLEB128(nodeStartPos);
                out.pop();
                childPointerOffsets.remove(node);
                childPointerGapSizes.remove(node);
            }
            assert (childPointerOffsets.isEmpty());
            assert (childPointerGapSizes.isEmpty());
            assert (nodes.isEmpty());
            assert (offsetUpperBounds.isEmpty());
            assert (upperBoundsByNode.isEmpty());
            assert (offsetsByWrittenNode.size() == ExportTrieElement.this.totalNodesInTree);
        }

        TrieNode() {
            ++ExportTrieElement.this.totalNodesInTree;
            this.children = new ArrayList<TrieNode>();
            this.suffix = null;
            this.terminal = null;
            this.parent = null;
        }

        TrieNode(TrieNode parent, TrieTerminal term) {
            ++ExportTrieElement.this.totalNodesInTree;
            this.children = new ArrayList<TrieNode>();
            parent.children.add(this);
            this.terminal = term;
            this.parent = parent;
        }

        TrieNode findLongestPrefixNode(String s, int startPos) {
            for (TrieNode child : this.children) {
                assert (child.suffix != null);
                if (!s.substring(startPos).startsWith(child.suffix)) continue;
                return child.findLongestPrefixNode(s, startPos + child.suffix.length());
            }
            return this;
        }

        String value() {
            ArrayList<TrieNode> ancestors = new ArrayList<TrieNode>();
            TrieNode cur = this;
            do {
                ancestors.add(cur);
            } while ((cur = cur.parent) != null);
            StringBuilder sb = new StringBuilder();
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                String ancestorSuffix = ((TrieNode)ancestors.get((int)i)).suffix;
                sb.append(ancestorSuffix == null ? "" : ancestorSuffix);
            }
            return sb.toString();
        }
    }

    class TrieTerminal {
        byte terminalFlags;
        long address;

        TrieTerminal() {
        }

        public void write(OutputAssembler oa) {
            oa.writeByte(this.terminalFlags);
            oa.writeLEB128(this.address);
        }
    }
}

