/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@NodeInfo(shortName="try-finally")
public class TryFinallyNode
extends StatementNode
implements ResumableNode {
    @Node.Child
    private JavaScriptNode tryBlock;
    @Node.Child
    private JavaScriptNode finallyBlock;
    @Node.Child
    private InteropLibrary exceptions;

    TryFinallyNode(JavaScriptNode tryBlock, JavaScriptNode finallyBlock) {
        this.tryBlock = tryBlock;
        this.finallyBlock = finallyBlock;
    }

    public static JavaScriptNode create(JavaScriptNode tryBlock, JavaScriptNode finallyBlock) {
        return new TryFinallyNode(tryBlock, finallyBlock);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return TryFinallyNode.create(TryFinallyNode.cloneUninitialized(this.tryBlock, materializedTags), TryFinallyNode.cloneUninitialized(this.finallyBlock, materializedTags));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Throwable throwable;
        Object result = null;
        try {
            result = this.tryBlock.execute(frame);
            throwable = null;
        }
        catch (ControlFlowException cfe) {
            throwable = cfe;
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                throwable = ex;
            }
            throw ex;
        }
        this.finallyBlock.executeVoid(frame);
        if (throwable != null) {
            throw JSRuntime.rethrow(throwable);
        }
        assert (result != null);
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        Throwable throwable;
        try {
            this.tryBlock.executeVoid(frame);
            throwable = null;
        }
        catch (ControlFlowException cfe) {
            throwable = cfe;
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                throwable = ex;
            }
            throw ex;
        }
        this.finallyBlock.executeVoid(frame);
        if (throwable != null) {
            throw JSRuntime.rethrow(throwable);
        }
    }

    @Override
    public Object resume(VirtualFrame frame) {
        Object result = EMPTY;
        Throwable throwable = null;
        Object state = this.getStateAndReset(frame);
        if (state == Undefined.instance) {
            try {
                result = this.tryBlock.execute(frame);
            }
            catch (YieldException e) {
                throw e;
            }
            catch (ControlFlowException cfe) {
                throwable = cfe;
            }
            catch (Throwable ex) {
                if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                    throwable = ex;
                }
                throw ex;
            }
        } else if (state instanceof Throwable) {
            throwable = (Throwable)state;
        }
        try {
            this.finallyBlock.execute(frame);
        }
        catch (YieldException e) {
            this.setState(frame, throwable);
            throw e;
        }
        if (throwable != null) {
            throw JSRuntime.rethrow(throwable);
        }
        return result;
    }

    private InteropLibrary exceptions() {
        InteropLibrary e = this.exceptions;
        if (e == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptions = e = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
        }
        return e;
    }
}

