/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle;

import java.util.Properties;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.ApplicationTypeFactory;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.sampler.truffle.ApplicationSamplerViewProvider;

public final class SamplerSupport {
    private static final String GRAALVM_ID = "GraalVM";
    private static SamplerSupport instance;
    private ApplicationSamplerViewProvider samplerViewProvider = new ApplicationSamplerViewProvider();

    public static synchronized SamplerSupport getInstance() {
        if (instance == null) {
            instance = new SamplerSupport();
        }
        return instance;
    }

    boolean supportsProfiling(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        if (!application.isLocalApplication()) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isBasicInfoSupported() || !jvm.isAttachable()) {
            return false;
        }
        ApplicationType appType = ApplicationTypeFactory.getApplicationTypeFor((Application)application);
        if (appType.getClass().getName().contains("GraalVMApplicationType")) {
            return true;
        }
        return this.isRunningOnGraalVM(jvm);
    }

    void selectSamplerView(Application application) {
        if (application == null) {
            return;
        }
        DataSourceView activeView = this.samplerViewProvider.view(application);
        if (activeView == null) {
            return;
        }
        DataSourceWindowManager.sharedInstance().selectView(activeView);
    }

    private SamplerSupport() {
        this.samplerViewProvider.initialize();
    }

    private boolean isRunningOnGraalVM(Jvm jvm) {
        if (jvm.getVmName().contains(GRAALVM_ID)) {
            return true;
        }
        if (jvm.isGetSystemPropertiesSupported()) {
            Properties props = jvm.getSystemProperties();
            String vendorVersion = props.getProperty("java.vendor.version", "");
            return vendorVersion.contains(GRAALVM_ID);
        }
        return false;
    }
}

