/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.ProtocolMessage;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class Response
extends ProtocolMessage {
    Response(JSONObject jsonData) {
        super(jsonData);
    }

    public int getRequestSeq() {
        return this.jsonData.getInt("request_seq");
    }

    public Response setRequestSeq(int requestSeq) {
        this.jsonData.put("request_seq", requestSeq);
        return this;
    }

    public boolean isSuccess() {
        return this.jsonData.getBoolean("success");
    }

    public Response setSuccess(boolean success) {
        this.jsonData.put("success", success);
        return this;
    }

    public String getCommand() {
        return this.jsonData.getString("command");
    }

    public Response setCommand(String command) {
        this.jsonData.put("command", command);
        return this;
    }

    public String getMessage() {
        return this.jsonData.optString("message", null);
    }

    public Response setMessage(String message) {
        this.jsonData.putOpt("message", message);
        return this;
    }

    public Object getBody() {
        return this.jsonData.opt("body");
    }

    public Response setBody(Object body) {
        this.jsonData.putOpt("body", body);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Response other = (Response)obj;
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.getType());
        hash = 53 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 53 * hash + Boolean.hashCode(this.isSuccess());
        hash = 53 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 53 * hash + Objects.hashCode(this.getMessage());
        }
        if (this.getBody() != null) {
            hash = 53 * hash + Objects.hashCode(this.getBody());
        }
        hash = 53 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static Response create(Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new Response(json);
    }
}

