/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.ProtocolMessage;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class Request
extends ProtocolMessage {
    Request(JSONObject jsonData) {
        super(jsonData);
    }

    public String getCommand() {
        return this.jsonData.getString("command");
    }

    public Request setCommand(String command) {
        this.jsonData.put("command", command);
        return this;
    }

    public Object getArguments() {
        return this.jsonData.opt("arguments");
    }

    public Request setArguments(Object arguments) {
        this.jsonData.putOpt("arguments", arguments);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getArguments(), other.getArguments())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.getType());
        hash = 67 * hash + Objects.hashCode(this.getCommand());
        if (this.getArguments() != null) {
            hash = 67 * hash + Objects.hashCode(this.getArguments());
        }
        hash = 67 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static Request create(String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("type", "request");
        json.put("command", command);
        json.put("seq", seq);
        return new Request(json);
    }
}

